/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.DirectExecutorService;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.metrics.MetricsVerifier;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.MetadataManager;
import org.apache.druid.server.coordinator.balancer.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.CachingCostBalancerStrategyConfig;
import org.apache.druid.server.coordinator.balancer.CachingCostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.DiskNormalizedCostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.RandomBalancerStrategyFactory;
import org.apache.druid.server.coordinator.config.CoordinatorKillConfigs;
import org.apache.druid.server.coordinator.config.CoordinatorPeriodConfig;
import org.apache.druid.server.coordinator.config.CoordinatorRunConfig;
import org.apache.druid.server.coordinator.config.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.config.HttpLoadQueuePeonConfig;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroups;
import org.apache.druid.server.coordinator.loading.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.coordinator.simulate.BlockingExecutorService;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.TestDruidLeaderSelector;
import org.apache.druid.server.coordinator.simulate.TestMetadataRuleManager;
import org.apache.druid.server.coordinator.simulate.TestSegmentLoadingHttpClient;
import org.apache.druid.server.coordinator.simulate.TestSegmentsMetadataManager;
import org.apache.druid.server.coordinator.simulate.TestServerInventoryView;
import org.apache.druid.server.coordinator.simulate.WrappingScheduledExecutorService;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.Duration;

public class CoordinatorSimulationBuilder {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper().setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));
    private String balancerStrategy;
    private CoordinatorDynamicConfig dynamicConfig = CoordinatorDynamicConfig.builder().build();
    private List<DruidServer> servers;
    private List<DataSegment> segments;
    private final Map<String, List<Rule>> datasourceRules = new HashMap<String, List<Rule>>();
    private boolean loadImmediately = false;
    private boolean autoSyncInventory = true;

    public CoordinatorSimulationBuilder withBalancer(String balancerStrategy) {
        this.balancerStrategy = balancerStrategy;
        return this;
    }

    public CoordinatorSimulationBuilder withServers(List<DruidServer> servers) {
        this.servers = servers;
        return this;
    }

    public CoordinatorSimulationBuilder withServers(DruidServer ... servers) {
        return this.withServers(Arrays.asList(servers));
    }

    public CoordinatorSimulationBuilder withSegments(List<DataSegment> segments) {
        this.segments = segments;
        return this;
    }

    public CoordinatorSimulationBuilder withRules(String datasource, Rule ... rules) {
        this.datasourceRules.put(datasource, Arrays.asList(rules));
        return this;
    }

    public CoordinatorSimulationBuilder withImmediateSegmentLoading(boolean loadImmediately) {
        this.loadImmediately = loadImmediately;
        return this;
    }

    public CoordinatorSimulationBuilder withAutoInventorySync(boolean autoSync) {
        this.autoSyncInventory = autoSync;
        return this;
    }

    public CoordinatorSimulationBuilder withDynamicConfig(CoordinatorDynamicConfig dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
        return this;
    }

    public CoordinatorSimulation build() {
        Preconditions.checkArgument((this.servers != null && !this.servers.isEmpty() ? 1 : 0) != 0, (Object)"Cannot run simulation for an empty cluster");
        TestServerInventoryView serverInventoryView = new TestServerInventoryView();
        this.servers.forEach(serverInventoryView::addServer);
        Environment env = new Environment(serverInventoryView, this.dynamicConfig, this.loadImmediately, this.autoSyncInventory, this.balancerStrategy);
        if (this.segments != null) {
            this.segments.forEach(env.segmentManager::addSegment);
        }
        this.datasourceRules.forEach((datasource, rules) -> env.ruleManager.overrideRule((String)datasource, (List<Rule>)rules, null));
        DruidCoordinator coordinator = new DruidCoordinator(env.coordinatorConfig, env.metadataManager, (ServerInventoryView)env.coordinatorInventoryView, (ServiceEmitter)env.serviceEmitter, (ScheduledExecutorFactory)env.executorFactory, null, env.loadQueueTaskMaster, env.loadQueueManager, (ServiceAnnouncer)new ServiceAnnouncer.Noop(), null, new CoordinatorCustomDutyGroups(Collections.emptySet()), env.lookupCoordinatorManager, (DruidLeaderSelector)env.leaderSelector, null, CentralizedDatasourceSchemaConfig.create(), new CompactionStatusTracker(OBJECT_MAPPER));
        return new SimulationImpl(coordinator, env);
    }

    private static class Environment {
        private final Lifecycle lifecycle = new Lifecycle("coord-sim");
        private final StubServiceEmitter serviceEmitter = new StubServiceEmitter("coordinator", "coordinator");
        private final AtomicReference<CoordinatorDynamicConfig> dynamicConfig = new AtomicReference();
        private final TestDruidLeaderSelector leaderSelector = new TestDruidLeaderSelector();
        private final ExecutorFactory executorFactory;
        private final TestSegmentsMetadataManager segmentManager = new TestSegmentsMetadataManager();
        private final TestMetadataRuleManager ruleManager = new TestMetadataRuleManager();
        private final LoadQueueTaskMaster loadQueueTaskMaster;
        private final SegmentLoadQueueManager loadQueueManager;
        private final TestServerInventoryView inventory;
        private final TestServerInventoryView coordinatorInventoryView;
        private final MetadataManager metadataManager;
        private final LookupCoordinatorManager lookupCoordinatorManager;
        private final DruidCoordinatorConfig coordinatorConfig;
        private final boolean loadImmediately;
        private final boolean autoSyncInventory;
        private final List<Object> mocks = new ArrayList<Object>();

        private Environment(TestServerInventoryView clusterInventory, CoordinatorDynamicConfig dynamicConfig, boolean loadImmediately, boolean autoSyncInventory, String balancerStrategy) {
            this.inventory = clusterInventory;
            this.loadImmediately = loadImmediately;
            this.autoSyncInventory = autoSyncInventory;
            this.executorFactory = new ExecutorFactory(loadImmediately);
            this.coordinatorInventoryView = autoSyncInventory ? clusterInventory : new TestServerInventoryView();
            TestSegmentLoadingHttpClient httpClient = new TestSegmentLoadingHttpClient(OBJECT_MAPPER, clusterInventory::getChangeHandlerForHost, this.executorFactory.create(1, "historical-loader-%d"));
            this.coordinatorConfig = new DruidCoordinatorConfig(new CoordinatorRunConfig(new Duration(1L), Duration.standardMinutes((long)1L)), new CoordinatorPeriodConfig(null, null), CoordinatorKillConfigs.DEFAULT, this.createBalancerStrategy(balancerStrategy), new HttpLoadQueuePeonConfig(null, null, null));
            this.loadQueueTaskMaster = new LoadQueueTaskMaster(OBJECT_MAPPER, this.executorFactory.create(1, "load-queue-%d"), (ExecutorService)this.executorFactory.create(1, "load-callback-%d"), this.coordinatorConfig.getHttpLoadQueuePeonConfig(), (HttpClient)httpClient);
            this.loadQueueManager = new SegmentLoadQueueManager((ServerInventoryView)this.coordinatorInventoryView, this.loadQueueTaskMaster);
            JacksonConfigManager jacksonConfigManager = this.mockConfigManager();
            this.setDynamicConfig(dynamicConfig);
            this.lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class);
            this.mocks.add(jacksonConfigManager);
            this.mocks.add(this.lookupCoordinatorManager);
            this.metadataManager = new MetadataManager(null, new CoordinatorConfigManager(jacksonConfigManager, null, null), (SegmentsMetadataManager)this.segmentManager, null, (MetadataRuleManager)this.ruleManager, null, null);
        }

        private void setUp() throws Exception {
            EmittingLogger.registerEmitter((ServiceEmitter)this.serviceEmitter);
            this.inventory.setUp();
            this.coordinatorInventoryView.setUp();
            this.lifecycle.start();
            this.leaderSelector.becomeLeader();
            EasyMock.replay((Object[])this.mocks.toArray());
        }

        private void tearDown() {
            EasyMock.verify((Object[])this.mocks.toArray());
            this.executorFactory.tearDown();
            this.lifecycle.stop();
        }

        private void setDynamicConfig(CoordinatorDynamicConfig dynamicConfig) {
            this.dynamicConfig.set(dynamicConfig);
        }

        private JacksonConfigManager mockConfigManager() {
            JacksonConfigManager jacksonConfigManager = (JacksonConfigManager)EasyMock.createMock(JacksonConfigManager.class);
            EasyMock.expect((Object)jacksonConfigManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.eq(CoordinatorDynamicConfig.class), (Object)((CoordinatorDynamicConfig)EasyMock.anyObject()))).andReturn(this.dynamicConfig).anyTimes();
            EasyMock.expect((Object)jacksonConfigManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.eq(DruidCompactionConfig.class), (Object)((DruidCompactionConfig)EasyMock.anyObject()))).andReturn(new AtomicReference<DruidCompactionConfig>(DruidCompactionConfig.empty())).anyTimes();
            return jacksonConfigManager;
        }

        private BalancerStrategyFactory createBalancerStrategy(String strategyName) {
            if (strategyName == null) {
                return new CostBalancerStrategyFactory();
            }
            switch (strategyName) {
                case "cost": {
                    return new CostBalancerStrategyFactory();
                }
                case "cachingCost": {
                    return this.buildCachingCostBalancerStrategy();
                }
                case "diskNormalized": {
                    return new DiskNormalizedCostBalancerStrategyFactory();
                }
                case "random": {
                    return new RandomBalancerStrategyFactory();
                }
            }
            throw new IAE("Unknown balancer stratgy: " + strategyName, new Object[0]);
        }

        private BalancerStrategyFactory buildCachingCostBalancerStrategy() {
            try {
                return new CachingCostBalancerStrategyFactory((ServerInventoryView)this.coordinatorInventoryView, this.lifecycle, new CachingCostBalancerStrategyConfig());
            }
            catch (Exception e) {
                throw new ISE((Throwable)e, "Error building balancer strategy", new Object[0]);
            }
        }
    }

    private static class ExecutorFactory
    implements ScheduledExecutorFactory {
        static final String HISTORICAL_LOADER = "historical-loader-%d";
        static final String LOAD_QUEUE_EXECUTOR = "load-queue-%d";
        static final String LOAD_CALLBACK_EXECUTOR = "load-callback-%d";
        static final String COORDINATOR_RUNNER = "Coordinator-Exec-HistoricalManagementDuties-%d";
        private final Map<String, BlockingExecutorService> blockingExecutors = new HashMap<String, BlockingExecutorService>();
        private final boolean directExecution;
        private BlockingExecutorService historicalLoader;
        private BlockingExecutorService loadQueueExecutor;
        private BlockingExecutorService loadCallbackExecutor;
        private BlockingExecutorService historicalDutiesRunner;

        private ExecutorFactory(boolean directExecution) {
            this.directExecution = directExecution;
        }

        public ScheduledExecutorService create(int corePoolSize, String nameFormat) {
            boolean isCoordinatorRunner = COORDINATOR_RUNNER.equals(nameFormat);
            Object executorService = this.directExecution && !isCoordinatorRunner ? new DirectExecutorService() : (ExecutorService)this.blockingExecutors.computeIfAbsent(nameFormat, BlockingExecutorService::new);
            return new WrappingScheduledExecutorService(nameFormat, (ExecutorService)executorService, !isCoordinatorRunner);
        }

        private BlockingExecutorService findExecutor(String nameFormat) {
            return this.blockingExecutors.get(nameFormat);
        }

        private void findExecutors() {
            this.historicalDutiesRunner = this.findExecutor(COORDINATOR_RUNNER);
            this.historicalLoader = this.findExecutor(HISTORICAL_LOADER);
            this.loadQueueExecutor = this.findExecutor(LOAD_QUEUE_EXECUTOR);
            this.loadCallbackExecutor = this.findExecutor(LOAD_CALLBACK_EXECUTOR);
        }

        private void tearDown() {
            this.blockingExecutors.values().forEach(BlockingExecutorService::shutdown);
        }
    }

    private static class SimulationImpl
    implements CoordinatorSimulation,
    CoordinatorSimulation.CoordinatorState,
    CoordinatorSimulation.ClusterState {
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final Environment env;
        private final DruidCoordinator coordinator;

        private SimulationImpl(DruidCoordinator coordinator, Environment env) {
            this.env = env;
            this.coordinator = coordinator;
        }

        @Override
        public void start() {
            if (!this.running.compareAndSet(false, true)) {
                throw new ISE("Simulation is already running", new Object[0]);
            }
            try {
                this.env.setUp();
                this.coordinator.start();
                this.env.executorFactory.findExecutors();
            }
            catch (Exception e) {
                throw new ISE((Throwable)e, "Exception while running simulation", new Object[0]);
            }
        }

        @Override
        public void stop() {
            this.coordinator.stop();
            this.env.leaderSelector.stopBeingLeader();
            this.env.tearDown();
        }

        @Override
        public CoordinatorSimulation.CoordinatorState coordinator() {
            return this;
        }

        @Override
        public CoordinatorSimulation.ClusterState cluster() {
            return this;
        }

        @Override
        public void runCoordinatorCycle() {
            this.verifySimulationRunning();
            this.env.serviceEmitter.flush();
            this.env.executorFactory.historicalDutiesRunner.finishNextPendingTasks(1);
        }

        @Override
        public void syncInventoryView() {
            this.verifySimulationRunning();
            Preconditions.checkState((!this.env.autoSyncInventory ? 1 : 0) != 0, (Object)"Cannot invoke syncInventoryView as simulation is running in auto-sync mode.");
            this.env.coordinatorInventoryView.sync(this.env.inventory);
        }

        @Override
        public void setDynamicConfig(CoordinatorDynamicConfig dynamicConfig) {
            this.env.setDynamicConfig(dynamicConfig);
        }

        @Override
        public void setRetentionRules(String datasource, Rule ... rules) {
            this.env.ruleManager.overrideRule(datasource, Arrays.asList(rules), new AuditInfo("sim", "sim", "sim", "localhost"));
        }

        @Override
        public DruidServer getInventoryView(String serverName) {
            return this.env.coordinatorInventoryView.getInventoryValue(serverName);
        }

        @Override
        public void loadQueuedSegments() {
            this.verifySimulationRunning();
            Preconditions.checkState((!this.env.loadImmediately ? 1 : 0) != 0, (Object)"Cannot invoke loadQueuedSegments as simulation is running in immediate loading mode.");
            BlockingExecutorService loadQueueExecutor = this.env.executorFactory.loadQueueExecutor;
            while (loadQueueExecutor.hasPendingTasks()) {
                loadQueueExecutor.finishAllPendingTasks();
                int loadedSegments = this.env.executorFactory.historicalLoader.finishAllPendingTasks();
                loadQueueExecutor.finishNextPendingTasks(loadedSegments);
                this.env.executorFactory.loadCallbackExecutor.finishAllPendingTasks();
            }
        }

        @Override
        public void removeServer(DruidServer server) {
            this.env.inventory.removeServer(server);
        }

        @Override
        public void addServer(DruidServer server) {
            this.env.inventory.addServer(server);
        }

        @Override
        public void addSegments(List<DataSegment> segments) {
            if (segments != null) {
                segments.forEach(this.env.segmentManager::addSegment);
            }
        }

        private void verifySimulationRunning() {
            if (!this.running.get()) {
                throw new ISE("Simulation hasn't been started yet.", new Object[0]);
            }
        }

        @Override
        public double getLoadPercentage(String datasource) {
            return (Double)this.coordinator.getDatasourceToLoadStatus().get(datasource);
        }

        @Override
        public MetricsVerifier getMetricsVerifier() {
            return this.env.serviceEmitter;
        }
    }
}

