/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public class BlockingExecutorService
implements ExecutorService {
    private static final Logger log = new Logger(BlockingExecutorService.class);
    private final String nameFormat;
    private final Queue<Task<?>> taskQueue = new ConcurrentLinkedQueue();
    private boolean isShutdown;

    public BlockingExecutorService(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    public boolean hasPendingTasks() {
        return !this.taskQueue.isEmpty();
    }

    public int finishNextPendingTask() {
        log.debug("[%s] Executing next pending task", new Object[]{this.nameFormat});
        Task<?> task = this.taskQueue.poll();
        if (task != null) {
            ((Task)task).executeNow();
            return 1;
        }
        return 0;
    }

    public int finishNextPendingTasks(int numTasksToExecute) {
        Task<?> task;
        int executedTaskCount;
        log.debug("[%s] Executing %d pending tasks", new Object[]{this.nameFormat, numTasksToExecute});
        for (executedTaskCount = 0; executedTaskCount < numTasksToExecute && (task = this.taskQueue.poll()) != null; ++executedTaskCount) {
            ((Task)task).executeNow();
        }
        return executedTaskCount;
    }

    public int finishAllPendingTasks() {
        Task<?> task;
        log.debug("[%s] Executing all pending tasks", new Object[]{this.nameFormat});
        int executedTaskCount = 0;
        while ((task = this.taskQueue.poll()) != null) {
            ((Task)task).executeNow();
            ++executedTaskCount;
        }
        return executedTaskCount;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.verifyNotShutdown();
        return this.addTaskToQueue(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.verifyNotShutdown();
        return this.addTaskToQueue(() -> {
            task.run();
            return result;
        });
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.verifyNotShutdown();
        return this.addTaskToQueue(() -> {
            task.run();
            return null;
        });
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    private void verifyNotShutdown() {
        if (this.isShutdown) {
            throw new RejectedExecutionException();
        }
    }

    private <T> Future<T> addTaskToQueue(Callable<T> callable) {
        Task task = new Task(callable);
        this.taskQueue.add(task);
        return task.future;
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
        this.taskQueue.clear();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return null;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown && this.taskQueue.isEmpty();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    private static class Task<T> {
        private final Callable<T> callable;
        private final CompletableFuture<T> future = new CompletableFuture();

        private Task(Callable<T> callable) {
            this.callable = callable;
        }

        private void executeNow() {
            try {
                T result = this.callable.call();
                this.future.complete(result);
            }
            catch (Exception e) {
                throw new ISE("Error while executing task", new Object[]{e});
            }
        }
    }
}

