/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.ArrayList;
import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BalancingStrategiesTest
extends CoordinatorSimulationBaseTest {
    private static final long SIZE_1TB = 1000000L;
    private final String strategy;
    private final List<DataSegment> segments = CoordinatorSimulationBaseTest.Segments.WIKI_10X100D;

    @Parameterized.Parameters(name="{0}")
    public static String[] getTestParameters() {
        return new String[]{"cost", "cachingCost"};
    }

    public BalancingStrategiesTest(String strategy) {
        this.strategy = strategy;
    }

    @Override
    public void setUp() {
    }

    @Test
    public void testNewClusterGetsBalanced() {
        ArrayList<DruidServer> historicals = new ArrayList<DruidServer>();
        for (int i = 0; i < 5; ++i) {
            historicals.add(BalancingStrategiesTest.createHistorical(i, "tier_t1", 1000000L));
        }
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withBalancer(this.strategy).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withServers(historicals).withSegments(this.segments).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        this.verifyValue("segment/assigned/count", 1000L);
        this.verifyNotEmitted("segment/moved/count");
        for (DruidServer historical : historicals) {
            Assert.assertEquals((long)200L, (long)historical.getTotalSegments());
        }
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        this.verifyNotEmitted("segment/assigned/count");
        this.verifyNotEmitted("segment/moved/count");
    }

    @Test
    public void testClusterGetsBalancedWhenServerIsAdded() {
        ArrayList<DruidServer> historicals = new ArrayList<DruidServer>();
        for (int i = 0; i < 4; ++i) {
            historicals.add(BalancingStrategiesTest.createHistorical(i, "tier_t1", 1000000L));
        }
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withBalancer(this.strategy).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withServers(historicals).withSegments(this.segments).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        this.verifyValue("segment/assigned/count", 1000L);
        this.verifyNotEmitted("segment/moved/count");
        for (DruidServer historical : historicals) {
            Assert.assertEquals((long)250L, (long)historical.getTotalSegments());
        }
        DruidServer newHistorical = BalancingStrategiesTest.createHistorical(4, "tier_t1", 1000000L);
        this.addServer(newHistorical);
        historicals.add(newHistorical);
        for (int i = 0; i < 7; ++i) {
            this.runCoordinatorCycle();
            this.loadQueuedSegments();
        }
        for (DruidServer historical : historicals) {
            long loadedSegments = historical.getTotalSegments();
            Assert.assertTrue((loadedSegments >= 195L && loadedSegments <= 205L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testClusterGetsBalancedWhenServerIsRemoved() {
        ArrayList<DruidServer> historicals = new ArrayList<DruidServer>();
        for (int i = 0; i < 5; ++i) {
            historicals.add(BalancingStrategiesTest.createHistorical(i, "tier_t1", 1000000L));
        }
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withBalancer(this.strategy).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withServers(historicals).withSegments(this.segments).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        this.verifyValue("segment/assigned/count", 1000L);
        this.verifyNotEmitted("segment/moved/count");
        for (DruidServer historical : historicals) {
            Assert.assertEquals((long)200L, (long)historical.getTotalSegments());
        }
        DruidServer removedHistorical = (DruidServer)historicals.remove(4);
        this.removeServer(removedHistorical);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        int assignedCount = this.getValue("segment/assigned/count", null).intValue();
        Assert.assertTrue((assignedCount >= 200 ? 1 : 0) != 0);
        for (DruidServer historical : historicals) {
            Assert.assertEquals((long)250L, (long)historical.getTotalSegments());
        }
    }
}

