/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ImmutableDruidServerTests;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.UnloadUnusedSegments;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnloadUnusedSegmentsTest {
    private DruidCoordinator coordinator;
    private ImmutableDruidServer historicalServer;
    private ImmutableDruidServer historicalServerTier2;
    private ImmutableDruidServer brokerServer;
    private ImmutableDruidServer indexerServer;
    private TestLoadQueuePeon historicalPeon;
    private TestLoadQueuePeon historicalTier2Peon;
    private TestLoadQueuePeon brokerPeon;
    private TestLoadQueuePeon indexerPeon;
    private DataSegment segment1;
    private DataSegment segment2;
    private List<DataSegment> segments;
    private List<DataSegment> segmentsForRealtime;
    private List<ImmutableDruidDataSource> dataSources;
    private List<ImmutableDruidDataSource> dataSourcesForRealtime;
    private final String broadcastDatasource = "broadcastDatasource";
    private MetadataRuleManager databaseRuleManager;
    private SegmentLoadQueueManager loadQueueManager;

    @Before
    public void setUp() {
        this.coordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        this.historicalServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.historicalServerTier2 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.brokerServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.indexerServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.databaseRuleManager = (MetadataRuleManager)EasyMock.createMock(MetadataRuleManager.class);
        this.loadQueueManager = new SegmentLoadQueueManager(null, null);
        DateTime start1 = DateTimes.of((String)"2012-01-01");
        DateTime start2 = DateTimes.of((String)"2012-02-01");
        DateTime version = DateTimes.of((String)"2012-05-01");
        this.segment1 = new DataSegment("datasource1", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 11L);
        this.segment2 = new DataSegment("datasource2", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        DataSegment realtimeOnlySegment = new DataSegment("datasource2", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        DataSegment broadcastSegment = new DataSegment("broadcastDatasource", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        this.segments = new ArrayList<DataSegment>();
        this.segments.add(this.segment1);
        this.segments.add(this.segment2);
        this.segments.add(broadcastSegment);
        this.segmentsForRealtime = new ArrayList<DataSegment>();
        this.segmentsForRealtime.add(realtimeOnlySegment);
        this.segmentsForRealtime.add(broadcastSegment);
        this.historicalPeon = new TestLoadQueuePeon();
        this.historicalTier2Peon = new TestLoadQueuePeon();
        this.brokerPeon = new TestLoadQueuePeon();
        this.indexerPeon = new TestLoadQueuePeon();
        ImmutableDruidDataSource dataSource1 = new ImmutableDruidDataSource("datasource1", Collections.emptyMap(), Collections.singleton(this.segment1));
        ImmutableDruidDataSource dataSource2 = new ImmutableDruidDataSource("datasource2", Collections.emptyMap(), Collections.singleton(this.segment2));
        ImmutableDruidDataSource broadcastDatasource = new ImmutableDruidDataSource("broadcastDatasource", Collections.emptyMap(), Collections.singleton(broadcastSegment));
        this.dataSources = ImmutableList.of((Object)dataSource1, (Object)dataSource2, (Object)broadcastDatasource);
        ImmutableDruidDataSource dataSource2ForRealtime = new ImmutableDruidDataSource("datasource2", Collections.emptyMap(), Collections.singleton(realtimeOnlySegment));
        this.dataSourcesForRealtime = ImmutableList.of((Object)dataSource2ForRealtime, (Object)broadcastDatasource);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.coordinator});
        EasyMock.verify((Object[])new Object[]{this.historicalServer});
        EasyMock.verify((Object[])new Object[]{this.historicalServerTier2});
        EasyMock.verify((Object[])new Object[]{this.brokerServer});
        EasyMock.verify((Object[])new Object[]{this.indexerServer});
        EasyMock.verify((Object[])new Object[]{this.databaseRuleManager});
    }

    @Test
    public void test_unloadUnusedSegmentsFromAllServers() {
        UnloadUnusedSegmentsTest.mockDruidServer(this.historicalServer, ServerType.HISTORICAL, "historical", "_default_tier", 30L, 100L, this.segments, this.dataSources);
        UnloadUnusedSegmentsTest.mockDruidServer(this.historicalServerTier2, ServerType.HISTORICAL, "historicalTier2", "tier2", 30L, 100L, this.segments, this.dataSources);
        UnloadUnusedSegmentsTest.mockDruidServer(this.brokerServer, ServerType.BROKER, "broker", "_default_tier", 30L, 100L, this.segments, this.dataSources);
        UnloadUnusedSegmentsTest.mockDruidServer(this.indexerServer, ServerType.INDEXER_EXECUTOR, "indexer", "_default_tier", 30L, 100L, this.segmentsForRealtime, this.dataSourcesForRealtime);
        UnloadUnusedSegmentsTest.mockCoordinator(this.coordinator);
        UnloadUnusedSegmentsTest.mockRuleManager(this.databaseRuleManager);
        ImmutableSet usedSegments = ImmutableSet.of((Object)this.segment2);
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.builder().withDruidCluster(DruidCluster.builder().addTier("_default_tier", new ServerHolder[]{new ServerHolder(this.historicalServer, (LoadQueuePeon)this.historicalPeon, false)}).addTier("tier2", new ServerHolder[]{new ServerHolder(this.historicalServerTier2, (LoadQueuePeon)this.historicalTier2Peon, false)}).addBrokers(new ServerHolder[]{new ServerHolder(this.brokerServer, (LoadQueuePeon)this.brokerPeon, false)}).addRealtimes(new ServerHolder[]{new ServerHolder(this.indexerServer, (LoadQueuePeon)this.indexerPeon, false)}).build()).withUsedSegments((Collection)usedSegments).withBroadcastDatasources(Collections.singleton("broadcastDatasource")).build();
        params = new UnloadUnusedSegments(this.loadQueueManager, arg_0 -> ((MetadataRuleManager)this.databaseRuleManager).getRulesWithDefault(arg_0)).run(params);
        CoordinatorRunStats stats = params.getCoordinatorStats();
        Assert.assertEquals((long)2L, (long)stats.getSegmentStat(Stats.Segments.UNNEEDED, "_default_tier", this.segment1.getDataSource()));
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.UNNEEDED, "tier2", this.segment1.getDataSource()));
        Assert.assertEquals((long)3L, (long)stats.getSegmentStat(Stats.Segments.UNNEEDED, "_default_tier", "broadcastDatasource"));
        Assert.assertEquals((long)1L, (long)stats.getSegmentStat(Stats.Segments.UNNEEDED, "tier2", "broadcastDatasource"));
    }

    private static void mockDruidServer(ImmutableDruidServer druidServer, ServerType serverType, String name, String tier, long currentSize, long maxSize, List<DataSegment> segments, List<ImmutableDruidDataSource> dataSources) {
        EasyMock.expect((Object)druidServer.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)druidServer.getTier()).andReturn((Object)tier).anyTimes();
        EasyMock.expect((Object)druidServer.getCurrSize()).andReturn((Object)currentSize).anyTimes();
        EasyMock.expect((Object)druidServer.getMaxSize()).andReturn((Object)maxSize).anyTimes();
        ImmutableDruidServerTests.expectSegments(druidServer, segments);
        EasyMock.expect((Object)druidServer.getHost()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)druidServer.getType()).andReturn((Object)serverType).anyTimes();
        EasyMock.expect((Object)druidServer.getDataSources()).andReturn(dataSources).anyTimes();
        if (!segments.isEmpty()) {
            segments.forEach(s -> EasyMock.expect((Object)druidServer.getSegment(s.getId())).andReturn(s).anyTimes());
        }
        EasyMock.expect((Object)druidServer.getSegment((SegmentId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{druidServer});
    }

    private static void mockCoordinator(DruidCoordinator coordinator) {
        EasyMock.replay((Object[])new Object[]{coordinator});
    }

    private static void mockRuleManager(MetadataRuleManager metadataRuleManager) {
        EasyMock.expect((Object)metadataRuleManager.getRulesWithDefault("datasource1")).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1, (Object)"tier2", (Object)1), null))).anyTimes();
        EasyMock.expect((Object)metadataRuleManager.getRulesWithDefault("datasource2")).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1, (Object)"tier2", (Object)1), null))).anyTimes();
        EasyMock.expect((Object)metadataRuleManager.getRulesWithDefault("broadcastDatasource")).andReturn(Collections.singletonList(new ForeverBroadcastDistributionRule())).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataRuleManager});
    }
}

