/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.metadata.SegmentSchemaTestUtils;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.apache.druid.server.coordinator.duty.KillUnreferencedSegmentSchema;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;

@RunWith(value=MockitoJUnitRunner.class)
public class KillUnreferencedSegmentSchemaTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule(CentralizedDatasourceSchemaConfig.create((boolean)true));
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();
    private TestDerbyConnector derbyConnector;
    private MetadataStorageTablesConfig tablesConfig;
    private SegmentSchemaManager segmentSchemaManager;
    private FingerprintGenerator fingerprintGenerator;
    private SegmentSchemaTestUtils segmentSchemaTestUtils;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;

    @Before
    public void setUp() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.derbyConnector.createSegmentSchemasTable();
        this.derbyConnector.createSegmentTable();
        this.fingerprintGenerator = new FingerprintGenerator(this.mapper);
        this.segmentSchemaManager = new SegmentSchemaManager((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), this.mapper, (SQLMetadataConnector)this.derbyConnector);
        this.segmentSchemaTestUtils = new SegmentSchemaTestUtils(this.derbyConnectorRule, this.derbyConnector, this.mapper);
        CoordinatorRunStats runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)runStats);
    }

    @Test
    public void testKillUnreferencedSchema() {
        ArrayList<DateTime> dateTimes = new ArrayList<DateTime>();
        DateTime now = DateTimes.nowUtc();
        dateTimes.add(now);
        dateTimes.add(now.plusMinutes(61));
        dateTimes.add(now.plusMinutes(361));
        MetadataCleanupConfig cleanupConfig = new MetadataCleanupConfig(Boolean.valueOf(true), Period.parse((String)"PT1H").toStandardDuration(), Period.parse((String)"PT6H").toStandardDuration());
        TestKillUnreferencedSegmentSchemas duty = new TestKillUnreferencedSegmentSchemas(cleanupConfig, this.segmentSchemaManager, dateTimes);
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus> schemaMetadataPluses = new ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus>();
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).build();
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
        SchemaPayloadPlus schemaMetadata = new SchemaPayloadPlus(schemaPayload, Long.valueOf(1L));
        DataSegment segment1 = new DataSegment("foo", Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-01", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        DataSegment segment2 = new DataSegment("foo", Intervals.of((String)"2023-01-02/2023-01-03"), "2023-01-02", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        segments.add(segment1);
        segments.add(segment2);
        String fingerprint = this.fingerprintGenerator.generateFingerprint(schemaPayload, segment1.getDataSource(), 1);
        SegmentSchemaManager.SegmentSchemaMetadataPlus plus1 = new SegmentSchemaManager.SegmentSchemaMetadataPlus(segment1.getId(), fingerprint, schemaMetadata);
        schemaMetadataPluses.add(plus1);
        SegmentSchemaManager.SegmentSchemaMetadataPlus plus2 = new SegmentSchemaManager.SegmentSchemaMetadataPlus(segment2.getId(), fingerprint, schemaMetadata);
        schemaMetadataPluses.add(plus2);
        this.segmentSchemaTestUtils.insertUsedSegments(segments, Collections.emptyMap());
        this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable("foo", schemaMetadataPluses, 1);
        this.deleteSegment(((SegmentSchemaManager.SegmentSchemaMetadataPlus)schemaMetadataPluses.get(0)).getSegmentId());
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.getSchemaUsedStatus(fingerprint));
        this.deleteSegment(((SegmentSchemaManager.SegmentSchemaMetadataPlus)schemaMetadataPluses.get(1)).getSegmentId());
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.getSchemaUsedStatus(fingerprint));
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertNull((Object)this.getSchemaUsedStatus(fingerprint));
    }

    @Test
    public void testKillUnreferencedSchema_repair() {
        ArrayList<DateTime> dateTimes = new ArrayList<DateTime>();
        DateTime now = DateTimes.nowUtc();
        dateTimes.add(now);
        dateTimes.add(now.plusMinutes(61));
        MetadataCleanupConfig cleanupConfig = new MetadataCleanupConfig(Boolean.valueOf(true), Period.parse((String)"PT1H").toStandardDuration(), Period.parse((String)"PT6H").toStandardDuration());
        TestKillUnreferencedSegmentSchemas duty = new TestKillUnreferencedSegmentSchemas(cleanupConfig, this.segmentSchemaManager, dateTimes);
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).build();
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
        String fingerprint = this.fingerprintGenerator.generateFingerprint(schemaPayload, "foo", 1);
        this.inHandle(handle -> {
            this.segmentSchemaManager.persistSegmentSchema(handle, "foo", 1, Collections.singletonMap(fingerprint, schemaPayload));
            return null;
        });
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.getSchemaUsedStatus(fingerprint));
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.getSchemaUsedStatus(fingerprint));
        DataSegment segment1 = new DataSegment("foo", Intervals.of((String)"2023-01-02/2023-01-03"), "2023-01-02", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        this.segmentSchemaTestUtils.insertUsedSegments(Collections.singleton(segment1), Collections.emptyMap());
        this.inHandle(handle -> handle.createStatement(StringUtils.format((String)"UPDATE %s SET schema_fingerprint = '%s', num_rows = 100 WHERE id = '%s'", (Object[])new Object[]{this.tablesConfig.getSegmentsTable(), fingerprint, segment1.getId().toString()})).execute());
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.getSchemaUsedStatus(fingerprint));
    }

    @Test
    public void testKillOlderVersionSchema() {
        ArrayList<DateTime> dateTimes = new ArrayList<DateTime>();
        DateTime now = DateTimes.nowUtc();
        dateTimes.add(now);
        dateTimes.add(now.plusMinutes(61));
        dateTimes.add(now.plusMinutes(361));
        MetadataCleanupConfig cleanupConfig = new MetadataCleanupConfig(Boolean.valueOf(true), Period.parse((String)"PT1H").toStandardDuration(), Period.parse((String)"PT6H").toStandardDuration());
        TestKillUnreferencedSegmentSchemas duty = new TestKillUnreferencedSegmentSchemas(cleanupConfig, this.segmentSchemaManager, dateTimes);
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).build();
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature);
        String fingerprintOldVersion = this.fingerprintGenerator.generateFingerprint(schemaPayload, "foo", 0);
        String fingerprintNewVersion = this.fingerprintGenerator.generateFingerprint(schemaPayload, "foo", 1);
        this.inHandle(handle -> {
            this.segmentSchemaManager.persistSegmentSchema(handle, "foo", 0, Collections.singletonMap(fingerprintOldVersion, schemaPayload));
            return null;
        });
        this.inHandle(handle -> {
            this.segmentSchemaManager.persistSegmentSchema(handle, "foo", 1, Collections.singletonMap(fingerprintNewVersion, schemaPayload));
            return null;
        });
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.getSchemaUsedStatus(fingerprintOldVersion));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.getSchemaUsedStatus(fingerprintNewVersion));
        DataSegment segment1 = new DataSegment("foo", Intervals.of((String)"2023-01-02/2023-01-03"), "2023-01-02", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        this.segmentSchemaTestUtils.insertUsedSegments(Collections.singleton(segment1), Collections.emptyMap());
        this.inHandle(handle -> handle.createStatement(StringUtils.format((String)"UPDATE %s SET schema_fingerprint = '%s', num_rows = 100 WHERE id = '%s'", (Object[])new Object[]{this.tablesConfig.getSegmentsTable(), fingerprintNewVersion, segment1.getId().toString()})).execute());
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.getSchemaUsedStatus(fingerprintNewVersion));
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertNull((Object)this.getSchemaUsedStatus(fingerprintOldVersion));
    }

    private <T> T inHandle(HandleCallback<T> callback) {
        return (T)this.derbyConnector.retryWithHandle(callback);
    }

    private void deleteSegment(SegmentId id) {
        this.inHandle(handle -> {
            Update deleteStatement = handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE id = '%s'", (Object[])new Object[]{this.tablesConfig.getSegmentsTable(), id.toString()}));
            deleteStatement.execute();
            return null;
        });
    }

    private Boolean getSchemaUsedStatus(String fingerprint) {
        List usedStatus = (List)this.inHandle(handle -> handle.createQuery(StringUtils.format((String)"SELECT used from %s where fingerprint = '%s'", (Object[])new Object[]{this.tablesConfig.getSegmentSchemasTable(), fingerprint})).mapTo(Boolean.class).list());
        return usedStatus.isEmpty() ? null : (Boolean)usedStatus.get(0);
    }

    private static class TestKillUnreferencedSegmentSchemas
    extends KillUnreferencedSegmentSchema {
        private final List<DateTime> dateTimes;
        private int index = -1;

        public TestKillUnreferencedSegmentSchemas(MetadataCleanupConfig config, SegmentSchemaManager segmentSchemaManager, List<DateTime> dateTimes) {
            super(config, segmentSchemaManager);
            this.dateTimes = dateTimes;
        }

        protected DateTime getCurrentTime() {
            ++this.index;
            return this.dateTimes.get(this.index);
        }
    }
}

