/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.KillSupervisorsCustomDuty;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillSupervisorsCustomDutyTest {
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    private KillSupervisorsCustomDuty killSupervisors;

    @Test
    public void testConstructorSuccess() {
        this.killSupervisors = new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), this.mockMetadataSupervisorManager);
        Assert.assertNotNull((Object)this.killSupervisors);
    }

    @Test
    public void testRun() {
        CoordinatorRunStats runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)runStats);
        this.killSupervisors = new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), this.mockMetadataSupervisorManager);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataSupervisorManager)Mockito.verify((Object)this.mockMetadataSupervisorManager)).removeTerminatedSupervisorsOlderThan(ArgumentMatchers.anyLong());
        Assert.assertTrue((boolean)runStats.hasStat(Stats.Kill.SUPERVISOR_SPECS));
    }
}

