/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.apache.druid.server.coordinator.duty.KillRules;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillRulesTest {
    @Mock
    private MetadataRuleManager mockRuleManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    private KillRules killRules;
    private CoordinatorRunStats runStats;

    @Before
    public void setup() {
        this.runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration(Long.MAX_VALUE), new Duration((Object)"PT1S"));
        this.killRules = new KillRules(config, this.mockRuleManager);
        this.killRules.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockRuleManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration((Object)"PT6S"), new Duration((Object)"PT1S"));
        this.killRules = new KillRules(config, this.mockRuleManager);
        this.killRules.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataRuleManager)Mockito.verify((Object)this.mockRuleManager)).removeRulesForEmptyDatasourcesOlderThan(ArgumentMatchers.anyLong());
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.RULES));
    }
}

