/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.NewestSegmentFirstPolicy;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class DruidCompactionConfigTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerdeDefaultConfig() throws Exception {
        DruidCompactionConfig defaultConfig = DruidCompactionConfig.empty();
        String json = MAPPER.writeValueAsString((Object)defaultConfig);
        DruidCompactionConfig deserialized = (DruidCompactionConfig)MAPPER.readValue(json, DruidCompactionConfig.class);
        Assert.assertEquals((Object)defaultConfig, (Object)deserialized);
    }

    @Test
    public void testSerdeWithDatasourceConfigs() throws Exception {
        DruidCompactionConfig config = new DruidCompactionConfig(Arrays.asList(DataSourceCompactionConfig.builder().forDataSource("wiki").withSkipOffsetFromLatest(Period.hours((int)1)).build(), DataSourceCompactionConfig.builder().forDataSource("koala").withSkipOffsetFromLatest(Period.hours((int)2)).build()), null, null, null, null);
        String json = MAPPER.writeValueAsString((Object)config);
        DruidCompactionConfig deserialized = (DruidCompactionConfig)MAPPER.readValue(json, DruidCompactionConfig.class);
        Assert.assertEquals((Object)config, (Object)deserialized);
    }

    @Test
    public void testCopyWithClusterConfig() {
        DruidCompactionConfig config = DruidCompactionConfig.empty();
        ClusterCompactionConfig clusterConfig = new ClusterCompactionConfig(Double.valueOf(0.5), Integer.valueOf(10), Boolean.valueOf(false), (CompactionCandidateSearchPolicy)new NewestSegmentFirstPolicy(null));
        DruidCompactionConfig copy = config.withClusterConfig(clusterConfig);
        Assert.assertEquals((Object)clusterConfig, (Object)copy.clusterConfig());
        Assert.assertNotEquals((Object)clusterConfig, (Object)config.clusterConfig());
    }

    @Test
    public void testCopyWithDatasourceConfigs() {
        DruidCompactionConfig config = DruidCompactionConfig.empty();
        Assert.assertTrue((boolean)config.getCompactionConfigs().isEmpty());
        DataSourceCompactionConfig dataSourceConfig = DataSourceCompactionConfig.builder().forDataSource("wiki").withEngine(CompactionEngine.NATIVE).build();
        DruidCompactionConfig copy = config.withDatasourceConfigs(Collections.singletonList(dataSourceConfig));
        Assert.assertEquals((long)1L, (long)copy.getCompactionConfigs().size());
        Assert.assertEquals((Object)dataSourceConfig, (Object)copy.findConfigForDatasource("wiki").orNull());
    }
}

