/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.ZkCoordinator;
import org.apache.druid.server.initialization.BatchDataSegmentAnnouncerConfig;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.easymock.EasyMock;
import org.junit.Test;

public class ZkCoordinatorTest {
    private final DruidServerMetadata me = new DruidServerMetadata("dummyServer", "dummyHost", null, 0L, ServerType.HISTORICAL, "normal", 0);
    private final ZkPathsConfig zkPaths = new ZkPathsConfig(){

        public String getBase() {
            return "/druid";
        }
    };

    @Test(timeout=60000L)
    public void testSegmentPathIsCreatedIfZkAnnouncementIsEnabled() throws Exception {
        this.testSegmentPathCreated(true);
    }

    @Test(timeout=60000L)
    public void testSegmentPathIsNotCreatedIfZkAnnouncementIsDisabled() throws Exception {
        this.testSegmentPathCreated(false);
    }

    private void testSegmentPathCreated(final boolean announceSegmentsOnZk) throws Exception {
        String liveSegmentsPath = ZKPaths.makePath((String)this.zkPaths.getLiveSegmentsPath(), (String)this.me.getName());
        EnsurePath mockEnsurePath = (EnsurePath)EasyMock.mock(EnsurePath.class);
        CuratorFramework mockCurator = (CuratorFramework)EasyMock.mock(CuratorFramework.class);
        if (announceSegmentsOnZk) {
            EasyMock.expect((Object)mockCurator.newNamespaceAwareEnsurePath(liveSegmentsPath)).andReturn((Object)mockEnsurePath).once();
            EasyMock.expect((Object)mockCurator.getZookeeperClient()).andReturn(null).once();
            mockEnsurePath.ensure((CuratorZookeeperClient)EasyMock.anyObject());
            EasyMock.expectLastCall().once();
        }
        EasyMock.replay((Object[])new Object[]{mockCurator, mockEnsurePath});
        ZkCoordinator zkCoordinator = new ZkCoordinator(this.zkPaths, this.me, mockCurator, new BatchDataSegmentAnnouncerConfig(){

            public boolean isSkipSegmentAnnouncementOnZk() {
                return !announceSegmentsOnZk;
            }
        });
        zkCoordinator.start();
        EasyMock.verify((Object[])new Object[0]);
        zkCoordinator.stop();
    }
}

