/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.TestSegmentUtils;
import org.apache.druid.server.coordination.BroadcastDatasourceLoadingSpec;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.SegmentBootstrapper;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.TestCoordinatorClient;
import org.apache.druid.server.coordination.TestDataSegmentAnnouncer;
import org.apache.druid.server.coordination.TestDataServerAnnouncer;
import org.apache.druid.server.coordination.TestSegmentCacheManager;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SegmentBootstrapperTest {
    private static final int COUNT = 50;
    private TestDataSegmentAnnouncer segmentAnnouncer;
    private TestDataServerAnnouncer serverAnnouncer;
    private SegmentLoaderConfig segmentLoaderConfig;
    private TestCoordinatorClient coordinatorClient;
    private StubServiceEmitter serviceEmitter;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        final File segmentCacheDir = this.temporaryFolder.newFolder();
        this.segmentAnnouncer = new TestDataSegmentAnnouncer();
        this.serverAnnouncer = new TestDataServerAnnouncer();
        this.segmentLoaderConfig = new SegmentLoaderConfig(){

            public File getInfoDir() {
                return segmentCacheDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(segmentCacheDir, null, null));
            }
        };
        this.coordinatorClient = new TestCoordinatorClient();
        this.serviceEmitter = new StubServiceEmitter();
        EmittingLogger.registerEmitter((ServiceEmitter)this.serviceEmitter);
    }

    @Test
    public void testStartStop() throws Exception {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 50; ++i) {
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "2", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(TestSegmentUtils.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(TestSegmentUtils.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager(segments);
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(handler, this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)this.coordinatorClient, (ServiceEmitter)this.serviceEmitter, new DataSourceTaskIdHolder());
        Assert.assertTrue((boolean)segmentManager.getDataSourceCounts().isEmpty());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertFalse((boolean)segmentManager.getDataSourceCounts().isEmpty());
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)3L, (long)((Long)segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        Assert.assertEquals((Object)ImmutableList.copyOf(segments), this.segmentAnnouncer.getObservedSegments());
        ImmutableList expectedBootstrapSegments = ImmutableList.copyOf(segments);
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedSegments());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedSegmentsLoadedIntoPageCache());
        bootstrapper.stop();
        Assert.assertEquals((long)0L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertEquals((long)1L, (long)cacheManager.getObservedShutdownBootstrapCount().get());
    }

    @Test
    public void testLoadCachedSegments() throws Exception {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 50; ++i) {
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "2", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-03")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-04")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-05")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T01")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T02")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T03")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T05")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T06")));
            segments.add(TestSegmentUtils.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(TestSegmentUtils.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager(segments);
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(handler, this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)this.coordinatorClient, (ServiceEmitter)this.serviceEmitter, new DataSourceTaskIdHolder());
        Assert.assertTrue((boolean)segmentManager.getDataSourceCounts().isEmpty());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertFalse((boolean)segmentManager.getDataSourceCounts().isEmpty());
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)11L, (long)((Long)segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        Assert.assertEquals((Object)ImmutableList.copyOf(segments), this.segmentAnnouncer.getObservedSegments());
        ImmutableList expectedBootstrapSegments = ImmutableList.copyOf(segments);
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedSegments());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedSegmentsLoadedIntoPageCache());
        bootstrapper.stop();
        Assert.assertEquals((long)0L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertEquals((long)1L, (long)cacheManager.getObservedShutdownBootstrapCount().get());
    }

    @Test
    public void testLoadBootstrapSegments() throws Exception {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 50; ++i) {
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(TestSegmentUtils.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(TestSegmentUtils.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        TestCoordinatorClient coordinatorClient = new TestCoordinatorClient(segments);
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager();
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(handler, this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)coordinatorClient, (ServiceEmitter)this.serviceEmitter, new DataSourceTaskIdHolder());
        Assert.assertTrue((boolean)segmentManager.getDataSourceCounts().isEmpty());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertFalse((boolean)segmentManager.getDataSourceCounts().isEmpty());
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)2L, (long)((Long)segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        ImmutableList expectedBootstrapSegments = ImmutableList.copyOf(segments);
        Assert.assertEquals((Object)expectedBootstrapSegments, this.segmentAnnouncer.getObservedSegments());
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
        this.serviceEmitter.verifyValue("segment/bootstrap/count", (Number)expectedBootstrapSegments.size());
        this.serviceEmitter.verifyEmitted("segment/bootstrap/time", 1);
        bootstrapper.stop();
    }

    @Test
    public void testLoadNoBootstrapSegments() throws Exception {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 50; ++i) {
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(TestSegmentUtils.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(TestSegmentUtils.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(TestSegmentUtils.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new JacksonModule(), new LifecycleModule(), binder -> {
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
            BroadcastDatasourceLoadingSpec broadcastMode = BroadcastDatasourceLoadingSpec.NONE;
            binder.bind(Key.get(BroadcastDatasourceLoadingSpec.class, (Annotation)Names.named((String)"broadcastDatasourcesToLoadForTask"))).toInstance((Object)broadcastMode);
        }});
        TestCoordinatorClient coordinatorClient = new TestCoordinatorClient(segments);
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager();
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(handler, this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)coordinatorClient, (ServiceEmitter)this.serviceEmitter, (DataSourceTaskIdHolder)injector.getInstance(DataSourceTaskIdHolder.class));
        Assert.assertTrue((boolean)segmentManager.getDataSourceCounts().isEmpty());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertTrue((boolean)segmentManager.getDataSourceCounts().isEmpty());
        ImmutableList expectedBootstrapSegments = ImmutableList.of();
        Assert.assertEquals((Object)expectedBootstrapSegments, this.segmentAnnouncer.getObservedSegments());
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
        bootstrapper.stop();
    }

    @Test
    public void testLoadOnlyRequiredBootstrapSegments() throws Exception {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        DataSegment ds1Segment1 = TestSegmentUtils.makeSegment("test1", "1", Intervals.of((String)"P1D/2011-04-01"));
        DataSegment ds1Segment2 = TestSegmentUtils.makeSegment("test1", "1", Intervals.of((String)"P1D/2012-04-01"));
        DataSegment ds2Segment1 = TestSegmentUtils.makeSegment("test2", "1", Intervals.of((String)"P1d/2011-04-01"));
        DataSegment ds2Segment2 = TestSegmentUtils.makeSegment("test2", "1", Intervals.of((String)"P1d/2012-04-01"));
        segments.add(ds1Segment1);
        segments.add(ds1Segment2);
        segments.add(ds2Segment1);
        segments.add(ds2Segment2);
        Injector injector = Guice.createInjector((Module[])new Module[]{new JacksonModule(), new LifecycleModule(), binder -> {
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
            BroadcastDatasourceLoadingSpec broadcastMode = BroadcastDatasourceLoadingSpec.loadOnly((Set)ImmutableSet.of((Object)"test1"));
            binder.bind(Key.get(BroadcastDatasourceLoadingSpec.class, (Annotation)Names.named((String)"broadcastDatasourcesToLoadForTask"))).toInstance((Object)broadcastMode);
        }});
        TestCoordinatorClient coordinatorClient = new TestCoordinatorClient(segments);
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager();
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(handler, this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)coordinatorClient, (ServiceEmitter)this.serviceEmitter, (DataSourceTaskIdHolder)injector.getInstance(DataSourceTaskIdHolder.class));
        Assert.assertTrue((boolean)segmentManager.getDataSourceCounts().isEmpty());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertFalse((boolean)segmentManager.getDataSourceCounts().isEmpty());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"test1"), (Object)segmentManager.getDataSourceNames());
        ImmutableList expectedBootstrapSegments = ImmutableList.of((Object)ds1Segment2, (Object)ds1Segment1);
        Assert.assertEquals((Object)expectedBootstrapSegments, this.segmentAnnouncer.getObservedSegments());
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)expectedBootstrapSegments, cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
        this.serviceEmitter.verifyValue("segment/bootstrap/count", (Number)expectedBootstrapSegments.size());
        this.serviceEmitter.verifyEmitted("segment/bootstrap/time", 1);
        bootstrapper.stop();
    }

    @Test
    public void testLoadBootstrapSegmentsWhenExceptionThrown() throws Exception {
        TestSegmentCacheManager cacheManager = new TestSegmentCacheManager();
        SegmentManager segmentManager = new SegmentManager((SegmentCacheManager)cacheManager);
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(handler, this.segmentLoaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)this.coordinatorClient, (ServiceEmitter)this.serviceEmitter, new DataSourceTaskIdHolder());
        Assert.assertTrue((boolean)segmentManager.getDataSourceCounts().isEmpty());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertTrue((boolean)segmentManager.getDataSourceCounts().isEmpty());
        Assert.assertEquals((Object)ImmutableList.of(), this.segmentAnnouncer.getObservedSegments());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedBootstrapSegments());
        Assert.assertEquals((Object)ImmutableList.of(), cacheManager.getObservedBootstrapSegmentsLoadedIntoPageCache());
        this.serviceEmitter.verifyValue("segment/bootstrap/count", (Number)0);
        this.serviceEmitter.verifyEmitted("segment/bootstrap/time", 1);
        bootstrapper.stop();
    }
}

