/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.TestSegmentUtils;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.SegmentBootstrapper;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.TestCoordinatorClient;
import org.apache.druid.server.coordination.TestDataSegmentAnnouncer;
import org.apache.druid.server.coordination.TestDataServerAnnouncer;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SegmentBootstrapperCacheTest {
    private static final long MAX_SIZE = 1000L;
    private static final long SEGMENT_SIZE = 100L;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TestDataSegmentAnnouncer segmentAnnouncer;
    private TestDataServerAnnouncer serverAnnouncer;
    private SegmentManager segmentManager;
    private SegmentLoaderConfig loaderConfig;
    private SegmentLocalCacheManager cacheManager;
    private TestCoordinatorClient coordinatorClient;
    private ServiceEmitter emitter;
    private ObjectMapper objectMapper;

    @Before
    public void setup() {
        this.loaderConfig = new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentBootstrapperCacheTest.this.temporaryFolder.getRoot();
            }

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(SegmentBootstrapperCacheTest.this.temporaryFolder.getRoot(), 1000L, null));
            }
        };
        this.objectMapper = TestHelper.makeJsonMapper();
        this.objectMapper.registerSubtypes(new Class[]{TestSegmentUtils.TestLoadSpec.class});
        this.objectMapper.registerSubtypes(new Class[]{TestSegmentUtils.TestSegmentizerFactory.class});
        List storageLocations = this.loaderConfig.toStorageLocations();
        this.cacheManager = new SegmentLocalCacheManager(storageLocations, this.loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestIndex.INDEX_IO, this.objectMapper);
        this.segmentManager = new SegmentManager((SegmentCacheManager)this.cacheManager);
        this.serverAnnouncer = new TestDataServerAnnouncer();
        this.segmentAnnouncer = new TestDataSegmentAnnouncer();
        this.coordinatorClient = new TestCoordinatorClient();
        this.emitter = new StubServiceEmitter();
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
    }

    @Test
    public void testLoadStartStopWithEmptyLocations() throws IOException {
        ImmutableList emptyLocations = ImmutableList.of();
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig();
        this.segmentManager = new SegmentManager((SegmentCacheManager)new SegmentLocalCacheManager((List)emptyLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy((List)emptyLocations), TestIndex.INDEX_IO, this.objectMapper));
        SegmentLoadDropHandler loadDropHandler = new SegmentLoadDropHandler(loaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, this.segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(loadDropHandler, loaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, this.segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)this.coordinatorClient, this.emitter, new DataSourceTaskIdHolder());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        bootstrapper.stop();
        Assert.assertEquals((long)0L, (long)this.serverAnnouncer.getObservedCount());
    }

    @Test
    public void testLoadStartStop() throws IOException {
        SegmentLoadDropHandler loadDropHandler = new SegmentLoadDropHandler(this.loaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, this.segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(loadDropHandler, this.loaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, this.segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)this.coordinatorClient, this.emitter, new DataSourceTaskIdHolder());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        bootstrapper.stop();
        Assert.assertEquals((long)0L, (long)this.serverAnnouncer.getObservedCount());
    }

    @Test
    public void testLoadLocalCache() throws IOException, SegmentLoadingException {
        int numSegments = 10;
        ArrayList<DataSegment> expectedSegments = new ArrayList<DataSegment>();
        for (int i = 0; i < numSegments; ++i) {
            String version = "segment-" + i;
            DataSegment segment = TestSegmentUtils.makeSegment("test", version, 100L);
            this.cacheManager.storeInfoFile(segment);
            String storageDir = DataSegmentPusher.getDefaultStorageDir((DataSegment)segment, (boolean)false);
            File segmentDir = new File(this.temporaryFolder.getRoot(), storageDir);
            new TestSegmentUtils.TestLoadSpec(100, version).loadSegment(segmentDir);
            expectedSegments.add(segment);
        }
        SegmentLoadDropHandler loadDropHandler = new SegmentLoadDropHandler(this.loaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, this.segmentManager);
        SegmentBootstrapper bootstrapper = new SegmentBootstrapper(loadDropHandler, this.loaderConfig, (DataSegmentAnnouncer)this.segmentAnnouncer, (DataSegmentServerAnnouncer)this.serverAnnouncer, this.segmentManager, new ServerTypeConfig(ServerType.HISTORICAL), (CoordinatorClient)this.coordinatorClient, this.emitter, new DataSourceTaskIdHolder());
        bootstrapper.start();
        Assert.assertEquals((long)1L, (long)this.serverAnnouncer.getObservedCount());
        Assert.assertTrue((boolean)this.segmentAnnouncer.getObservedSegments().containsAll(expectedSegments));
        DataSegment newSegment = TestSegmentUtils.makeSegment("test", "new-segment", 100L);
        loadDropHandler.addSegment(newSegment, null);
        Assert.assertFalse((boolean)this.segmentAnnouncer.getObservedSegments().contains(newSegment));
        loadDropHandler.removeSegment((DataSegment)expectedSegments.get(0), null, false);
        loadDropHandler.addSegment(newSegment, null);
        Assert.assertTrue((boolean)this.segmentAnnouncer.getObservedSegments().contains(newSegment));
        bootstrapper.stop();
        Assert.assertEquals((long)0L, (long)this.serverAnnouncer.getObservedCount());
    }
}

