/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionSegmentIterator;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.compaction.NewestSegmentFirstPolicy;
import org.apache.druid.server.compaction.PriorityBasedCompactionSegmentIterator;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskTransformConfig;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.apache.druid.utils.Streams;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewestSegmentFirstPolicyTest {
    private static final int DEFAULT_NUM_SEGMENTS_PER_SHARD = 4;
    private final ObjectMapper mapper = new DefaultObjectMapper();
    private final NewestSegmentFirstPolicy policy = new NewestSegmentFirstPolicy(null);
    private CompactionStatusTracker statusTracker;

    @Before
    public void setup() {
        this.statusTracker = new CompactionStatusTracker(this.mapper);
    }

    @Test
    public void testLargeOffsetAndSmallSegmentInterval() {
        Period segmentPeriod = Period.hours((int)1);
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(new Period((Object)"P2D")).build(), NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(8, Granularities.HOUR).startingAt("2017-11-16T20:00:00Z").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(55, Granularities.HOUR).startingAt("2017-11-14").withNumPartitions(4)));
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T03:00:00/2017-11-15T04:00:00"), true);
    }

    @Test
    public void testSmallOffsetAndLargeSegmentInterval() {
        Period segmentPeriod = Period.hours((int)1);
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(new Period((Object)"PT1M")).build(), NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(8, Granularities.HOUR).startingAt("2017-11-16T20:00:00Z").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(55, Granularities.HOUR).startingAt("2017-11-14").withNumPartitions(4)));
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-17T02:00:00/2017-11-17T03:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-16T06:00:00/2017-11-16T07:00:00"), true);
    }

    @Test
    public void testLargeGapInData() {
        Period segmentPeriod = Period.hours((int)1);
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.minutes((int)61)).build(), NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(8, Granularities.HOUR).startingAt("2017-11-16T20:00:00Z").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(31, Granularities.HOUR).startingAt("2017-11-14").withNumPartitions(4)));
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-17T01:00:00/2017-11-17T02:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T06:00:00/2017-11-15T07:00:00"), true);
    }

    @Test
    public void testHugeShard() {
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.days((int)1)).build(), NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(27, Granularities.HOUR).startingAt("2017-11-17").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(4, (Granularity)new PeriodGranularity(Period.days((int)2), null, null)).startingAt("2017-11-09").withNumPartitions(1), NewestSegmentFirstPolicyTest.createSegments().forIntervals(96, Granularities.HOUR).startingAt("2017-11-05").withNumPartitions(4)));
        Interval lastInterval = null;
        while (iterator.hasNext()) {
            List segments = ((CompactionCandidate)iterator.next()).getSegments();
            lastInterval = ((DataSegment)segments.get(0)).getInterval();
            Interval prevInterval = null;
            for (DataSegment segment : segments) {
                if (prevInterval != null && !prevInterval.getStart().equals((Object)segment.getInterval().getStart())) {
                    Assert.assertEquals((Object)prevInterval.getEnd(), (Object)segment.getInterval().getStart());
                }
                prevInterval = segment.getInterval();
            }
        }
        Assert.assertNotNull(lastInterval);
        Assert.assertEquals((Object)Intervals.of((String)"2017-11-05T00:00:00/2017-11-05T01:00:00"), lastInterval);
    }

    @Test
    public void testManySegmentsPerShard() {
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.days((int)1)).build(), NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(26, Granularities.HOUR).startingAt("2017-12-04T01:00:00Z").withNumPartitions(80), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.HOUR).startingAt("2017-12-04").withNumPartitions(150), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.SIX_HOUR).startingAt("2017-12-03T18:00:00Z").withNumPartitions(1), NewestSegmentFirstPolicyTest.createSegments().forIntervals(7, Granularities.HOUR).startingAt("2017-12-03T11:00:00Z").withNumPartitions(80)));
        Interval lastInterval = null;
        while (iterator.hasNext()) {
            List segments = ((CompactionCandidate)iterator.next()).getSegments();
            lastInterval = ((DataSegment)segments.get(0)).getInterval();
            Interval prevInterval = null;
            for (DataSegment segment : segments) {
                if (prevInterval != null && !prevInterval.getStart().equals((Object)segment.getInterval().getStart())) {
                    Assert.assertEquals((Object)prevInterval.getEnd(), (Object)segment.getInterval().getStart());
                }
                prevInterval = segment.getInterval();
            }
        }
        Assert.assertNotNull(lastInterval);
        Assert.assertEquals((Object)Intervals.of((String)"2017-12-03T11:00:00/2017-12-03T12:00:00"), lastInterval);
    }

    @Test
    public void testSkipDataSourceWithNoSegments() {
        Period segmentPeriod = Period.hours((int)1);
        PriorityBasedCompactionSegmentIterator iterator = new PriorityBasedCompactionSegmentIterator((CompactionCandidateSearchPolicy)this.policy, (Map)ImmutableMap.of((Object)"koala", (Object)NewestSegmentFirstPolicyTest.configBuilder().forDataSource("koala").build(), (Object)"wiki", (Object)NewestSegmentFirstPolicyTest.configBuilder().forDataSource("wiki").withSkipOffsetFromLatest(Period.days((int)2)).build()), (Map)ImmutableMap.of((Object)"wiki", (Object)NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(8, Granularities.HOUR).startingAt("2017-11-16T20:00:00Z").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(55, Granularities.HOUR).startingAt("2017-11-14").withNumPartitions(4))), Collections.emptyMap(), this.statusTracker);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals((CompactionSegmentIterator)iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T03:00:00/2017-11-15T04:00:00"), true);
    }

    @Test
    public void testClearSegmentsToCompactWhenSkippingSegments() {
        long inputSegmentSizeBytes = 800000L;
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-12-03").withNumPartitions(1).eachOfSize(400010L));
        segments.addAll(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-12-02").withNumPartitions(1).eachOfSize(800010L));
        segments.addAll(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-12-01").withNumPartitions(2).eachOfSize(266676L));
        SegmentTimeline timeline = SegmentTimeline.forSegments(segments);
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withInputSegmentSizeBytes(Long.valueOf(800000L)).build(), timeline);
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-03/2017-12-04"), Partitions.ONLY_COMPLETE));
        expectedSegmentsToCompact.sort(Comparator.naturalOrder());
        ArrayList expectedSegmentsToCompact2 = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-01/2017-12-02"), Partitions.ONLY_COMPLETE));
        expectedSegmentsToCompact2.sort(Comparator.naturalOrder());
        Set observedSegments = Streams.sequentialStreamFrom((Iterator)iterator).map(CompactionCandidate::getSegments).collect(Collectors.toSet());
        Assert.assertEquals((Object)ImmutableSet.of(expectedSegmentsToCompact, expectedSegmentsToCompact2), observedSegments);
    }

    @Test
    public void testIfFirstSegmentIsInSkipOffset() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(2, (Granularity)new PeriodGranularity(Period.hours((int)5), null, null)).startingAt("2017-12-02T14:00:00Z").withNumPartitions(1));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.days((int)1)).build(), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIfFirstSegmentOverlapsSkipOffset() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(5, (Granularity)new PeriodGranularity(Period.hours((int)5), null, null)).startingAt("2017-12-01T23:00:00Z").withNumPartitions(1));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.days((int)1)).build(), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIfSegmentsSkipOffsetWithConfiguredSegmentGranularityEqual() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(2, Granularities.DAY).startingAt("2017-12-01").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-14").withNumPartitions(4));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.days((int)1)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.DAY, null, null)).build(), timeline);
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-14/2017-12-02"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        Set observedSegmentsToCompact = Streams.sequentialStreamFrom((Iterator)iterator).flatMap(s -> s.getSegments().stream()).collect(Collectors.toSet());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), observedSegmentsToCompact);
    }

    @Test
    public void testIfSegmentsSkipOffsetWithConfiguredSegmentGranularityLarger() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(5, (Granularity)new PeriodGranularity(Period.hours((int)5), null, null)).startingAt("2017-11-30T23:00:00Z").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(4, (Granularity)new PeriodGranularity(Period.hours((int)5), null, null)).startingAt("2017-10-14T04:00:00Z").withNumPartitions(4));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.days((int)1)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.MONTH, null, null)).build(), timeline);
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-14/P1D"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        List actual = ((CompactionCandidate)iterator.next()).getSegments();
        Assert.assertEquals((long)expectedSegmentsToCompact.size(), (long)actual.size());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)actual));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIfSegmentsSkipOffsetWithConfiguredSegmentGranularitySmaller() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(5, (Granularity)new PeriodGranularity(Period.hours((int)5), null, null)).startingAt("2017-12-01T23:00:00Z").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(4, (Granularity)new PeriodGranularity(Period.hours((int)5), null, null)).startingAt("2017-10-14").withNumPartitions(4));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.days((int)1)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.MINUTE, null, null)).build(), timeline);
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-14T00:00:00/2017-10-15T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        Set observedSegmentsToCompact = Streams.sequentialStreamFrom((Iterator)iterator).flatMap(s -> s.getSegments().stream()).collect(Collectors.toSet());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), observedSegmentsToCompact);
    }

    @Test
    public void testWithSkipIntervals() {
        Period segmentPeriod = Period.hours((int)1);
        PriorityBasedCompactionSegmentIterator iterator = new PriorityBasedCompactionSegmentIterator((CompactionCandidateSearchPolicy)this.policy, (Map)ImmutableMap.of((Object)"wiki", (Object)NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.days((int)1)).build()), (Map)ImmutableMap.of((Object)"wiki", (Object)NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(8, Granularities.HOUR).startingAt("2017-11-16T20:00:00Z").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(55, Granularities.HOUR).startingAt("2017-11-14").withNumPartitions(4))), (Map)ImmutableMap.of((Object)"wiki", (Object)ImmutableList.of((Object)Intervals.of((String)"2017-11-16T00:00:00/2017-11-17T00:00:00"), (Object)Intervals.of((String)"2017-11-15T00:00:00/2017-11-15T20:00:00"), (Object)Intervals.of((String)"2017-11-13T00:00:00/2017-11-14T01:00:00"))), this.statusTracker);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals((CompactionSegmentIterator)iterator, segmentPeriod, Intervals.of((String)"2017-11-15T20:00:00/2017-11-15T21:00:00"), Intervals.of((String)"2017-11-15T23:00:00/2017-11-16T00:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals((CompactionSegmentIterator)iterator, segmentPeriod, Intervals.of((String)"2017-11-14T01:00:00/2017-11-14T02:00:00"), Intervals.of((String)"2017-11-14T23:00:00/2017-11-15T00:00:00"), true);
    }

    @Test
    public void testHoleInSearchInterval() {
        Period segmentPeriod = Period.hours((int)1);
        PriorityBasedCompactionSegmentIterator iterator = new PriorityBasedCompactionSegmentIterator((CompactionCandidateSearchPolicy)this.policy, (Map)ImmutableMap.of((Object)"wiki", (Object)NewestSegmentFirstPolicyTest.configBuilder().withSkipOffsetFromLatest(Period.hours((int)1)).build()), (Map)ImmutableMap.of((Object)"wiki", (Object)NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.HOUR).startingAt("2017-11-16").withNumPartitions(4))), (Map)ImmutableMap.of((Object)"wiki", (Object)ImmutableList.of((Object)Intervals.of((String)"2017-11-16T04:00:00/2017-11-16T10:00:00"), (Object)Intervals.of((String)"2017-11-16T14:00:00/2017-11-16T20:00:00"))), this.statusTracker);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals((CompactionSegmentIterator)iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-16T22:00:00/2017-11-16T23:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals((CompactionSegmentIterator)iterator, segmentPeriod, Intervals.of((String)"2017-11-16T10:00:00/2017-11-16T11:00:00"), Intervals.of((String)"2017-11-16T13:00:00/2017-11-16T14:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals((CompactionSegmentIterator)iterator, segmentPeriod, Intervals.of((String)"2017-11-16T00:00:00/2017-11-16T01:00:00"), Intervals.of((String)"2017-11-16T03:00:00/2017-11-16T04:00:00"), true);
    }

    @Test
    public void testIteratorReturnsSegmentsInConfiguredSegmentGranularity() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(3, Granularities.MONTH).startingAt("2017-10-01").withNumPartitions(4));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.MONTH), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-01T00:00:00/2017-12-31T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-11-01T00:00:00/2017-12-01T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-11-01T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsInMultipleIntervalIfConfiguredSegmentGranularityCrossBoundary() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.WEEK).startingAt("2020-01-01").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.WEEK).startingAt("2020-01-28").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.WEEK).startingAt("2020-02-08").withNumPartitions(4));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.MONTH), timeline);
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2020-01-28/2020-02-15"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        List actual = ((CompactionCandidate)iterator.next()).getSegments();
        Assert.assertEquals((long)expectedSegmentsToCompact.size(), (long)actual.size());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)actual));
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2020-01-01/2020-02-03"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        actual = ((CompactionCandidate)iterator.next()).getSegments();
        Assert.assertEquals((long)expectedSegmentsToCompact.size(), (long)actual.size());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)actual));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorDoesNotReturnCompactedInterval() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-12-01").withNumPartitions(4));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.MINUTE), timeline);
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-01T00:00:00/2017-12-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsAllMixedVersionSegmentsInConfiguredSegmentGranularity() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-01").withVersion("v1").withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.HOUR).startingAt("2017-10-01").withVersion("v2").withNumPartitions(4));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.MONTH), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsNothingAsSegmentsWasCompactedAndHaveSameSegmentGranularityAndSameTimezone() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-01").withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, null)).withNumPartitions(4), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-02").withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, null)).withNumPartitions(4));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.DAY), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsNothingAsSegmentsWasCompactedAndHaveSameSegmentGranularityInLastCompactionState() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        CompactionState compactionState = new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"segmentGranularity", (Object)"day"));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(2, Granularities.DAY).startingAt("2017-10-01").withNumPartitions(4).withCompactionState(compactionState));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.DAY), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentSegmentGranularity() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        CompactionState compactionState = new CompactionState(partitionsSpec, null, null, null, indexSpec, null);
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(2, Granularities.DAY).startingAt("2017-10-01").withNumPartitions(4).withCompactionState(compactionState));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.YEAR), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentSegmentGranularityInLastCompactionState() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        CompactionState compactionState = new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"segmentGranularity", (Object)"day"));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(2, Granularities.DAY).startingAt("2017-10-01").withNumPartitions(4).withCompactionState(compactionState));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.YEAR), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentTimezone() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("Asia/Bangkok"))), null, null)).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentOrigin() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig((Granularity)new PeriodGranularity(Period.days((int)1), DateTimes.of((String)"2012-01-02T00:05:00.000Z"), DateTimeZone.UTC), null, null)).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentRollup() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-01").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"rollup", (Object)"false"))), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"rollup", (Object)"true"))), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-03").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of())));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true))).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentQueryGranularity() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-01").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"queryGranularity", (Object)"day"))), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"queryGranularity", (Object)"minute"))), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-03").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of())));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig(null, Granularities.MINUTE, null)).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentDimensions() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-01").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), null, null, indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo"))), null, null, indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-03").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, DimensionsSpec.EMPTY, null, null, indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-04").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withDimensionsSpec(new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo")))).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withDimensionsSpec(new UserCompactionTaskDimensionsConfig(null)).build(), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorDoesNotReturnsSegmentsWhenPartitionDimensionsPrefixed() {
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        DimensionRangePartitionsSpec partitionsSpec = new DimensionRangePartitionsSpec(null, Integer.valueOf(Integer.MAX_VALUE), (List)ImmutableList.of((Object)"dim2", (Object)"dim4"), false);
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-01").withNumPartitions(4).withCompactionState(new CompactionState((PartitionsSpec)partitionsSpec, new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim2", (Object)"dim4", (Object)"dim3", (Object)"dim1"))), null, null, indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState((PartitionsSpec)partitionsSpec, new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim2", (Object)"dim4", (Object)"dim1", (Object)"dim3"))), null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withDimensionsSpec(new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3", (Object)"dim4")))).withTuningConfig(new UserCompactionTaskQueryTuningConfig(null, null, null, Long.valueOf(1000L), null, (PartitionsSpec)partitionsSpec, IndexSpec.DEFAULT, null, null, null, null, null, null, null, null, null, null, null, null)).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentFilter() throws Exception {
        NullHandling.initializeForTests();
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-01").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, (Map)this.mapper.readValue(this.mapper.writeValueAsString((Object)new TransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null), null)), (TypeReference)new TypeReference<Map<String, Object>>(){}), indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, (Map)this.mapper.readValue(this.mapper.writeValueAsString((Object)new TransformSpec((DimFilter)new SelectorDimFilter("dim1", "bar", null), null)), (TypeReference)new TypeReference<Map<String, Object>>(){}), indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-03").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, (Map)this.mapper.readValue(this.mapper.writeValueAsString((Object)new TransformSpec(null, null)), (TypeReference)new TypeReference<Map<String, Object>>(){}), indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-04").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withTransformSpec(new UserCompactionTaskTransformConfig((DimFilter)new SelectorDimFilter("dim1", "bar", null))).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withTransformSpec(new UserCompactionTaskTransformConfig(null)).build(), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentMetricsSpec() {
        NullHandling.initializeForTests();
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE));
        Map indexSpec = IndexSpec.DEFAULT.asMap(this.mapper);
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-01").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, (List)this.mapper.convertValue((Object)new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, (TypeReference)new TypeReference<List<Object>>(){}), null, indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, (List)this.mapper.convertValue((Object)new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new LongSumAggregatorFactory("val", "val")}, (TypeReference)new TypeReference<List<Object>>(){}), null, indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-03").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, (List)this.mapper.convertValue((Object)new AggregatorFactory[0], (TypeReference)new TypeReference<List<Object>>(){}), null, indexSpec, null)), NewestSegmentFirstPolicyTest.createSegments().startingAt("2017-10-04").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withMetricsSpec(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new LongSumAggregatorFactory("val", "val")}).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().build(), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsSmallerSegmentGranularityCoveringMultipleSegmentsInTimeline() {
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-01").withNumPartitions(4).withVersion("v1"), NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.HOUR).startingAt("2017-10-01").withNumPartitions(4).withVersion("v2"));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.createConfigWithSegmentGranularity(Granularities.HOUR), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsCompactionStateChangedWithCompactedStateHasSameSegmentGranularity() {
        IndexSpec newIndexSpec = IndexSpec.builder().withBitmapSerdeFactory((BitmapSerdeFactory)new ConciseBitmapSerdeFactory()).build();
        Map newIndexSpecMap = (Map)this.mapper.convertValue((Object)newIndexSpec, (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-02").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, newIndexSpecMap, null)));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC), null, null)).build(), timeline);
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((CompactionCandidate)iterator.next()).getSegments()));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorDoesNotReturnSegmentWithChangingAppendableIndexSpec() {
        NullHandling.initializeForTests();
        PartitionsSpec partitionsSpec = CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null));
        SegmentTimeline timeline = NewestSegmentFirstPolicyTest.createTimeline(NewestSegmentFirstPolicyTest.createSegments().forIntervals(1, Granularities.DAY).startingAt("2017-10-01").withNumPartitions(4).withCompactionState(new CompactionState(partitionsSpec, null, null, null, IndexSpec.DEFAULT.asMap(this.mapper), null)));
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withTuningConfig(new UserCompactionTaskQueryTuningConfig(null, (AppendableIndexSpec)new OnheapIncrementalIndex.Spec(Boolean.valueOf(true)), null, Long.valueOf(1000L), null, partitionsSpec, IndexSpec.DEFAULT, null, null, null, null, null, null, null, null, null, null, null, null)).build(), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withTuningConfig(new UserCompactionTaskQueryTuningConfig(null, (AppendableIndexSpec)new OnheapIncrementalIndex.Spec(Boolean.valueOf(false)), null, Long.valueOf(1000L), null, partitionsSpec, IndexSpec.DEFAULT, null, null, null, null, null, null, null, null, null, null, null, null)).build(), timeline);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSkipAllGranularityToDefault() {
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().build(), SegmentTimeline.forSegments((Iterable)ImmutableSet.of((Object)new DataSegment("wiki", Intervals.ETERNITY, "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(0), 100L))));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSkipFirstHalfEternityToDefault() {
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().build(), SegmentTimeline.forSegments((Iterable)ImmutableSet.of((Object)new DataSegment("wiki", new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2024-01-01")), "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(0), 100L))));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSkipSecondHalfOfEternityToDefault() {
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().build(), SegmentTimeline.forSegments((Iterable)ImmutableSet.of((Object)new DataSegment("wiki", new Interval((ReadableInstant)DateTimes.of((String)"2024-01-01"), (ReadableInstant)DateTimes.MAX), "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(0), 100L))));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSkipAllToAllGranularity() {
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.ALL, null, null)).build(), SegmentTimeline.forSegments((Iterable)ImmutableSet.of((Object)new DataSegment("wiki", Intervals.ETERNITY, "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(0), 100L))));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSkipAllToFinerGranularity() {
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.DAY, null, null)).build(), SegmentTimeline.forSegments((Iterable)ImmutableSet.of((Object)new DataSegment("wiki", Intervals.ETERNITY, "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(0), 100L))));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSkipCompactionForIntervalsContainingSingleTombstone() {
        DataSegment tombstone2023 = new DataSegment("wiki", Intervals.of((String)"2023/2024"), "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)TombstoneShardSpec.INSTANCE, Integer.valueOf(0), 1L);
        DataSegment dataSegment2023 = new DataSegment("wiki", Intervals.of((String)"2023/2024"), "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedShardSpec(1, 0), Integer.valueOf(0), 100L);
        DataSegment tombstone2024 = new DataSegment("wiki", Intervals.of((String)"2024/2025"), "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)TombstoneShardSpec.INSTANCE, Integer.valueOf(0), 1L);
        CompactionSegmentIterator iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null)).build(), SegmentTimeline.forSegments((Iterable)ImmutableSet.of((Object)tombstone2023, (Object)dataSegment2023, (Object)tombstone2024)));
        Assert.assertEquals((Object)ImmutableList.of((Object)tombstone2023, (Object)dataSegment2023), (Object)((CompactionCandidate)iterator.next()).getSegments());
        DataSegment tombstone2025Jan = new DataSegment("wiki", Intervals.of((String)"2025-01-01/2025-02-01"), "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)TombstoneShardSpec.INSTANCE, Integer.valueOf(0), 1L);
        DataSegment tombstone2025Feb = new DataSegment("wiki", Intervals.of((String)"2025-02-01/2025-03-01"), "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)TombstoneShardSpec.INSTANCE, Integer.valueOf(0), 1L);
        DataSegment tombstone2025Mar = new DataSegment("wiki", Intervals.of((String)"2025-03-01/2025-04-01"), "0", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)TombstoneShardSpec.INSTANCE, Integer.valueOf(0), 1L);
        iterator = this.createIterator(NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null)).build(), SegmentTimeline.forSegments((Iterable)ImmutableSet.of((Object)tombstone2023, (Object)dataSegment2023, (Object)tombstone2024, (Object)tombstone2025Jan, (Object)tombstone2025Feb, (Object)tombstone2025Mar, (Object[])new DataSegment[0])));
        Assert.assertEquals((Object)ImmutableList.of((Object)tombstone2025Jan, (Object)tombstone2025Feb, (Object)tombstone2025Mar), (Object)((CompactionCandidate)iterator.next()).getSegments());
    }

    @Test
    public void testPriorityDatasource() {
        List<DataSegment> wikiSegments = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.DAY).startingAt("2012-01-01").withNumPartitions(10).eachOfSizeInMb(100L);
        List<DataSegment> koalaSegments = CreateDataSegments.ofDatasource("koala").forIntervals(1, Granularities.DAY).startingAt("2013-01-01").withNumPartitions(10).eachOfSizeInMb(100L);
        NewestSegmentFirstPolicy policy = new NewestSegmentFirstPolicy("wiki");
        PriorityBasedCompactionSegmentIterator iterator = new PriorityBasedCompactionSegmentIterator((CompactionCandidateSearchPolicy)policy, (Map)ImmutableMap.of((Object)"wiki", (Object)NewestSegmentFirstPolicyTest.configBuilder().forDataSource("wiki").build(), (Object)"koala", (Object)NewestSegmentFirstPolicyTest.configBuilder().forDataSource("koala").build()), (Map)ImmutableMap.of((Object)"wiki", (Object)SegmentTimeline.forSegments(wikiSegments), (Object)"koala", (Object)SegmentTimeline.forSegments(koalaSegments)), Collections.emptyMap(), this.statusTracker);
        Assert.assertTrue((boolean)iterator.hasNext());
        CompactionCandidate next = (CompactionCandidate)iterator.next();
        Assert.assertEquals((Object)"wiki", (Object)next.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2012-01-01/P1D"), (Object)next.getUmbrellaInterval());
        Assert.assertTrue((boolean)iterator.hasNext());
        next = (CompactionCandidate)iterator.next();
        Assert.assertEquals((Object)"koala", (Object)next.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2013-01-01/P1D"), (Object)next.getUmbrellaInterval());
    }

    private CompactionSegmentIterator createIterator(DataSourceCompactionConfig config, SegmentTimeline timeline) {
        return new PriorityBasedCompactionSegmentIterator((CompactionCandidateSearchPolicy)this.policy, Collections.singletonMap("wiki", config), Collections.singletonMap("wiki", timeline), Collections.emptyMap(), this.statusTracker);
    }

    private static void assertCompactSegmentIntervals(CompactionSegmentIterator iterator, Period segmentPeriod, Interval from, Interval to, boolean assertLast) {
        Interval expectedSegmentIntervalStart = to;
        while (iterator.hasNext()) {
            List segments = ((CompactionCandidate)iterator.next()).getSegments();
            Interval firstInterval = ((DataSegment)segments.get(0)).getInterval();
            Assert.assertTrue((String)"Intervals should be same or abutting", (boolean)segments.stream().allMatch(segment -> segment.getInterval().isEqual((ReadableInterval)firstInterval) || segment.getInterval().abuts((ReadableInterval)firstInterval)));
            ArrayList<Interval> expectedIntervals = new ArrayList<Interval>(segments.size());
            for (int i = 0; i < segments.size(); ++i) {
                if (i > 0 && i % 4 == 0) {
                    expectedSegmentIntervalStart = new Interval((ReadablePeriod)segmentPeriod, (ReadableInstant)expectedSegmentIntervalStart.getStart());
                }
                expectedIntervals.add(expectedSegmentIntervalStart);
            }
            expectedIntervals.sort(Comparators.intervalsByStartThenEnd());
            Assert.assertEquals(expectedIntervals, segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
            if (expectedSegmentIntervalStart.equals((Object)from)) break;
            expectedSegmentIntervalStart = new Interval((ReadablePeriod)segmentPeriod, (ReadableInstant)expectedSegmentIntervalStart.getStart());
        }
        if (assertLast) {
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    private static CreateDataSegments createSegments() {
        return CreateDataSegments.ofDatasource("wiki");
    }

    private static SegmentTimeline createTimeline(CreateDataSegments ... segmentBuilders) {
        SegmentTimeline timeline = new SegmentTimeline();
        for (CreateDataSegments builder : segmentBuilders) {
            timeline.addSegments(builder.eachOfSizeInMb(100L).iterator());
        }
        return timeline;
    }

    private static DataSourceCompactionConfig createConfigWithSegmentGranularity(Granularity segmentGranularity) {
        return NewestSegmentFirstPolicyTest.configBuilder().withGranularitySpec(new UserCompactionTaskGranularityConfig(segmentGranularity, null, null)).build();
    }

    private static DataSourceCompactionConfig.Builder configBuilder() {
        return DataSourceCompactionConfig.builder().forDataSource("wiki").withSkipOffsetFromLatest(Period.seconds((int)0));
    }
}

