/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class CompactionStatusTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private static final DataSegment WIKI_SEGMENT = DataSegment.builder().dataSource("wiki").interval(Intervals.of((String)"2013-01-01/PT1H")).size(100000000L).version("v1").build();

    @Test
    public void testFindPartitionsSpecWhenGivenIsNull() {
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from(null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsDynamicWithNullMaxTotalRows() {
        DynamicPartitionsSpec partitionsSpec = new DynamicPartitionsSpec(null, null);
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsDynamicWithMaxTotalRows() {
        DynamicPartitionsSpec partitionsSpec = new DynamicPartitionsSpec(null, Long.valueOf(1000L));
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)partitionsSpec, (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsDynamicWithMaxRowsPerSegment() {
        DynamicPartitionsSpec partitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(1000L));
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)partitionsSpec, (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithDeprecatedMaxRowsPerSegmentAndMaxTotalRowsReturnGivenValues() {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("datasource", null, null, Integer.valueOf(100), null, new UserCompactionTaskQueryTuningConfig(null, null, null, Long.valueOf(1000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, null, null, null, null, null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(1000L)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)config)));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsHashed() {
        HashedPartitionsSpec partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(100), Collections.singletonList("dim"));
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)partitionsSpec, (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsRangeWithMaxRows() {
        DimensionRangePartitionsSpec partitionsSpec = new DimensionRangePartitionsSpec(null, Integer.valueOf(10000), Collections.singletonList("dim"), false);
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)partitionsSpec, (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsRangeWithTargetRows() {
        DimensionRangePartitionsSpec partitionsSpec = new DimensionRangePartitionsSpec(Integer.valueOf(10000), null, Collections.singletonList("dim"), false);
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)new DimensionRangePartitionsSpec(null, Integer.valueOf(15000), Collections.singletonList("dim"), false), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testStatusWhenLastCompactionStateIsNull() {
        this.verifyCompactionStatusIsPendingBecause(null, DataSourceCompactionConfig.builder().forDataSource("wiki").build(), "not compacted yet");
    }

    @Test
    public void testStatusWhenLastCompactionStateIsEmpty() {
        this.verifyCompactionStatusIsPendingBecause(new CompactionState(null, null, null, null, null, null), DataSourceCompactionConfig.builder().forDataSource("wiki").build(), "'partitionsSpec' mismatch: required['dynamic' with 5,000,000 rows], current[null]");
    }

    @Test
    public void testStatusOnPartitionsSpecMismatch() {
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, null, null);
        DataSourceCompactionConfig compactionConfig = DataSourceCompactionConfig.builder().forDataSource("wiki").build();
        this.verifyCompactionStatusIsPendingBecause(lastCompactionState, compactionConfig, "'partitionsSpec' mismatch: required['dynamic' with 5,000,000 rows], current['dynamic' with 100 rows]");
    }

    @Test
    public void testStatusOnIndexSpecMismatch() {
        IndexSpec currentIndexSpec = IndexSpec.builder().withDimensionCompression(CompressionStrategy.ZSTD).build();
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, currentIndexSpec.asMap(OBJECT_MAPPER), null);
        DataSourceCompactionConfig compactionConfig = DataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, null)).build();
        this.verifyCompactionStatusIsPendingBecause(lastCompactionState, compactionConfig, "'indexSpec' mismatch: required[IndexSpec{bitmapSerdeFactory=RoaringBitmapSerdeFactory{}, dimensionCompression=lz4, stringDictionaryEncoding=Utf8{}, metricCompression=lz4, longEncoding=longs, complexMetricCompression=null, jsonCompression=null, segmentLoader=null}], current[IndexSpec{bitmapSerdeFactory=RoaringBitmapSerdeFactory{}, dimensionCompression=zstd, stringDictionaryEncoding=Utf8{}, metricCompression=lz4, longEncoding=longs, complexMetricCompression=null, jsonCompression=null, segmentLoader=null}]");
    }

    @Test
    public void testStatusOnSegmentGranularityMismatch() {
        UniformGranularitySpec currentGranularitySpec = new UniformGranularitySpec(Granularities.HOUR, null, null);
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        IndexSpec currentIndexSpec = IndexSpec.builder().withDimensionCompression(CompressionStrategy.ZSTD).build();
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, currentIndexSpec.asMap(OBJECT_MAPPER), currentGranularitySpec.asMap(OBJECT_MAPPER));
        DataSourceCompactionConfig compactionConfig = DataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, currentIndexSpec)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.DAY, null, null)).build();
        this.verifyCompactionStatusIsPendingBecause(lastCompactionState, compactionConfig, "'segmentGranularity' mismatch: required[DAY], current[HOUR]");
    }

    @Test
    public void testStatusWhenLastCompactionStateSameAsRequired() {
        UniformGranularitySpec currentGranularitySpec = new UniformGranularitySpec(Granularities.HOUR, null, null);
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        IndexSpec currentIndexSpec = IndexSpec.builder().withDimensionCompression(CompressionStrategy.ZSTD).build();
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, currentIndexSpec.asMap(OBJECT_MAPPER), currentGranularitySpec.asMap(OBJECT_MAPPER));
        DataSourceCompactionConfig compactionConfig = DataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, currentIndexSpec)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).build();
        DataSegment segment = DataSegment.builder((DataSegment)WIKI_SEGMENT).lastCompactionState(lastCompactionState).build();
        CompactionStatus status = CompactionStatus.compute((CompactionCandidate)CompactionCandidate.from(Collections.singletonList(segment)), (DataSourceCompactionConfig)compactionConfig, (ObjectMapper)OBJECT_MAPPER);
        Assert.assertTrue((boolean)status.isComplete());
    }

    private void verifyCompactionStatusIsPendingBecause(CompactionState lastCompactionState, DataSourceCompactionConfig compactionConfig, String expectedReason) {
        DataSegment segment = DataSegment.builder((DataSegment)WIKI_SEGMENT).lastCompactionState(lastCompactionState).build();
        CompactionStatus status = CompactionStatus.compute((CompactionCandidate)CompactionCandidate.from(Collections.singletonList(segment)), (DataSourceCompactionConfig)compactionConfig, (ObjectMapper)OBJECT_MAPPER);
        Assert.assertFalse((boolean)status.isComplete());
        Assert.assertEquals((Object)expectedReason, (Object)status.getReason());
    }

    private static DataSourceCompactionConfig createCompactionConfig(PartitionsSpec partitionsSpec) {
        return DataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig(partitionsSpec, null)).build();
    }

    private static UserCompactionTaskQueryTuningConfig createTuningConfig(PartitionsSpec partitionsSpec, IndexSpec indexSpec) {
        return new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, partitionsSpec, indexSpec, null, null, null, null, null, null, null, null, null, null, null, null);
    }
}

