/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.router.RendezvousHasher;
import org.junit.Assert;
import org.junit.Test;

public class RendezvousHasherTest {
    private static int NUM_ITERATIONS = 10000;
    private static final Logger log = new Logger(RendezvousHasherTest.class);

    @Test
    public void testBasic() {
        int i;
        RendezvousHasher hasher = new RendezvousHasher();
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashMap<String, String> uuidServerMap = new HashMap<String, String>();
        for (i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        for (i = 0; i < 2; ++i) {
            for (Map.Entry entry : uuidServerMap.entrySet()) {
                String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)((String)entry.getKey())));
                Assert.assertEquals(entry.getValue(), (Object)targetServer);
            }
        }
    }

    @Test
    public void testAddNode() {
        RendezvousHasher hasher = new RendezvousHasher();
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashMap<String, Object> uuidServerMap = new HashMap<String, Object>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        nodes.add("localhost:6");
        int same = 0;
        int diff = 0;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)((String)entry.getKey())));
            if (((String)entry.getValue()).equals(targetServer)) {
                ++same;
                continue;
            }
            ++diff;
        }
        log.info(StringUtils.format((String)"testAddNode Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{NUM_ITERATIONS, same, diff}), new Object[0]);
        double diffRatio = (double)diff / (double)NUM_ITERATIONS;
        Assert.assertTrue((diffRatio < 0.33 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNode() {
        RendezvousHasher hasher = new RendezvousHasher();
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashMap<String, Object> uuidServerMap = new HashMap<String, Object>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        nodes.remove("localhost:3");
        int same = 0;
        int diff = 0;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)((String)entry.getKey())));
            if (((String)entry.getValue()).equals(targetServer)) {
                ++same;
                continue;
            }
            ++diff;
        }
        log.info(StringUtils.format((String)"testRemoveNode Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{NUM_ITERATIONS, same, diff}), new Object[0]);
        double diffRatio = (double)diff / (double)NUM_ITERATIONS;
        Assert.assertTrue((diffRatio < 0.33 ? 1 : 0) != 0);
    }

    @Test
    public void testInconsistentView1() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:3");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView1", nodes, nodes2, 0.33);
    }

    @Test
    public void testInconsistentView2() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:2");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView2", nodes, nodes2, 0.55);
    }

    @Test
    public void testInconsistentView3() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView3", nodes, nodes2, 0.66);
    }

    @Test
    public void testInconsistentView4() {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:2");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView4", nodes, nodes2, 0.95);
    }

    /*
     * WARNING - void declaration
     */
    public void testInconsistentViewHelper(String testName, Set<String> nodes, Set<String> nodes2, double expectedDiffRatio) {
        void var11_14;
        RendezvousHasher hasher = new RendezvousHasher();
        HashMap<String, Object> uuidServerMap = new HashMap<String, Object>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        RendezvousHasher hasher2 = new RendezvousHasher();
        HashMap<String, Object> uuidServerMap2 = new HashMap<String, Object>();
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher2.chooseNode(nodes2, StringUtils.toUtf8((String)((String)entry.getKey())));
            uuidServerMap2.put((String)entry.getKey(), targetServer);
        }
        int same = 0;
        boolean bl = false;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String otherServer = (String)uuidServerMap2.get(entry.getKey());
            if (((String)entry.getValue()).equals(otherServer)) {
                ++same;
                continue;
            }
            ++var11_14;
        }
        double actualDiffRatio = (double)var11_14 / (double)NUM_ITERATIONS;
        log.info(StringUtils.format((String)"%s Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{testName, NUM_ITERATIONS, same, (int)var11_14}), new Object[0]);
        log.info("Expected diff ratio: %s, Actual diff ratio: %s", new Object[]{expectedDiffRatio, actualDiffRatio});
        Assert.assertTrue((actualDiffRatio <= expectedDiffRatio ? 1 : 0) != 0);
    }

    @Test
    public void testDistribution() throws IOException {
        String[] uuids = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("random_uuid_100")), (Charset)StandardCharsets.UTF_8).split("\n");
        RendezvousHasher hasher = new RendezvousHasher();
        HashSet<String> nodes = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            nodes.add("localhost:" + i);
        }
        HashMap<String, Integer> brokerToConnectionCount = new HashMap<String, Integer>();
        for (String uuid : uuids) {
            brokerToConnectionCount.merge(hasher.chooseNode(nodes, uuid.getBytes(StandardCharsets.UTF_8)), 1, Integer::sum);
        }
        ImmutableMap expectedDistribution = ImmutableMap.builder().put((Object)"localhost:0", (Object)14).put((Object)"localhost:1", (Object)22).put((Object)"localhost:2", (Object)24).put((Object)"localhost:3", (Object)25).put((Object)"localhost:4", (Object)15).build();
        Assert.assertEquals((Object)expectedDistribution, brokerToConnectionCount);
    }
}

