/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.druid.data.input.Committer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.PublishedSegmentRetriever;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.apache.druid.segment.realtime.appenderator.StreamAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.StreamAppenderatorDriverTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.hamcrest.CoreMatchers;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamAppenderatorDriverFailTest
extends EasyMockSupport {
    private static final String DATA_SOURCE = "foo";
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private static final long PUBLISH_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final List<InputRow> ROWS = ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"2000"), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"foo", (Object)"met1", (Object)"1")), (Object)new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"foo", (Object)"met1", (Object)2.0)), (Object)new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"dim2"), (Map)ImmutableMap.of((Object)"dim2", (Object)"bar", (Object)"met1", (Object)2.0)));
    SegmentAllocator allocator;
    StreamAppenderatorDriverTest.TestSegmentHandoffNotifierFactory segmentHandoffNotifierFactory;
    StreamAppenderatorDriver driver;
    DataSegmentKiller dataSegmentKiller;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.allocator = new StreamAppenderatorDriverTest.TestSegmentAllocator(DATA_SOURCE, Granularities.HOUR);
        this.segmentHandoffNotifierFactory = new StreamAppenderatorDriverTest.TestSegmentHandoffNotifierFactory();
        this.dataSegmentKiller = (DataSegmentKiller)this.createStrictMock(DataSegmentKiller.class);
    }

    @After
    public void tearDown() throws Exception {
        if (this.driver != null) {
            this.driver.clear();
            this.driver.close();
        }
    }

    @Test
    public void testFailDuringPersist() throws IOException, InterruptedException, TimeoutException, ExecutionException {
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(ISE.class));
        this.expectedException.expectMessage("Fail test while persisting segments[[foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_abc123, foo_2000-01-01T01:00:00.000Z_2000-01-01T02:00:00.000Z_abc123]]");
        this.driver = new StreamAppenderatorDriver(StreamAppenderatorDriverFailTest.createPersistFailAppenderator(), this.allocator, (SegmentHandoffNotifierFactory)this.segmentHandoffNotifierFactory, (PublishedSegmentRetriever)new NoopPublishedSegmentRetriever(), this.dataSegmentKiller, OBJECT_MAPPER, new SegmentGenerationMetrics());
        this.driver.startJob(null);
        StreamAppenderatorDriverTest.TestCommitterSupplier<Integer> committerSupplier = new StreamAppenderatorDriverTest.TestCommitterSupplier<Integer>();
        this.segmentHandoffNotifierFactory.setHandoffDelay(100L);
        Assert.assertNull((Object)this.driver.startJob(null));
        for (int i = 0; i < ROWS.size(); ++i) {
            committerSupplier.setMetadata(i + 1);
            Assert.assertTrue((boolean)this.driver.add(ROWS.get(i), "dummy", committerSupplier, false, true).isOk());
        }
        this.driver.publish(StreamAppenderatorDriverTest.makeOkPublisher(), committerSupplier.get(), (Collection)ImmutableList.of((Object)"dummy")).get(PUBLISH_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testFailDuringPush() throws IOException, InterruptedException, TimeoutException, ExecutionException {
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(ISE.class));
        this.expectedException.expectMessage("Fail test while pushing segments[[foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_abc123, foo_2000-01-01T01:00:00.000Z_2000-01-01T02:00:00.000Z_abc123]]");
        this.driver = new StreamAppenderatorDriver(StreamAppenderatorDriverFailTest.createPushFailAppenderator(), this.allocator, (SegmentHandoffNotifierFactory)this.segmentHandoffNotifierFactory, (PublishedSegmentRetriever)new NoopPublishedSegmentRetriever(), this.dataSegmentKiller, OBJECT_MAPPER, new SegmentGenerationMetrics());
        this.driver.startJob(null);
        StreamAppenderatorDriverTest.TestCommitterSupplier<Integer> committerSupplier = new StreamAppenderatorDriverTest.TestCommitterSupplier<Integer>();
        this.segmentHandoffNotifierFactory.setHandoffDelay(100L);
        Assert.assertNull((Object)this.driver.startJob(null));
        for (int i = 0; i < ROWS.size(); ++i) {
            committerSupplier.setMetadata(i + 1);
            Assert.assertTrue((boolean)this.driver.add(ROWS.get(i), "dummy", committerSupplier, false, true).isOk());
        }
        this.driver.publish(StreamAppenderatorDriverTest.makeOkPublisher(), committerSupplier.get(), (Collection)ImmutableList.of((Object)"dummy")).get(PUBLISH_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testFailDuringDrop() throws IOException, InterruptedException, TimeoutException, ExecutionException {
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(ISE.class));
        this.expectedException.expectMessage("Fail test while dropping segment");
        this.driver = new StreamAppenderatorDriver(StreamAppenderatorDriverFailTest.createDropFailAppenderator(), this.allocator, (SegmentHandoffNotifierFactory)this.segmentHandoffNotifierFactory, (PublishedSegmentRetriever)new NoopPublishedSegmentRetriever(), this.dataSegmentKiller, OBJECT_MAPPER, new SegmentGenerationMetrics());
        this.driver.startJob(null);
        StreamAppenderatorDriverTest.TestCommitterSupplier<Integer> committerSupplier = new StreamAppenderatorDriverTest.TestCommitterSupplier<Integer>();
        this.segmentHandoffNotifierFactory.setHandoffDelay(100L);
        Assert.assertNull((Object)this.driver.startJob(null));
        committerSupplier.setMetadata(1);
        Assert.assertTrue((boolean)this.driver.add(ROWS.get(0), "dummy", committerSupplier, false, true).isOk());
        SegmentsAndCommitMetadata published = (SegmentsAndCommitMetadata)this.driver.publish(StreamAppenderatorDriverTest.makeOkPublisher(), committerSupplier.get(), (Collection)ImmutableList.of((Object)"dummy")).get(PUBLISH_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        this.driver.registerHandoff(published).get();
    }

    @Test
    public void testFailDuringPublish() throws Exception {
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(ISE.class));
        this.expectedException.expectMessage("Failed to publish segments because of [test]");
        this.testFailDuringPublishInternal(false);
    }

    @Test
    public void testFailWithExceptionDuringPublish() throws Exception {
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(RuntimeException.class));
        this.expectedException.expectMessage("test");
        this.testFailDuringPublishInternal(true);
    }

    private void testFailDuringPublishInternal(boolean failWithException) throws Exception {
        this.driver = new StreamAppenderatorDriver((Appenderator)new FailableAppenderator(), this.allocator, (SegmentHandoffNotifierFactory)this.segmentHandoffNotifierFactory, (PublishedSegmentRetriever)new NoopPublishedSegmentRetriever(), this.dataSegmentKiller, OBJECT_MAPPER, new SegmentGenerationMetrics());
        this.driver.startJob(null);
        StreamAppenderatorDriverTest.TestCommitterSupplier<Integer> committerSupplier = new StreamAppenderatorDriverTest.TestCommitterSupplier<Integer>();
        this.segmentHandoffNotifierFactory.setHandoffDelay(100L);
        Assert.assertNull((Object)this.driver.startJob(null));
        for (int i = 0; i < ROWS.size(); ++i) {
            committerSupplier.setMetadata(i + 1);
            Assert.assertTrue((boolean)this.driver.add(ROWS.get(i), "dummy", committerSupplier, false, true).isOk());
        }
        if (!failWithException) {
            this.dataSegmentKiller.killQuietly(new DataSegment(DATA_SOURCE, Intervals.of((String)"2000-01-01T00:00:00.000Z/2000-01-01T01:00:00.000Z"), "abc123", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(0), 0L));
            EasyMock.expectLastCall().once();
            this.dataSegmentKiller.killQuietly(new DataSegment(DATA_SOURCE, Intervals.of((String)"2000-01-01T01:00:00.000Z/2000-01-01T02:00:00.000Z"), "abc123", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(0), 0L));
            EasyMock.expectLastCall().once();
        }
        EasyMock.replay((Object[])new Object[]{this.dataSegmentKiller});
        try {
            this.driver.publish(StreamAppenderatorDriverTest.makeFailingPublisher(failWithException), committerSupplier.get(), (Collection)ImmutableList.of((Object)"dummy")).get(PUBLISH_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{this.dataSegmentKiller});
                throw throwable;
            }
        }
        EasyMock.verify((Object[])new Object[]{this.dataSegmentKiller});
    }

    static Appenderator createPushFailAppenderator() {
        return new FailableAppenderator().disablePush();
    }

    static Appenderator createPersistFailAppenderator() {
        return new FailableAppenderator().disablePersist();
    }

    static Appenderator createDropFailAppenderator() {
        return new FailableAppenderator().disableDrop();
    }

    private static class NoopPublishedSegmentRetriever
    implements PublishedSegmentRetriever {
        private NoopPublishedSegmentRetriever() {
        }

        public Set<DataSegment> findPublishedSegments(Set<SegmentId> identifiers) {
            return ImmutableSet.of();
        }
    }

    private static class FailableAppenderator
    implements Appenderator {
        private final Map<SegmentIdWithShardSpec, List<InputRow>> rows = new TreeMap<SegmentIdWithShardSpec, List<InputRow>>();
        private boolean dropEnabled = true;
        private boolean persistEnabled = true;
        private boolean pushEnabled = true;
        private boolean interruptPush = false;
        private int numRows;

        private FailableAppenderator() {
        }

        public FailableAppenderator disableDrop() {
            this.dropEnabled = false;
            return this;
        }

        public FailableAppenderator disablePersist() {
            this.persistEnabled = false;
            return this;
        }

        public FailableAppenderator disablePush() {
            this.pushEnabled = false;
            this.interruptPush = false;
            return this;
        }

        public FailableAppenderator interruptPush() {
            this.pushEnabled = false;
            this.interruptPush = true;
            return this;
        }

        public String getId() {
            return null;
        }

        public String getDataSource() {
            return null;
        }

        public Object startJob() {
            return null;
        }

        public Appenderator.AppenderatorAddResult add(SegmentIdWithShardSpec identifier, InputRow row, Supplier<Committer> committerSupplier, boolean allowIncrementalPersists) {
            this.rows.computeIfAbsent(identifier, k -> new ArrayList()).add(row);
            ++this.numRows;
            return new Appenderator.AppenderatorAddResult(identifier, this.numRows, false);
        }

        public List<SegmentIdWithShardSpec> getSegments() {
            return ImmutableList.copyOf(this.rows.keySet());
        }

        public int getRowCount(SegmentIdWithShardSpec identifier) {
            List<InputRow> rows = this.rows.get(identifier);
            if (rows != null) {
                return rows.size();
            }
            return 0;
        }

        public int getTotalRowCount() {
            return this.numRows;
        }

        public void clear() {
            this.rows.clear();
        }

        public ListenableFuture<?> drop(SegmentIdWithShardSpec identifier) {
            if (this.dropEnabled) {
                this.rows.remove(identifier);
                return Futures.immediateFuture(null);
            }
            return Futures.immediateFailedFuture((Throwable)new ISE("Fail test while dropping segment[%s]", new Object[]{identifier}));
        }

        public ListenableFuture<Object> persistAll(Committer committer) {
            if (this.persistEnabled) {
                return Futures.immediateFuture((Object)committer.getMetadata());
            }
            return Futures.immediateFailedFuture((Throwable)new ISE("Fail test while persisting segments[%s]", new Object[]{this.rows.keySet()}));
        }

        public ListenableFuture<SegmentsAndCommitMetadata> push(Collection<SegmentIdWithShardSpec> identifiers, Committer committer, boolean useUniquePath) {
            if (this.pushEnabled) {
                List segments = identifiers.stream().map(id -> new DataSegment(id.getDataSource(), id.getInterval(), id.getVersion(), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), id.getShardSpec(), Integer.valueOf(0), 0L)).collect(Collectors.toList());
                return Futures.transform(this.persistAll(committer), commitMetadata -> new SegmentsAndCommitMetadata(segments, commitMetadata, null), (Executor)MoreExecutors.directExecutor());
            }
            if (this.interruptPush) {
                return new AbstractFuture<SegmentsAndCommitMetadata>(){

                    public SegmentsAndCommitMetadata get(long timeout, TimeUnit unit) throws InterruptedException {
                        throw new InterruptedException("Interrupt test while pushing segments");
                    }

                    public SegmentsAndCommitMetadata get() throws InterruptedException {
                        throw new InterruptedException("Interrupt test while pushing segments");
                    }
                };
            }
            return Futures.immediateFailedFuture((Throwable)new ISE("Fail test while pushing segments[%s]", new Object[]{identifiers}));
        }

        public void close() {
        }

        public void closeNow() {
        }

        public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
            throw new UnsupportedOperationException();
        }

        public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
            throw new UnsupportedOperationException();
        }
    }
}

