/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentGenerationMetricsTest {
    private SegmentGenerationMetrics metrics;

    @Before
    public void setup() {
        this.metrics = new SegmentGenerationMetrics();
    }

    @Test
    public void testSnapshotBeforeProcessing() {
        SegmentGenerationMetrics snapshot = this.metrics.snapshot();
        Assert.assertEquals((long)0L, (long)snapshot.messageGap());
        Assert.assertTrue((0L > snapshot.maxSegmentHandoffTime() ? 1 : 0) != 0);
    }

    @Test
    public void testSnapshotAfterProcessingOver() {
        this.metrics.reportMessageMaxTimestamp(System.currentTimeMillis() - 20L);
        this.metrics.reportMaxSegmentHandoffTime(7L);
        SegmentGenerationMetrics snapshot = this.metrics.snapshot();
        Assert.assertTrue((snapshot.messageGap() >= 20L ? 1 : 0) != 0);
        Assert.assertEquals((long)7L, (long)snapshot.maxSegmentHandoffTime());
    }

    @Test
    public void testProcessingOverAfterSnapshot() {
        this.metrics.reportMessageMaxTimestamp(10L);
        this.metrics.reportMaxSegmentHandoffTime(7L);
        this.metrics.snapshot();
        this.metrics.markProcessingDone();
        SegmentGenerationMetrics snapshot = this.metrics.snapshot();
        Assert.assertTrue((0L > snapshot.messageGap() ? 1 : 0) != 0);
        Assert.assertTrue((0L > snapshot.maxSegmentHandoffTime() ? 1 : 0) != 0);
    }
}

