/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.storage.derby.DerbyConnector;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.junit.Assert;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;

public class SegmentSchemaTestUtils {
    private final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule;
    private final DerbyConnector derbyConnector;
    private final ObjectMapper mapper;

    public SegmentSchemaTestUtils(TestDerbyConnector.DerbyConnectorRule derbyConnectorRule, DerbyConnector derbyConnector, ObjectMapper mapper) {
        this.derbyConnectorRule = derbyConnectorRule;
        this.derbyConnector = derbyConnector;
        this.mapper = mapper;
    }

    public Boolean insertUsedSegments(Set<DataSegment> dataSegments, Map<String, Pair<String, Long>> segmentMetadata) {
        if (!segmentMetadata.isEmpty()) {
            String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
            return (Boolean)this.derbyConnector.retryWithHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated, schema_fingerprint, num_rows) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated, :schema_fingerprint, :num_rows)", (Object[])new Object[]{table, this.derbyConnector.getQuoteString()}));
                for (DataSegment segment : dataSegments) {
                    String id = segment.getId().toString();
                    ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)preparedBatch.add().bind("id", id)).bind("dataSource", segment.getDataSource())).bind("created_date", DateTimes.nowUtc().toString())).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", !(segment.getShardSpec() instanceof NoneShardSpec))).bind("version", segment.getVersion())).bind("used", true)).bind("payload", this.mapper.writeValueAsBytes((Object)segment))).bind("used_status_last_updated", DateTimes.nowUtc().toString())).bind("schema_fingerprint", segmentMetadata.containsKey(id) ? (String)((Pair)segmentMetadata.get((Object)id)).lhs : null)).bind("num_rows", segmentMetadata.containsKey(id) ? (Long)((Pair)segmentMetadata.get((Object)id)).rhs : null);
                }
                int[] affectedRows = preparedBatch.execute();
                boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
                if (!succeeded) {
                    throw new ISE("Failed to publish segments to DB", new Object[0]);
                }
                return true;
            });
        }
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (Boolean)this.derbyConnector.retryWithHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated)", (Object[])new Object[]{table, this.derbyConnector.getQuoteString()}));
            for (DataSegment segment : dataSegments) {
                String id = segment.getId().toString();
                ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)preparedBatch.add().bind("id", id)).bind("dataSource", segment.getDataSource())).bind("created_date", DateTimes.nowUtc().toString())).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", !(segment.getShardSpec() instanceof NoneShardSpec))).bind("version", segment.getVersion())).bind("used", true)).bind("payload", this.mapper.writeValueAsBytes((Object)segment))).bind("used_status_last_updated", DateTimes.nowUtc().toString());
            }
            int[] affectedRows = preparedBatch.execute();
            boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
            if (!succeeded) {
                throw new ISE("Failed to publish segments to DB", new Object[0]);
            }
            return true;
        });
    }

    public void insertSegmentSchema(String dataSource, Map<String, SchemaPayload> schemaPayloadMap, Set<String> usedFingerprints) {
        String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentSchemasTable();
        this.derbyConnector.retryWithHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (created_date, datasource, fingerprint, payload, used, used_status_last_updated, version) VALUES (:created_date, :datasource, :fingerprint, :payload, :used, :used_status_last_updated, :version)", (Object[])new Object[]{table}));
            for (Map.Entry entry : schemaPayloadMap.entrySet()) {
                String fingerprint = (String)entry.getKey();
                SchemaPayload payload = (SchemaPayload)entry.getValue();
                String now = DateTimes.nowUtc().toString();
                ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)preparedBatch.add().bind("created_date", now)).bind("datasource", dataSource)).bind("fingerprint", fingerprint)).bind("payload", this.mapper.writeValueAsBytes((Object)payload))).bind("used", usedFingerprints.contains(fingerprint))).bind("used_status_last_updated", now)).bind("version", 1);
            }
            int[] affectedRows = preparedBatch.execute();
            boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
            if (!succeeded) {
                throw new ISE("Failed to publish segments to DB", new Object[0]);
            }
            return true;
        });
    }

    public void verifySegmentSchema(Map<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap) {
        String segmentsTable = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        HashMap segmentStats = new HashMap();
        this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT id, schema_fingerprint, num_rows FROM " + segmentsTable + " WHERE used = true ORDER BY id").map((index, result, context) -> segmentStats.put(result.getString(1), Pair.of((Object)result.getString(2), (Object)result.getLong(3)))).list());
        HashMap schemaRepresentationMap = new HashMap();
        String schemaTable = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentSchemasTable();
        this.derbyConnector.retryWithHandle(handle -> handle.createQuery("SELECT fingerprint, payload, created_date, used, version FROM " + schemaTable).map((index, r, ctx) -> schemaRepresentationMap.put(r.getString(1), new SegmentSchemaRecord(r.getString(1), (SchemaPayload)JacksonUtils.readValue((ObjectMapper)this.mapper, (byte[])r.getBytes(2), SchemaPayload.class), r.getString(3), r.getBoolean(4), r.getInt(5)))).list());
        for (Map.Entry<String, Pair<SchemaPayload, Integer>> entry : segmentIdSchemaMap.entrySet()) {
            String id = entry.getKey();
            SchemaPayload schemaPayload = (SchemaPayload)entry.getValue().lhs;
            Integer random = (Integer)entry.getValue().rhs;
            Assert.assertTrue((boolean)segmentStats.containsKey(id));
            Assert.assertEquals((long)random.intValue(), (long)((Long)((Pair)segmentStats.get((Object)id)).rhs).intValue());
            Assert.assertTrue((boolean)schemaRepresentationMap.containsKey(((Pair)segmentStats.get((Object)id)).lhs));
            SegmentSchemaRecord schemaRepresentation = (SegmentSchemaRecord)schemaRepresentationMap.get(((Pair)segmentStats.get((Object)id)).lhs);
            Assert.assertEquals((Object)schemaPayload, (Object)schemaRepresentation.getSchemaPayload());
            Assert.assertTrue((boolean)schemaRepresentation.isUsed());
            Assert.assertEquals((long)1L, (long)schemaRepresentation.getVersion());
        }
    }

    public static class SegmentSchemaRecord {
        private final String fingerprint;
        private final SchemaPayload schemaPayload;
        private final String createdDate;
        private final boolean used;
        private final int version;

        public SegmentSchemaRecord(String fingerprint, SchemaPayload schemaPayload, String createdDate, Boolean used, int version) {
            this.fingerprint = fingerprint;
            this.schemaPayload = schemaPayload;
            this.createdDate = createdDate;
            this.used = used;
            this.version = version;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public SchemaPayload getSchemaPayload() {
            return this.schemaPayload;
        }

        public String getCreatedDate() {
            return this.createdDate;
        }

        public boolean isUsed() {
            return this.used;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

