/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Optional;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;

public class SegmentSchemaCacheTest {
    @Test
    public void testCacheRealtimeSegmentSchema() {
        SegmentSchemaCache cache = new SegmentSchemaCache((ServiceEmitter)new NoopServiceEmitter());
        RowSignature rowSignature = RowSignature.builder().add("cx", ColumnType.FLOAT).build();
        SchemaPayloadPlus expected = new SchemaPayloadPlus(new SchemaPayload(rowSignature), Long.valueOf(20L));
        SegmentId id = SegmentId.dummy((String)"ds");
        cache.addRealtimeSegmentSchema(id, rowSignature, 20L);
        Assert.assertTrue((boolean)cache.isSchemaCached(id));
        Optional schema = cache.getSchemaForSegment(id);
        Assert.assertTrue((boolean)schema.isPresent());
        Assert.assertEquals((Object)expected, schema.get());
        cache.segmentRemoved(id);
        Assert.assertFalse((boolean)cache.isSchemaCached(id));
    }

    @Test
    public void testCacheTemporaryMetadataQueryResults() {
        SegmentSchemaCache cache = new SegmentSchemaCache((ServiceEmitter)new NoopServiceEmitter());
        RowSignature rowSignature = RowSignature.builder().add("cx", ColumnType.FLOAT).build();
        SchemaPayloadPlus expected = new SchemaPayloadPlus(new SchemaPayload(rowSignature, Collections.emptyMap()), Long.valueOf(20L));
        SegmentId id = SegmentId.dummy((String)"ds");
        SegmentId id2 = SegmentId.dummy((String)"ds2");
        cache.markMetadataQueryResultPublished(id);
        cache.addTemporaryMetadataQueryResult(id, rowSignature, Collections.emptyMap(), 20L);
        cache.addTemporaryMetadataQueryResult(id2, rowSignature, Collections.emptyMap(), 20L);
        Assert.assertTrue((boolean)cache.isSchemaCached(id));
        Assert.assertTrue((boolean)cache.isSchemaCached(id2));
        Optional schema = cache.getSchemaForSegment(id);
        Assert.assertTrue((boolean)schema.isPresent());
        Assert.assertEquals((Object)expected, schema.get());
        Optional schema2 = cache.getSchemaForSegment(id);
        Assert.assertTrue((boolean)schema2.isPresent());
        Assert.assertEquals((Object)expected, schema2.get());
        cache.markMetadataQueryResultPublished(id);
        cache.markMetadataQueryResultPublished(id2);
        schema = cache.getSchemaForSegment(id);
        Assert.assertTrue((boolean)schema.isPresent());
        Assert.assertEquals((Object)expected, schema.get());
        ImmutableMap.Builder segmentMetadataBuilder = ImmutableMap.builder();
        segmentMetadataBuilder.put((Object)id, (Object)new SegmentMetadata(Long.valueOf(5L), "fp"));
        ImmutableMap.Builder schemaPayloadBuilder = ImmutableMap.builder();
        schemaPayloadBuilder.put((Object)"fp", (Object)new SchemaPayload(rowSignature));
        SegmentSchemaCache.FinalizedSegmentSchemaInfo finalizedSegmentSchemaInfo = new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentMetadataBuilder.build(), schemaPayloadBuilder.build());
        cache.updateFinalizedSegmentSchema(finalizedSegmentSchemaInfo);
        Assert.assertNull((Object)cache.getTemporaryPublishedMetadataQueryResults(id));
        Assert.assertNotNull((Object)cache.getTemporaryPublishedMetadataQueryResults(id2));
        Assert.assertTrue((boolean)cache.isSchemaCached(id));
        Assert.assertTrue((boolean)cache.isSchemaCached(id2));
        schema = cache.getSchemaForSegment(id);
        Assert.assertTrue((boolean)schema.isPresent());
        schema2 = cache.getSchemaForSegment(id2);
        Assert.assertTrue((boolean)schema2.isPresent());
    }

    @Test
    public void testCacheFinalizedSegmentSchema() {
        SegmentSchemaCache cache = new SegmentSchemaCache((ServiceEmitter)new NoopServiceEmitter());
        Assert.assertFalse((boolean)cache.isInitialized());
        RowSignature rowSignature = RowSignature.builder().add("cx", ColumnType.FLOAT).build();
        SchemaPayloadPlus expected = new SchemaPayloadPlus(new SchemaPayload(rowSignature), Long.valueOf(20L));
        SegmentId id = SegmentId.dummy((String)"ds");
        ImmutableMap.Builder schemaPayloadBuilder = new ImmutableMap.Builder();
        schemaPayloadBuilder.put((Object)"fp1", (Object)new SchemaPayload(rowSignature));
        ImmutableMap.Builder segmentMetadataBuilder = new ImmutableMap.Builder();
        segmentMetadataBuilder.put((Object)id, (Object)new SegmentMetadata(Long.valueOf(20L), "fp1"));
        cache.updateFinalizedSegmentSchema(new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentMetadataBuilder.build(), schemaPayloadBuilder.build()));
        Assert.assertTrue((boolean)cache.isInitialized());
        Assert.assertTrue((boolean)cache.isSchemaCached(id));
        Optional schema = cache.getSchemaForSegment(id);
        Assert.assertTrue((boolean)schema.isPresent());
        Assert.assertEquals((Object)expected, schema.get());
    }
}

