/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.SegmentSchemaBackFillQueue;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.metadata.SegmentSchemaTestUtils;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Rule;
import org.junit.Test;

public class SegmentSchemaBackFillQueueTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule(this.getEnabledConfig());
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testPublishSchema() throws InterruptedException {
        TestDerbyConnector derbyConnector = this.derbyConnectorRule.getConnector();
        derbyConnector.createSegmentSchemasTable();
        derbyConnector.createSegmentTable();
        SegmentSchemaManager segmentSchemaManager = new SegmentSchemaManager((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), this.mapper, (SQLMetadataConnector)derbyConnector);
        SegmentSchemaTestUtils segmentSchemaTestUtils = new SegmentSchemaTestUtils(this.derbyConnectorRule, derbyConnector, this.mapper);
        SegmentSchemaCache segmentSchemaCache = new SegmentSchemaCache((ServiceEmitter)new NoopServiceEmitter());
        CentralizedDatasourceSchemaConfig config = CentralizedDatasourceSchemaConfig.create();
        config.setEnabled(true);
        config.setBackFillEnabled(true);
        config.setBackFillPeriod(1L);
        final CountDownLatch latch = new CountDownLatch(1);
        StubServiceEmitter emitter = new StubServiceEmitter("coordinator", "host");
        SegmentSchemaBackFillQueue segmentSchemaBackFillQueue = new SegmentSchemaBackFillQueue(segmentSchemaManager, ScheduledExecutors::fixed, segmentSchemaCache, new FingerprintGenerator(this.mapper), (ServiceEmitter)emitter, config){

            public void processBatchesDue() {
                super.processBatchesDue();
                latch.countDown();
            }
        };
        DataSegment segment1 = new DataSegment("foo", Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-01", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        DataSegment segment2 = new DataSegment("foo", Intervals.of((String)"2023-01-02/2023-01-03"), "2023-02-01", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        DataSegment segment3 = new DataSegment("foo1", Intervals.of((String)"2023-01-01/2023-01-02"), "2023-01-01", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        segments.add(segment1);
        segments.add(segment2);
        segments.add(segment3);
        segmentSchemaTestUtils.insertUsedSegments(segments, Collections.emptyMap());
        HashMap<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap = new HashMap<String, Pair<SchemaPayload, Integer>>();
        RowSignature rowSignature = RowSignature.builder().add("cx", ColumnType.FLOAT).build();
        HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
        segmentIdSchemaMap.put(segment1.getId().toString(), Pair.of((Object)new SchemaPayload(rowSignature, aggregatorFactoryMap), (Object)20));
        segmentIdSchemaMap.put(segment2.getId().toString(), Pair.of((Object)new SchemaPayload(rowSignature, aggregatorFactoryMap), (Object)20));
        segmentIdSchemaMap.put(segment3.getId().toString(), Pair.of((Object)new SchemaPayload(rowSignature, aggregatorFactoryMap), (Object)20));
        segmentSchemaBackFillQueue.add(segment1.getId(), rowSignature, aggregatorFactoryMap, 20L);
        segmentSchemaBackFillQueue.add(segment2.getId(), rowSignature, aggregatorFactoryMap, 20L);
        segmentSchemaBackFillQueue.add(segment3.getId(), rowSignature, aggregatorFactoryMap, 20L);
        segmentSchemaBackFillQueue.onLeaderStart();
        latch.await();
        segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
        emitter.verifyValue("metadatacache/backfill/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"foo"), (Number)2);
        emitter.verifyValue("metadatacache/backfill/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"foo1"), (Number)1);
    }

    private CentralizedDatasourceSchemaConfig getEnabledConfig() {
        CentralizedDatasourceSchemaConfig config = new CentralizedDatasourceSchemaConfig();
        config.setEnabled(true);
        return config;
    }

    static {
        NullHandling.initializeForTests();
    }
}

