/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.junit.Assert;
import org.junit.Test;

public class FingerprintGeneratorTest {
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();
    private final FingerprintGenerator fingerprintGenerator = new FingerprintGenerator(this.mapper);

    @Test
    public void testGenerateFingerprint_precalculatedHash() {
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).build();
        HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
        String expected = "DEE5E8F59833102F0FA5B10F8B8884EA15220D1D2A5F6097A93D8309132E1039";
        Assert.assertEquals((Object)expected, (Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds", 0));
    }

    @Test
    public void testGenerateFingerprint_columnPermutation() {
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).add("c2", ColumnType.LONG).add("c3", ColumnType.DOUBLE).build();
        HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
        RowSignature rowSignaturePermutation = RowSignature.builder().add("c2", ColumnType.LONG).add("c3", ColumnType.DOUBLE).add("c1", ColumnType.FLOAT).build();
        SchemaPayload schemaPayloadNew = new SchemaPayload(rowSignaturePermutation, aggregatorFactoryMap);
        Assert.assertNotEquals((Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds", 0), (Object)this.fingerprintGenerator.generateFingerprint(schemaPayloadNew, "ds", 0));
    }

    @Test
    public void testGenerateFingerprint_differentDatasources() {
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).add("c2", ColumnType.LONG).add("c3", ColumnType.DOUBLE).build();
        HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
        Assert.assertNotEquals((Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds1", 0), (Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds2", 0));
    }

    @Test
    public void testGenerateFingerprint_differentVersion() {
        RowSignature rowSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).add("c2", ColumnType.LONG).add("c3", ColumnType.DOUBLE).build();
        HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
        aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
        Assert.assertNotEquals((Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds", 0), (Object)this.fingerprintGenerator.generateFingerprint(schemaPayload, "ds", 1));
    }

    static {
        NullHandling.initializeForTests();
    }
}

