/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.multibindings.MapBinder;
import javax.annotation.Nullable;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.OmniDataSegmentArchiver;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OmniDataSegmentArchiverTest {
    @Test
    public void testArchiveSegmentWithType() throws SegmentLoadingException {
        DataSegmentArchiver archiver = (DataSegmentArchiver)Mockito.mock(DataSegmentArchiver.class);
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"sane"));
        Injector injector = OmniDataSegmentArchiverTest.createInjector(archiver);
        DataSegmentArchiver segmentArchiver = (DataSegmentArchiver)injector.getInstance(OmniDataSegmentArchiver.class);
        segmentArchiver.archive(segment);
        ((DataSegmentArchiver)Mockito.verify((Object)archiver, (VerificationMode)Mockito.times((int)1))).archive(segment);
    }

    @Test
    public void testArchiveSegmentUnknowType() {
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"unknown-type"));
        Injector injector = OmniDataSegmentArchiverTest.createInjector(null);
        OmniDataSegmentArchiver segmentArchiver = (OmniDataSegmentArchiver)injector.getInstance(OmniDataSegmentArchiver.class);
        Assert.assertThrows((String)"Unknown loader type[unknown-type]. Known types are [explode]", SegmentLoadingException.class, () -> segmentArchiver.archive(segment));
    }

    @Test
    public void testBadSegmentArchiverAccessException() {
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"bad"));
        Injector injector = OmniDataSegmentArchiverTest.createInjector(null);
        OmniDataSegmentArchiver segmentArchiver = (OmniDataSegmentArchiver)injector.getInstance(OmniDataSegmentArchiver.class);
        Assert.assertThrows((String)"BadSegmentArchiver must not have been initialized", RuntimeException.class, () -> segmentArchiver.archive(segment));
    }

    private static Injector createInjector(@Nullable DataSegmentArchiver archiver) {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> {
            MapBinder mapBinder = Binders.dataSegmentArchiverBinder((Binder)binder);
            if (archiver != null) {
                mapBinder.addBinding((Object)"sane").toInstance((Object)archiver);
            }
        }, binder -> {
            MapBinder mapBinder = Binders.dataSegmentArchiverBinder((Binder)binder);
            mapBinder.addBinding((Object)"bad").to(BadSegmentArchiver.class);
        }));
    }

    @LazySingleton
    private static class BadSegmentArchiver
    implements DataSegmentArchiver {
        @Inject
        BadSegmentArchiver() {
            throw new RuntimeException("BadSegmentArchiver must not have been initialized");
        }

        public DataSegment archive(DataSegment segment) {
            return null;
        }

        public DataSegment restore(DataSegment segment) {
            return null;
        }
    }
}

