/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.indexing.ReaderUtils;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ReaderUtilsTest
extends InitializedNullHandlingTest {
    private final Set<String> fullInputSchema = ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F", (Object[])new String[]{"G", "H", "I"});

    @Test
    public void testGetColumnsRequiredForIngestionWithoutMetricsWithoutTransformAndWithoutFlatten() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new LongDimensionSchema("C"), new FloatDimensionSchema("D")));
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D"), (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithoutTransformAndWithoutFlatten() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new LongDimensionSchema("C"), new FloatDimensionSchema("D")));
        AggregatorFactory[] aggregators = new AggregatorFactory[]{new CountAggregatorFactory("custom_count"), new LongSumAggregatorFactory("custom_long_sum", "E"), new FloatMinAggregatorFactory("custom_float_min", "F")};
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])aggregators, null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F", (Object[])new String[0]), (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithTransformAndWithoutFlatten() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new StringDimensionSchema("C*"), new LongDimensionSchema("D*"), new FloatDimensionSchema("E*"), new LongDimensionSchema("G")));
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("C*", "json_value(C, '$.dim2')", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("D*", "D", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("E*", "concat(E, F)", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("G", "CAST(G, LONG)", TestExprMacroTable.INSTANCE)));
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)transformSpec, (AggregatorFactory[])new AggregatorFactory[0], null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F", (Object[])new String[]{"G"}), (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithFlattenAndUseFieldDiscoveryFalse() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new StringDimensionSchema("C*"), new StringDimensionSchema("D*"), new StringDimensionSchema("E*"), new StringDimensionSchema("F*"), new StringDimensionSchema("H")));
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "B", "B"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "C*", "$.C"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "D*", "$.D.M[*].T"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(false), (List)flattenExpr);
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("E*", "E", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("F*", "concat(F, G)", TestExprMacroTable.INSTANCE)));
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)transformSpec, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D"), (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithFlattenAndUseFieldDiscoveryTrue() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new StringDimensionSchema("C*"), new StringDimensionSchema("D*"), new StringDimensionSchema("E*"), new StringDimensionSchema("F*"), new StringDimensionSchema("H")));
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "B", "B"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "C*", "$.C"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "D*", "$.D.M[*].T"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(true), (List)flattenExpr);
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("E*", "E", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("F*", "concat(F, G)", TestExprMacroTable.INSTANCE)));
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)transformSpec, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F", (Object[])new String[]{"G", "H"}), (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithFlattenDeepScan() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new StringDimensionSchema("C*"), new StringDimensionSchema("D*"), new StringDimensionSchema("E*"), new StringDimensionSchema("F*"), new StringDimensionSchema("H")));
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "B", "B"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "C*", "$.C"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "D*", "$..D"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(false), (List)flattenExpr);
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals(this.fullInputSchema, (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithFlattenWildcard() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new StringDimensionSchema("C*"), new StringDimensionSchema("D*"), new StringDimensionSchema("E*"), new StringDimensionSchema("F*"), new StringDimensionSchema("H")));
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "B", "B"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "C*", "$.C"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "D*", "$.*"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(false), (List)flattenExpr);
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals(this.fullInputSchema, (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithUnmatchedGroup() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new StringDimensionSchema("C*"), new StringDimensionSchema("D*"), new StringDimensionSchema("E*"), new StringDimensionSchema("F*"), new StringDimensionSchema("H")));
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "B", "B"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "C*", "$.C"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "D*", "$.[2:4].D"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(false), (List)flattenExpr);
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals(this.fullInputSchema, (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithUnsupportedJsonPathFieldType() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new StringDimensionSchema("C*"), new StringDimensionSchema("D*"), new StringDimensionSchema("E*"), new StringDimensionSchema("F*"), new StringDimensionSchema("H")));
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "B", "B"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "C*", "$.C"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "foobar", ".foo.bar"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(false), (List)flattenExpr);
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals(this.fullInputSchema, (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithFlattenTimestamp() {
        TimestampSpec timestampSpec = new TimestampSpec("CFlat", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("B")));
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "CFlat", "$.C.time"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(true), (List)flattenExpr);
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"B", (Object)"C"), (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForSchemalessIngestionWithoutFlattenSpec() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = DimensionsSpec.EMPTY;
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], null);
        Assert.assertEquals(this.fullInputSchema, (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForSchemalessIngestionWithFlattenSpecAndUseFieldDiscovery() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = DimensionsSpec.EMPTY;
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "CFlat", "$.C.time"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(true), (List)flattenExpr);
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals(this.fullInputSchema, (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForSchemalessIngestionWithFlattenSpecAndNotUseFieldDiscovery() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = DimensionsSpec.EMPTY;
        ImmutableList flattenExpr = ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "CFlat", "$.C.time"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(false), (List)flattenExpr);
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)TransformSpec.NONE, (AggregatorFactory[])new AggregatorFactory[0], (JSONPathSpec)flattenSpec);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"C"), (Object)actual);
    }

    @Test
    public void testGetColumnsRequiredForIngestionWithFilterInTransformSpec() {
        TimestampSpec timestampSpec = new TimestampSpec("A", "iso", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("B"), new StringDimensionSchema("C"), new LongDimensionSchema("D"), new FloatDimensionSchema("E"), new LongDimensionSchema("F")));
        TransformSpec transformSpec = new TransformSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("G", "foo", null), (Object)new SelectorDimFilter("H", "foobar", null))), (List)ImmutableList.of());
        Set actual = ReaderUtils.getColumnsRequiredForIngestion(this.fullInputSchema, (TimestampSpec)timestampSpec, (DimensionsSpec)dimensionsSpec, (TransformSpec)transformSpec, (AggregatorFactory[])new AggregatorFactory[0], null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F", (Object[])new String[]{"G", "H"}), (Object)actual);
    }
}

