/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.query.lookup.LookupIntrospectionResource;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.druid.server.WebserverTestUtils;
import org.easymock.EasyMock;
import org.glassfish.grizzly.http.server.HttpServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LookupIntrospectionResourceTest {
    private static LookupExtractorFactory mockLookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
    private static LookupExtractorFactoryContainerProvider mockLookupExtractorFactoryContainerProvider = (LookupExtractorFactoryContainerProvider)EasyMock.createMock(LookupExtractorFactoryContainerProvider.class);
    private static LookupIntrospectHandler mockLookupIntrospectHandler = (LookupIntrospectHandler)EasyMock.createMock(LookupIntrospectHandler.class);
    private LookupIntrospectionResource lookupIntrospectionResource = new LookupIntrospectionResource(mockLookupExtractorFactoryContainerProvider);
    private URI baseUri;
    private HttpServer server;

    @Before
    public void setup() throws Exception {
        MapLookupExtractorFactory actualLookupExtractorFactory = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value", (Object)"key2", (Object)"value2"), false);
        EasyMock.reset((Object[])new Object[]{mockLookupExtractorFactoryContainerProvider});
        EasyMock.reset((Object[])new Object[]{mockLookupExtractorFactory});
        EasyMock.reset((Object[])new Object[]{mockLookupIntrospectHandler});
        EasyMock.expect((Object)mockLookupExtractorFactoryContainerProvider.get("lookupId")).andReturn(Optional.of(new LookupExtractorFactoryContainer("v0", mockLookupExtractorFactory))).anyTimes();
        EasyMock.expect((Object)mockLookupExtractorFactoryContainerProvider.get("lookupId1")).andReturn(Optional.of(new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)actualLookupExtractorFactory))).anyTimes();
        EasyMock.expect((Object)mockLookupExtractorFactoryContainerProvider.get(EasyMock.anyString())).andReturn(Optional.empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLookupExtractorFactoryContainerProvider});
        this.baseUri = WebserverTestUtils.createBaseUri();
        this.server = WebserverTestUtils.createServer("lookup-test", this.baseUri, LookupIntrospectionResource.class.getName(), binder -> binder.bind(LookupExtractorFactoryContainerProvider.class).toInstance((Object)mockLookupExtractorFactoryContainerProvider));
        this.server.start();
    }

    @After
    public void teardown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testNotImplementedIntrospectLookup() {
        EasyMock.expect((Object)mockLookupExtractorFactory.getIntrospectHandler()).andReturn(null);
        EasyMock.expect((Object)((LookupExtractor)mockLookupExtractorFactory.get())).andReturn((Object)new MapLookupExtractor((Map)ImmutableMap.of(), false)).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLookupExtractorFactory});
        Assert.assertEquals((long)Response.status((Response.Status)Response.Status.NOT_FOUND).build().getStatus(), (long)((Response)this.lookupIntrospectionResource.introspectLookup("lookupId")).getStatus());
    }

    @Test
    public void testNotExistingLookup() {
        Assert.assertEquals((long)Response.status((Response.Status)Response.Status.NOT_FOUND).build().getStatus(), (long)((Response)this.lookupIntrospectionResource.introspectLookup("not there")).getStatus());
    }

    @Test
    public void testExistingLookup() {
        EasyMock.expect((Object)mockLookupExtractorFactory.getIntrospectHandler()).andReturn((Object)mockLookupIntrospectHandler);
        EasyMock.expect((Object)((LookupExtractor)mockLookupExtractorFactory.get())).andReturn((Object)new MapLookupExtractor((Map)ImmutableMap.of(), false)).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLookupExtractorFactory});
        Assert.assertEquals((Object)mockLookupIntrospectHandler, (Object)this.lookupIntrospectionResource.introspectLookup("lookupId"));
    }

    @Test
    public void testGetKey() {
        Client client = Client.create((ClientConfig)new DefaultClientConfig());
        WebResource service = client.resource(this.baseUri);
        ClientResponse resp = (ClientResponse)service.path("/druid/v1/lookups/introspect/lookupId1/keys").accept(new String[]{"application/json"}).get(ClientResponse.class);
        String s = (String)resp.getEntity(String.class);
        Assert.assertEquals((Object)"[key, key2]", (Object)s);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
    }

    @Test
    public void testGetValue() {
        Client client = Client.create((ClientConfig)new DefaultClientConfig());
        WebResource service = client.resource(this.baseUri);
        ClientResponse resp = (ClientResponse)service.path("/druid/v1/lookups/introspect/lookupId1/values").accept(new String[]{"application/json"}).get(ClientResponse.class);
        String s = (String)resp.getEntity(String.class);
        Assert.assertEquals((Object)"[value, value2]", (Object)s);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
    }

    @Test
    public void testGetMap() {
        Client client = Client.create((ClientConfig)new DefaultClientConfig());
        WebResource service = client.resource(this.baseUri);
        ClientResponse resp = (ClientResponse)service.path("/druid/v1/lookups/introspect/lookupId1/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        String s = (String)resp.getEntity(String.class);
        Assert.assertEquals((Object)"{\"key\":\"value\",\"key2\":\"value2\"}", (Object)s);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
    }
}

