/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.LookupEnabledTestExprMacroTable;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LookupExprMacroTest
extends InitializedNullHandlingTest {
    private static final Expr.ObjectBinding BINDINGS = InputBindings.forInputSuppliers((Map)ImmutableMap.builder().put((Object)"x", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "foo")).build());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testLookup() {
        this.assertExpr("lookup(x, 'lookyloo')", "xfoo");
    }

    @Test
    public void testLookupMissingValue() {
        this.assertExpr("lookup(y, 'lookyloo', 'N/A')", "N/A");
        this.assertExpr("lookup(y, 'lookyloo', null)", null);
    }

    @Test
    public void testLookupNotFound() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Lookup [lookylook] not found");
        this.assertExpr("lookup(x, 'lookylook')", null);
    }

    @Test
    public void testCacheKeyChangesWhenLookupChanges() {
        String expression = "lookup(x, 'lookyloo')";
        Expr expr = Parser.parse((String)"lookup(x, 'lookyloo')", (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE);
        Expr exprSameLookup = Parser.parse((String)"lookup(x, 'lookyloo')", (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE);
        Expr exprChangedLookup = Parser.parse((String)"lookup(x, 'lookyloo')", (ExprMacroTable)new ExprMacroTable(LookupEnabledTestExprMacroTable.makeTestMacros((Map<String, String>)ImmutableMap.of((Object)"x", (Object)"y", (Object)"a", (Object)"b"))));
        Assert.assertArrayEquals((byte[])expr.getCacheKey(), (byte[])exprSameLookup.getCacheKey());
        byte[] exprBytes = expr.getCacheKey();
        byte[] expr2Bytes = exprChangedLookup.getCacheKey();
        if (exprBytes.length == expr2Bytes.length) {
            boolean allEqual = true;
            for (int i = 0; i < exprBytes.length; ++i) {
                allEqual = allEqual && exprBytes[i] == expr2Bytes[i];
            }
            Assert.assertFalse((boolean)allEqual);
        }
    }

    @Test
    public void testCacheKeyChangesWhenLookupChangesSubExpr() {
        String expression = "concat(lookup(x, 'lookyloo'))";
        Expr expr = Parser.parse((String)"concat(lookup(x, 'lookyloo'))", (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE);
        Expr exprSameLookup = Parser.parse((String)"concat(lookup(x, 'lookyloo'))", (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE);
        Expr exprChangedLookup = Parser.parse((String)"concat(lookup(x, 'lookyloo'))", (ExprMacroTable)new ExprMacroTable(LookupEnabledTestExprMacroTable.makeTestMacros((Map<String, String>)ImmutableMap.of((Object)"x", (Object)"y", (Object)"a", (Object)"b"))));
        Assert.assertArrayEquals((byte[])expr.getCacheKey(), (byte[])exprSameLookup.getCacheKey());
        byte[] exprBytes = expr.getCacheKey();
        byte[] expr2Bytes = exprChangedLookup.getCacheKey();
        if (exprBytes.length == expr2Bytes.length) {
            boolean allEqual = true;
            for (int i = 0; i < exprBytes.length; ++i) {
                allEqual = allEqual && exprBytes[i] == expr2Bytes[i];
            }
            Assert.assertFalse((boolean)allEqual);
        }
    }

    private void assertExpr(String expression, Object expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE);
        Assert.assertEquals((String)expression, (Object)expectedResult, (Object)expr.eval(BINDINGS).value());
        Expr exprNotFlattened = Parser.parse((String)expression, (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE, (boolean)false);
        Expr roundTripNotFlattened = Parser.parse((String)exprNotFlattened.stringify(), (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE);
        Assert.assertEquals((String)exprNotFlattened.stringify(), (Object)expectedResult, (Object)roundTripNotFlattened.eval(BINDINGS).value());
        Expr roundTrip = Parser.parse((String)expr.stringify(), (ExprMacroTable)LookupEnabledTestExprMacroTable.INSTANCE);
        Assert.assertEquals((String)exprNotFlattened.stringify(), (Object)expectedResult, (Object)roundTrip.eval(BINDINGS).value());
    }
}

