/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.sql.SQLException;
import java.util.Locale;
import java.util.UUID;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.NoopMetadataStorageProvider;
import org.apache.druid.metadata.storage.derby.DerbyConnector;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.ExternalResource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public class TestDerbyConnector
extends DerbyConnector {
    private final String jdbcUri;

    public TestDerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        this(config, dbTables, "jdbc:derby:memory:druidTest" + TestDerbyConnector.dbSafeUUID(), centralizedDatasourceSchemaConfig);
    }

    public TestDerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables) {
        this(config, dbTables, "jdbc:derby:memory:druidTest" + TestDerbyConnector.dbSafeUUID(), CentralizedDatasourceSchemaConfig.create());
    }

    protected TestDerbyConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, String jdbcUri, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        super(new NoopMetadataStorageProvider().get(), config, dbTables, new DBI(jdbcUri + ";create=true"), centralizedDatasourceSchemaConfig);
        this.jdbcUri = jdbcUri;
    }

    public void tearDown() {
        try {
            new DBI(this.jdbcUri + ";drop=true").open().close();
        }
        catch (UnableToObtainConnectionException e) {
            SQLException cause = (SQLException)e.getCause();
            Assert.assertEquals((String)StringUtils.format((String)"Derby not shutdown: [%s]", (Object[])new Object[]{cause.toString()}), (Object)"08006", (Object)cause.getSQLState());
        }
    }

    public static String dbSafeUUID() {
        return StringUtils.removeChar((String)UUID.randomUUID().toString(), (char)'-');
    }

    public String getJdbcUri() {
        return this.jdbcUri;
    }

    public static class DerbyConnectorRule5
    extends DerbyConnectorRule
    implements BeforeAllCallback,
    AfterAllCallback {
        public void beforeAll(ExtensionContext context) {
            this.before();
        }

        public void afterAll(ExtensionContext context) {
            this.after();
        }
    }

    public static class SegmentsTable {
        private final DerbyConnectorRule rule;

        public SegmentsTable(DerbyConnectorRule rule) {
            this.rule = rule;
        }

        public int update(String sqlFormat, Object ... args) {
            return (Integer)this.rule.getConnector().retryWithHandle(handle -> handle.update(StringUtils.format((String)sqlFormat, (Object[])new Object[]{this.getTableName()}), args));
        }

        public int updateUsedStatusLastUpdated(String segmentId, DateTime lastUpdatedTime) {
            return this.update("UPDATE %1$s SET USED_STATUS_LAST_UPDATED = ? WHERE ID = ?", lastUpdatedTime.toString(), segmentId);
        }

        public String getTableName() {
            return ((MetadataStorageTablesConfig)this.rule.metadataTablesConfigSupplier().get()).getSegmentsTable().toUpperCase(Locale.ENGLISH);
        }
    }

    public static class DerbyConnectorRule
    extends ExternalResource {
        private TestDerbyConnector connector;
        private final Supplier<MetadataStorageTablesConfig> dbTables;
        private final MetadataStorageConnectorConfig connectorConfig;
        private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;

        public DerbyConnectorRule() {
            this("druidTest" + TestDerbyConnector.dbSafeUUID());
        }

        public DerbyConnectorRule(CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
            this((Supplier<MetadataStorageTablesConfig>)Suppliers.ofInstance((Object)MetadataStorageTablesConfig.fromBase((String)("druidTest" + TestDerbyConnector.dbSafeUUID()))), centralizedDatasourceSchemaConfig);
        }

        private DerbyConnectorRule(String defaultBase) {
            this((Supplier<MetadataStorageTablesConfig>)Suppliers.ofInstance((Object)MetadataStorageTablesConfig.fromBase((String)defaultBase)), CentralizedDatasourceSchemaConfig.create());
        }

        public DerbyConnectorRule(Supplier<MetadataStorageTablesConfig> dbTables, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
            this.dbTables = dbTables;
            this.connectorConfig = new MetadataStorageConnectorConfig(){

                public String getConnectURI() {
                    return connector.getJdbcUri();
                }
            };
            this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        }

        protected void before() {
            this.connector = new TestDerbyConnector((Supplier<MetadataStorageConnectorConfig>)Suppliers.ofInstance((Object)this.connectorConfig), this.dbTables, this.centralizedDatasourceSchemaConfig);
            this.connector.getDBI().open().close();
        }

        protected void after() {
            this.connector.tearDown();
        }

        public TestDerbyConnector getConnector() {
            return this.connector;
        }

        public MetadataStorageConnectorConfig getMetadataConnectorConfig() {
            return this.connectorConfig;
        }

        public Supplier<MetadataStorageTablesConfig> metadataTablesConfigSupplier() {
            return this.dbTables;
        }

        public SegmentsTable segments() {
            return new SegmentsTable(this);
        }
    }
}

