/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;

public class SqlSegmentsMetadataManagerTestBase {
    protected SqlSegmentsMetadataManager sqlSegmentsMetadataManager;
    protected SegmentSchemaCache segmentSchemaCache;
    protected SegmentSchemaManager segmentSchemaManager;
    protected TestDerbyConnector connector;
    protected SegmentsMetadataManagerConfig config;
    protected MetadataStorageTablesConfig storageConfig;
    protected final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    protected final DataSegment segment1 = SqlSegmentsMetadataManagerTestBase.createSegment("wikipedia", "2012-03-15T00:00:00.000/2012-03-16T00:00:00.000", "2012-03-16T00:36:30.848Z", "index/y=2012/m=03/d=15/2012-03-16T00:36:30.848Z/0/index.zip", 0);
    protected final DataSegment segment2 = SqlSegmentsMetadataManagerTestBase.createSegment("wikipedia", "2012-01-05T00:00:00.000/2012-01-06T00:00:00.000", "2012-01-06T22:19:12.565Z", "wikipedia/index/y=2012/m=01/d=05/2012-01-06T22:19:12.565Z/0/index.zip", 0);

    protected void publishSegment(DataSegment segment) throws IOException {
        SqlSegmentsMetadataManagerTestBase.publishSegment((SQLMetadataConnector)this.connector, this.storageConfig, this.jsonMapper, segment);
    }

    protected static DataSegment createSegment(String dataSource, String interval, String version, String bucketKey, int binaryVersion) {
        return new DataSegment(dataSource, Intervals.of((String)interval), version, (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)(dataSource + "/" + bucketKey)), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(binaryVersion), 1234L);
    }

    public static void publishSegment(SQLMetadataConnector connector, MetadataStorageTablesConfig config, ObjectMapper jsonMapper, DataSegment segment) throws IOException {
        String now = DateTimes.nowUtc().toString();
        SqlSegmentsMetadataManagerTestBase.publishSegment(connector, config, segment.getId().toString(), segment.getDataSource(), now, segment.getInterval().getStart().toString(), segment.getInterval().getEnd().toString(), !(segment.getShardSpec() instanceof NoneShardSpec), segment.getVersion(), true, jsonMapper.writeValueAsBytes((Object)segment), now);
    }

    private static void publishSegment(SQLMetadataConnector connector, MetadataStorageTablesConfig config, String segmentId, String dataSource, String createdDate, String start, String end, boolean partitioned, String version, boolean used, byte[] payload, String usedFlagLastUpdated) {
        try {
            DBI dbi = connector.getDBI();
            List exists = (List)dbi.withHandle(handle -> ((Query)handle.createQuery(StringUtils.format((String)"SELECT id FROM %s WHERE id=:id", (Object[])new Object[]{config.getSegmentsTable()})).bind("id", segmentId)).list());
            if (!exists.isEmpty()) {
                return;
            }
            String publishStatement = StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated)", (Object[])new Object[]{config.getSegmentsTable(), connector.getQuoteString()});
            dbi.withHandle(handle -> {
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(publishStatement).bind("id", segmentId)).bind("dataSource", dataSource)).bind("created_date", createdDate)).bind("start", start)).bind("end", end)).bind("partitioned", partitioned)).bind("version", version)).bind("used", used)).bind("payload", payload)).bind("used_status_last_updated", usedFlagLastUpdated)).execute();
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

