/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.SqlSegmentsMetadataManagerTestBase;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SqlSegmentsMetadataManagerTest
extends SqlSegmentsMetadataManagerTestBase {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final DataSegment wikiSegment1 = CreateDataSegments.ofDatasource("wiki").startingAt("2012-03-15").eachOfSizeInMb(500L).get(0);
    private final DataSegment wikiSegment2 = CreateDataSegments.ofDatasource("wiki").startingAt("2012-01-05").eachOfSizeInMb(500L).get(0);

    private static DataSegment createSegment(String dataSource, String interval, String version) {
        return new DataSegment(dataSource, Intervals.of((String)interval), version, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1234L);
    }

    private void publishUnusedSegments(DataSegment ... segments) throws IOException {
        for (DataSegment segment : segments) {
            this.publishSegment(segment);
            this.sqlSegmentsMetadataManager.markSegmentAsUnused(segment.getId());
        }
    }

    private void publishWikiSegments() {
        try {
            this.publishSegment(this.wikiSegment1);
            this.publishSegment(this.wikiSegment2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        SegmentsMetadataManagerConfig config = new SegmentsMetadataManagerConfig();
        config.setPollDuration(Period.seconds((int)3));
        this.storageConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.segmentSchemaCache = new SegmentSchemaCache((ServiceEmitter)NoopServiceEmitter.instance());
        this.segmentSchemaManager = new SegmentSchemaManager((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), this.jsonMapper, (SQLMetadataConnector)this.connector);
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.connector, this.segmentSchemaCache, CentralizedDatasourceSchemaConfig.create(), (ServiceEmitter)NoopServiceEmitter.instance());
        this.sqlSegmentsMetadataManager.start();
        this.connector.createSegmentSchemasTable();
        this.connector.createSegmentTable();
    }

    @After
    public void teardown() {
        if (this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically()) {
            this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        }
        this.sqlSegmentsMetadataManager.stop();
    }

    @Test
    public void testPollEmpty() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames().isEmpty());
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).count());
        Assert.assertNull((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("wiki"));
        Assert.assertTrue((boolean)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()).isEmpty());
    }

    @Test
    public void testPollPeriodically() {
        this.publishWikiSegments();
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay();
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wiki"), (Object)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames());
        Assert.assertEquals((Object)ImmutableList.of((Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Collection)dataSourcesSnapshot.getDataSource("wiki").getSegments()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()));
    }

    @Test
    public void testPollOnDemand() {
        this.publishWikiSegments();
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay());
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.forceOrWaitOngoingDatabasePoll();
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.OnDemandDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wiki"), (Object)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames());
        Assert.assertEquals((Object)ImmutableList.of((Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Collection)dataSourcesSnapshot.getDataSource("wiki").getSegments()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()));
    }

    @Test(timeout=60000L)
    public void testPollPeriodicallyAndOnDemandInterleave() throws Exception {
        this.publishWikiSegments();
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay();
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        this.publishSegment(SqlSegmentsMetadataManagerTest.createNewSegment1("koala"));
        this.sqlSegmentsMetadataManager.forceOrWaitOngoingDatabasePoll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.OnDemandDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"koala", (Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        String newDataSource3 = "wikipedia3";
        this.publishSegment(SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia3"));
        while (this.sqlSegmentsMetadataManager.getDataSourcesSnapshot().getDataSource("wikipedia3") == null) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"koala", (Object)"wikipedia3", (Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toSet()));
    }

    @Test
    public void testPrepareImmutableDataSourceWithUsedSegmentsAwaitsPollOnRestart() throws IOException {
        this.publishWikiSegments();
        DataSegment koalaSegment = this.pollThenStopThenPublishKoalaSegment();
        Assert.assertEquals((Object)ImmutableSet.of((Object)koalaSegment), (Object)ImmutableSet.copyOf((Collection)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("koala").getSegments()));
    }

    @Test
    public void testGetDataSourceWithUsedSegmentsAwaitsPollOnRestart() throws IOException {
        this.publishWikiSegments();
        DataSegment koalaSegment = this.pollThenStopThenPublishKoalaSegment();
        Assert.assertEquals((Object)ImmutableSet.of((Object)koalaSegment), (Object)ImmutableSet.copyOf((Collection)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("koala").getSegments()));
    }

    @Test
    public void testPrepareImmutableDataSourcesWithAllUsedSegmentsAwaitsPollOnRestart() throws IOException {
        this.publishWikiSegments();
        DataSegment koalaSegment = this.pollThenStopThenPublishKoalaSegment();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment), (Object)ImmutableSet.copyOf(this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator()));
    }

    @Test
    public void testIterateAllUsedSegmentsAwaitsPollOnRestart() throws IOException {
        this.publishWikiSegments();
        DataSegment koalaSegment = this.pollThenStopThenPublishKoalaSegment();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    private DataSegment pollThenStopThenPublishKoalaSegment() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wiki"), (Object)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames());
        DataSegment koalaSegment = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        this.publishSegment(koalaSegment);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        return koalaSegment;
    }

    @Test
    public void testPollWithCorruptedSegment() throws IOException {
        this.publishWikiSegments();
        DataSegment corruptSegment = DataSegment.builder((DataSegment)this.wikiSegment1).dataSource("corrupt-datasource").build();
        this.publishSegment(corruptSegment);
        this.updateSegmentPayload(corruptSegment, StringUtils.toUtf8((String)"corrupt-payload"));
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)"wiki", (Object)((ImmutableDruidDataSource)Iterables.getOnlyElement((Iterable)this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments())).getName());
    }

    @Test
    public void testGetUnusedSegmentIntervals() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        this.allowUsedFlagLastUpdatedToBeNullable();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        int numChangedSegments = this.sqlSegmentsMetadataManager.markAsUnusedAllSegmentsInDataSource("wiki");
        Assert.assertEquals((long)2L, (long)numChangedSegments);
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1);
        this.derbyConnectorRule.segments().updateUsedStatusLastUpdated(koalaSegment1.getId().toString(), DateTimes.nowUtc().minus((ReadableDuration)Duration.standardHours((long)2L)));
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-16T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment2);
        this.derbyConnectorRule.segments().updateUsedStatusLastUpdated(koalaSegment2.getId().toString(), DateTimes.nowUtc().minus((ReadableDuration)Duration.standardDays((long)2L)));
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment3);
        this.updateUsedStatusLastUpdatedToNull(koalaSegment3);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.wikiSegment2.getInterval()), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wiki", null, DateTimes.of((String)"3000"), 1, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.wikiSegment2.getInterval()), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wiki", null, DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), 1, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.wikiSegment1.getInterval()), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wiki", DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), DateTimes.of((int)2012, (int)4, (int)7, (int)0, (int)0), 1, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wiki", DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), 1, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.wikiSegment2.getInterval(), (Object)this.wikiSegment1.getInterval()), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wiki", null, DateTimes.of((String)"3000"), 5, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wiki", DateTimes.COMPARE_DATE_AS_STRING_MIN, DateTimes.of((String)"3000"), 5, DateTimes.nowUtc().minus((ReadableDuration)Duration.parse((String)"PT86400S"))));
        Assert.assertEquals((Object)ImmutableList.of((Object)koalaSegment2.getInterval()), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("koala", DateTimes.COMPARE_DATE_AS_STRING_MIN, DateTimes.of((String)"3000"), 5, DateTimes.nowUtc().minus((ReadableDuration)Duration.parse((String)"PT86400S"))));
    }

    @Test(timeout=60000L)
    public void testMarkAsUnusedAllSegmentsInDataSource() throws IOException, InterruptedException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        this.publishSegment(SqlSegmentsMetadataManagerTest.createNewSegment1("koala"));
        this.awaitDataSourceAppeared("koala");
        int numChangedSegments = this.sqlSegmentsMetadataManager.markAsUnusedAllSegmentsInDataSource("koala");
        Assert.assertEquals((long)1L, (long)numChangedSegments);
        this.awaitDataSourceDisappeared("koala");
        Assert.assertNull((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("koala"));
    }

    private static DataSegment createNewSegment1(String datasource) {
        return SqlSegmentsMetadataManagerTest.createSegment(datasource, "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z");
    }

    private static DataSegment createNewSegment2(String datasource) {
        return SqlSegmentsMetadataManagerTest.createSegment(datasource, "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
    }

    @Test(timeout=60000L)
    public void testMarkSegmentAsUnused() throws IOException, InterruptedException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishSegment(koalaSegment);
        this.awaitDataSourceAppeared("koala");
        Assert.assertNotNull((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("koala"));
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.markSegmentAsUnused(koalaSegment.getId()));
        this.awaitDataSourceDisappeared("koala");
        Assert.assertNull((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("koala"));
    }

    private void awaitDataSourceAppeared(String datasource) throws InterruptedException {
        while (this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments(datasource) == null) {
            Thread.sleep(5L);
        }
    }

    private void awaitDataSourceDisappeared(String dataSource) throws InterruptedException {
        while (this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments(dataSource) != null) {
            Thread.sleep(5L);
        }
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegments() throws Exception {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        ImmutableSet segmentIds = ImmutableSet.of((Object)koalaSegment1.getId().toString(), (Object)koalaSegment2.getId().toString(), (Object)koalaSegment3.getId().toString());
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegments("koala", (Set)segmentIds));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment1, (Object)koalaSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInEternityIntervalWithVersions() throws Exception {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("koala", Intervals.ETERNITY, (List)ImmutableList.of((Object)"2017-10-15T20:19:12.565Z", (Object)"2017-10-16T20:19:12.565Z")));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment1, (Object)koalaSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInIntervalWithEmptyVersions() throws Exception {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("koala", Intervals.of((String)"2017/2018"), (List)ImmutableList.of()));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInEternityIntervalWithEmptyVersions() throws Exception {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("koala", Intervals.ETERNITY, (List)ImmutableList.of()));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInFiniteIntervalWithVersions() throws Exception {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("koala", Intervals.of((String)"2017-10-15/2017-10-18"), (List)ImmutableList.of((Object)"2017-10-15T20:19:12.565Z", (Object)"2017-10-16T20:19:12.565Z")));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment1, (Object)koalaSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithNonExistentVersions() throws Exception {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("koala", Intervals.ETERNITY, (List)ImmutableList.of((Object)"foo", (Object)"bar")));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInvalidDataSource() throws Exception {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2);
        ImmutableSet segmentIds = ImmutableSet.of((Object)koalaSegment1.getId().toString(), (Object)koalaSegment2.getId().toString());
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        MatcherAssert.assertThat((Object)((DruidException)Assert.assertThrows(DruidException.class, () -> this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegments("wrongDataSource", (Set)segmentIds))), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Could not find segment IDs"));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsWithInvalidSegmentIds() {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        ImmutableSet segmentIds = ImmutableSet.of((Object)koalaSegment1.getId().toString(), (Object)koalaSegment2.getId().toString());
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        MatcherAssert.assertThat((Object)((DruidException)Assert.assertThrows(DruidException.class, () -> this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegments("koala", (Set)segmentIds))), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Could not find segment IDs"));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInInterval() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment4 = SqlSegmentsMetadataManagerTest.createNewSegment2("koala");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3, koalaSegment4);
        Interval theInterval = Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-18T00:00:00.000");
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("koala", theInterval, null));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment1, (Object)koalaSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInIntervalWithOverlappingInterval() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-22T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment4 = SqlSegmentsMetadataManagerTest.createNewSegment2("koala");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3, koalaSegment4);
        Interval theInterval = Intervals.of((String)"2017-10-16T00:00:00.000/2017-10-20T00:00:00.000");
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)1L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("koala", theInterval, null));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkSegmentsAsUnused() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        this.publishSegment(koalaSegment1);
        this.publishSegment(koalaSegment2);
        ImmutableSet segmentIds = ImmutableSet.of((Object)koalaSegment1.getId(), (Object)koalaSegment1.getId());
        Assert.assertEquals((long)segmentIds.size(), (long)this.sqlSegmentsMetadataManager.markSegmentsAsUnused((Set)segmentIds));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUnusedSegmentsInInterval() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment2("koala");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishSegment(koalaSegment1);
        this.publishSegment(koalaSegment2);
        this.publishSegment(koalaSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-18T00:00:00.000");
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("koala", theInterval, null));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalAndVersions() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DateTime now = DateTimes.nowUtc();
        String v1 = now.toString();
        String v2 = now.plus((ReadableDuration)Duration.standardDays((long)1L)).toString();
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", v1);
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", v2);
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", v2);
        this.publishSegment(koalaSegment1);
        this.publishSegment(koalaSegment2);
        this.publishSegment(koalaSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-15/2017-10-18");
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("koala", theInterval, (List)ImmutableList.of((Object)v1, (Object)v2)));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalAndNonExistentVersions() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DateTime now = DateTimes.nowUtc();
        String v1 = now.toString();
        String v2 = now.plus((ReadableDuration)Duration.standardDays((long)1L)).toString();
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", v1);
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", v2);
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", v2);
        this.publishSegment(koalaSegment1);
        this.publishSegment(koalaSegment2);
        this.publishSegment(koalaSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-15/2017-10-18");
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("koala", theInterval, (List)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz")));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment1, (Object)koalaSegment2, (Object)koalaSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalWithEmptyVersions() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DateTime now = DateTimes.nowUtc();
        String v1 = now.toString();
        String v2 = now.plus((ReadableDuration)Duration.standardDays((long)1L)).toString();
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", v1);
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", v2);
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", v2);
        this.publishSegment(koalaSegment1);
        this.publishSegment(koalaSegment2);
        this.publishSegment(koalaSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-15/2017-10-18");
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("koala", theInterval, (List)ImmutableList.of()));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment1, (Object)koalaSegment2, (Object)koalaSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUnusedSegmentsInEternityIntervalWithEmptyVersions() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DateTime now = DateTimes.nowUtc();
        String v1 = now.toString();
        String v2 = now.plus((ReadableDuration)Duration.standardDays((long)1L)).toString();
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", v1);
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", v2);
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", v2);
        this.publishSegment(koalaSegment1);
        this.publishSegment(koalaSegment2);
        this.publishSegment(koalaSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-15/2017-10-18");
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("koala", theInterval, (List)ImmutableList.of()));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment1, (Object)koalaSegment2, (Object)koalaSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalWithOverlappingInterval() throws IOException {
        this.publishWikiSegments();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment2("koala");
        DataSegment koalaSegment3 = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-22T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishSegment(koalaSegment1);
        this.publishSegment(koalaSegment2);
        this.publishSegment(koalaSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-16T00:00:00.000/2017-10-20T00:00:00.000");
        Assert.assertEquals((long)1L, (long)this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("koala", theInterval, null));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment1, (Object)koalaSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testStopAndStart() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
    }

    @Test
    public void testIterateAllUsedNonOvershadowedSegmentsForDatasourceInterval() throws Exception {
        this.publishWikiSegments();
        Interval theInterval = Intervals.of((String)"2012-03-15T00:00:00.000/2012-03-20T00:00:00.000");
        SegmentsMetadataManagerConfig config = new SegmentsMetadataManagerConfig();
        config.setPollDuration(Period.seconds((int)1));
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.derbyConnectorRule.getConnector(), this.segmentSchemaCache, CentralizedDatasourceSchemaConfig.create(), (ServiceEmitter)NoopServiceEmitter.instance());
        this.sqlSegmentsMetadataManager.start();
        Optional segments = this.sqlSegmentsMetadataManager.iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval("wiki", theInterval, true);
        Assert.assertTrue((boolean)segments.isPresent());
        ImmutableSet dataSegmentSet = ImmutableSet.copyOf((Iterable)((Iterable)segments.get()));
        Assert.assertEquals((long)1L, (long)dataSegmentSet.size());
        Assert.assertTrue((boolean)dataSegmentSet.contains(this.wikiSegment1));
        DataSegment wikiSegment3 = SqlSegmentsMetadataManagerTest.createSegment("wiki", "2012-03-16T00:00:00.000/2012-03-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishSegment(wikiSegment3);
        segments = this.sqlSegmentsMetadataManager.iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval("wiki", theInterval, false);
        Assert.assertTrue((boolean)segments.isPresent());
        dataSegmentSet = ImmutableSet.copyOf((Iterable)((Iterable)segments.get()));
        Assert.assertEquals((long)1L, (long)dataSegmentSet.size());
        Assert.assertTrue((boolean)dataSegmentSet.contains(this.wikiSegment1));
        segments = this.sqlSegmentsMetadataManager.iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval("wiki", theInterval, true);
        Assert.assertTrue((boolean)segments.isPresent());
        dataSegmentSet = ImmutableSet.copyOf((Iterable)((Iterable)segments.get()));
        Assert.assertEquals((long)2L, (long)dataSegmentSet.size());
        Assert.assertTrue((boolean)dataSegmentSet.contains(this.wikiSegment1));
        Assert.assertTrue((boolean)dataSegmentSet.contains(wikiSegment3));
    }

    @Test
    public void testPopulateUsedFlagLastUpdated() throws IOException {
        this.allowUsedFlagLastUpdatedToBeNullable();
        DataSegment koalaSegment = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment);
        this.updateUsedStatusLastUpdatedToNull(koalaSegment);
        Assert.assertEquals((long)1L, (long)this.getCountOfRowsWithLastUsedNull());
        this.sqlSegmentsMetadataManager.populateUsedFlagLastUpdated();
        Assert.assertEquals((long)0L, (long)this.getCountOfRowsWithLastUsedNull());
    }

    private int getCountOfRowsWithLastUsedNull() {
        return (Integer)this.derbyConnectorRule.getConnector().retryWithHandle(handle -> handle.select(StringUtils.format((String)"SELECT ID FROM %1$s WHERE USED_STATUS_LAST_UPDATED IS NULL", (Object[])new Object[]{this.derbyConnectorRule.segments().getTableName()}), new Object[0]).size());
    }

    private void updateSegmentPayload(DataSegment segment, byte[] payload) {
        this.derbyConnectorRule.segments().update("UPDATE %1$s SET PAYLOAD = ? WHERE ID = ?", payload, segment.getId().toString());
    }

    private void updateUsedStatusLastUpdatedToNull(DataSegment segment) {
        this.derbyConnectorRule.segments().update("UPDATE %1$s SET USED_STATUS_LAST_UPDATED = NULL WHERE ID = ?", segment.getId().toString());
    }

    private void allowUsedFlagLastUpdatedToBeNullable() {
        this.derbyConnectorRule.segments().update("ALTER TABLE %1$s ALTER COLUMN USED_STATUS_LAST_UPDATED NULL", new Object[0]);
    }
}

