/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import java.util.Locale;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.SqlSegmentsMetadataManagerProvider;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SqlSegmentsMetadataManagerProviderTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Test
    public void testLifecycleStartCreatesSegmentTables() throws Exception {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        SegmentsMetadataManagerConfig config = new SegmentsMetadataManagerConfig();
        Lifecycle lifecycle = new Lifecycle();
        SegmentSchemaCache segmentSchemaCache = new SegmentSchemaCache((ServiceEmitter)new NoopServiceEmitter());
        SqlSegmentsMetadataManagerProvider provider = new SqlSegmentsMetadataManagerProvider(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)connector, lifecycle, segmentSchemaCache, CentralizedDatasourceSchemaConfig.create(), (ServiceEmitter)NoopServiceEmitter.instance());
        SegmentsMetadataManager manager = provider.get();
        Assert.assertTrue((boolean)(manager instanceof SqlSegmentsMetadataManager));
        MetadataStorageTablesConfig storageConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        String segmentsTable = storageConfig.getSegmentsTable();
        String upgradeSegmentsTable = storageConfig.getUpgradeSegmentsTable();
        Assert.assertFalse((boolean)this.tableExists(segmentsTable, connector));
        Assert.assertFalse((boolean)this.tableExists(upgradeSegmentsTable, connector));
        lifecycle.start();
        Assert.assertTrue((boolean)this.tableExists(segmentsTable, connector));
        Assert.assertTrue((boolean)this.tableExists(upgradeSegmentsTable, connector));
        lifecycle.stop();
    }

    private boolean tableExists(String tableName, TestDerbyConnector connector) {
        return (Boolean)connector.retryWithHandle(handle -> connector.tableExists(handle, tableName.toUpperCase(Locale.ENGLISH)));
    }
}

