/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.jackson.StringObjectPairList;
import org.apache.druid.jackson.ToStringObjectPairListDeserializer;
import org.apache.druid.java.util.common.NonnullPair;
import org.junit.Assert;
import org.junit.Test;

public class ToStringObjectPairListDeserializerTest {
    private final ObjectMapper objectMapper = new DefaultObjectMapper();

    public ToStringObjectPairListDeserializerTest() {
        this.objectMapper.registerModule((Module)new SimpleModule().addDeserializer(StringObjectPairList.class, (JsonDeserializer)new ToStringObjectPairListDeserializer()));
    }

    @Test
    public void testDeserializeNestedMap() throws JsonProcessingException {
        ImmutableMap map = ImmutableMap.of((Object)"rootKey", (Object)"rootVal", (Object)"innerMap", (Object)ImmutableMap.of((Object)"innerKey", (Object)"innerVal"));
        String json = this.objectMapper.writeValueAsString((Object)map);
        StringObjectPairList pairList = (StringObjectPairList)this.objectMapper.readValue(json, StringObjectPairList.class);
        Assert.assertEquals((Object)new StringObjectPairList((List)ImmutableList.of((Object)new NonnullPair((Object)"rootKey", (Object)"rootVal"), (Object)new NonnullPair((Object)"innerMap", (Object)ImmutableMap.of((Object)"innerKey", (Object)"innerVal")))), (Object)pairList);
    }
}

