/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Properties;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.druid.guice.BrokerProcessingModule;
import org.apache.druid.guice.ConfigModule;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.LegacyBrokerParallelMergeConfigModule;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.log.EmittingRequestLogger;
import org.apache.druid.server.log.EmittingRequestLoggerProvider;
import org.apache.druid.server.log.NoopRequestLogger;
import org.apache.druid.server.log.NoopRequestLoggerProvider;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.RequestLoggerProvider;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.junit.Assert;
import org.junit.Test;

public class QueryableModuleTest {
    @Test
    public void testGetEmitterRequestLoggerProvider() {
        Properties properties = new Properties();
        properties.setProperty("druid.request.logging.type", "emitter");
        properties.setProperty("druid.request.logging.feed", "requestlog");
        Injector injector = this.makeInjector(properties);
        RequestLoggerProvider emittingRequestLoggerProvider = (RequestLoggerProvider)injector.getInstance(RequestLoggerProvider.class);
        Assert.assertTrue((boolean)(emittingRequestLoggerProvider instanceof EmittingRequestLoggerProvider));
        RequestLogger requestLogger = (RequestLogger)emittingRequestLoggerProvider.get();
        Assert.assertTrue((boolean)(requestLogger instanceof EmittingRequestLogger));
    }

    @Test
    public void testGetDefaultRequestLoggerProvider() {
        Properties properties = new Properties();
        Injector injector = this.makeInjector(properties);
        RequestLoggerProvider emittingRequestLoggerProvider = (RequestLoggerProvider)injector.getInstance(RequestLoggerProvider.class);
        Assert.assertTrue((boolean)(emittingRequestLoggerProvider instanceof NoopRequestLoggerProvider));
        RequestLogger requestLogger = (RequestLogger)emittingRequestLoggerProvider.get();
        Assert.assertTrue((boolean)(requestLogger instanceof NoopRequestLogger));
    }

    private Injector makeInjector(Properties properties) {
        Injector injector = Guice.createInjector((Iterable)ImmutableList.of((Object)new DruidGuiceExtensions(), (Object)new JacksonModule(), (Object)new ConfigModule(), (Object)new QueryRunnerFactoryModule(), (Object)new LegacyBrokerParallelMergeConfigModule(), (Object)new BrokerProcessingModule(), (Object)new LifecycleModule(), binder -> binder.bind(ServiceEmitter.class).to(NoopServiceEmitter.class), binder -> binder.bind(Properties.class).toInstance((Object)properties), (Object)new QueryableModule()));
        ObjectMapper mapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        mapper.registerModules((Iterable)new QueryableModule().getJacksonModules());
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ServiceEmitter.class, (Object)new NoopServiceEmitter()));
        return injector;
    }
}

