/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import java.util.Properties;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.druid.curator.CuratorConfig;
import org.apache.druid.curator.CuratorModule;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.testing.junit.LoggerCaptureRule;
import org.apache.logging.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.ExpectedSystemExit;

public final class CuratorModuleTest {
    private static final String CURATOR_CONNECTION_TIMEOUT_MS_KEY = "druid.zk.service.connectionTimeoutMs";
    @Rule
    public final ExpectedSystemExit exit = ExpectedSystemExit.none();
    @Rule
    public final LoggerCaptureRule logger = new LoggerCaptureRule(CuratorModule.class);

    @Test
    public void createsCuratorFrameworkAsConfigured() {
        CuratorConfig config = CuratorConfig.create((String)"myhost1:2888,myhost2:2888");
        CuratorFramework curatorFramework = CuratorModule.createCurator((CuratorConfig)config);
        CuratorZookeeperClient client = curatorFramework.getZookeeperClient();
        Assert.assertEquals((Object)config.getZkHosts(), (Object)client.getCurrentConnectionString());
        Assert.assertEquals((long)config.getZkConnectionTimeoutMs(), (long)client.getConnectionTimeoutMs());
        MatcherAssert.assertThat((Object)client.getRetryPolicy(), (Matcher)Matchers.instanceOf(BoundedExponentialBackoffRetry.class));
        BoundedExponentialBackoffRetry retryPolicy = (BoundedExponentialBackoffRetry)client.getRetryPolicy();
        Assert.assertEquals((long)1000L, (long)retryPolicy.getBaseSleepTimeMs());
        Assert.assertEquals((long)45000L, (long)retryPolicy.getMaxSleepTimeMs());
    }

    @Test(timeout=60000L)
    public void exitsJvmWhenMaxRetriesExceeded() throws Exception {
        Properties props = new Properties();
        props.setProperty(CURATOR_CONNECTION_TIMEOUT_MS_KEY, "0");
        Injector injector = this.newInjector(props);
        this.logger.clearLogEvents();
        this.exit.expectSystemExitWithStatus(1);
        CuratorFramework curatorFramework = CuratorModuleTest.createCuratorFramework(injector, 0);
        curatorFramework.start();
        ((ErrorListenerPathAndBytesable)curatorFramework.create().inBackground()).forPath("/foo");
        this.logger.awaitLogEvents();
        List loggingEvents = this.logger.getLogEvents();
        Assert.assertTrue((String)("Logging events: " + loggingEvents), (boolean)loggingEvents.stream().anyMatch(l -> l.getLevel().equals((Object)Level.ERROR) && l.getMessage().getFormattedMessage().equals("Unhandled error in Curator, stopping server.")));
    }

    @Ignore(value="Verifies changes in https://github.com/apache/druid/pull/8458, but overkill for regular testing")
    @Test
    public void ignoresDeprecatedCuratorConfigProperties() {
        Properties props = new Properties();
        String deprecatedPropName = "druid.zk.service.terminateDruidProcessOnConnectFail";
        props.setProperty(deprecatedPropName, "true");
        Injector injector = this.newInjector(props);
        try {
            injector.getInstance(CuratorFramework.class);
        }
        catch (Exception e) {
            Assert.fail((String)("Deprecated curator config was not ignored:\n" + e));
        }
    }

    private Injector newInjector(Properties props) {
        return ((StartupInjectorBuilder)new StartupInjectorBuilder().add(new Module[]{new LifecycleModule(), new CuratorModule(false), binder -> binder.bind(ServiceEmitter.class).to(NoopServiceEmitter.class), binder -> binder.bind(Properties.class).toInstance((Object)props)})).build();
    }

    private static CuratorFramework createCuratorFramework(Injector injector, int maxRetries) {
        CuratorFramework curatorFramework = (CuratorFramework)injector.getInstance(CuratorFramework.class);
        RetryPolicy retryPolicy = curatorFramework.getZookeeperClient().getRetryPolicy();
        Assert.assertThat((Object)retryPolicy, (Matcher)CoreMatchers.instanceOf(ExponentialBackoffRetry.class));
        RetryPolicy adjustedRetryPolicy = CuratorModuleTest.adjustRetryPolicy((BoundedExponentialBackoffRetry)retryPolicy, maxRetries);
        curatorFramework.getZookeeperClient().setRetryPolicy(adjustedRetryPolicy);
        return curatorFramework;
    }

    private static RetryPolicy adjustRetryPolicy(BoundedExponentialBackoffRetry origRetryPolicy, int maxRetries) {
        return new BoundedExponentialBackoffRetry(origRetryPolicy.getBaseSleepTimeMs(), origRetryPolicy.getMaxSleepTimeMs(), maxRetries);
    }
}

