/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.client.cache.BytesBoundedLinkedQueue;
import org.apache.druid.java.util.common.ISE;
import org.junit.Assert;
import org.junit.Test;

public class BytesBoundedLinkedQueueTest {
    private static int delayMS = 50;
    private ExecutorService exec = Executors.newCachedThreadPool();

    private static BlockingQueue<TestObject> getQueue(int capacity) {
        return new BytesBoundedLinkedQueue<TestObject>((long)capacity){

            public long getBytesSize(TestObject o) {
                return o.getSize();
            }
        };
    }

    @Test
    public void testPoll() throws InterruptedException {
        BlockingQueue<TestObject> q = BytesBoundedLinkedQueueTest.getQueue(10);
        long startTime = System.nanoTime();
        Assert.assertNull((Object)q.poll(delayMS, TimeUnit.MILLISECONDS));
        Assert.assertTrue((TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) >= (long)delayMS ? 1 : 0) != 0);
        TestObject obj = new TestObject(2);
        Assert.assertTrue((boolean)q.offer(obj, delayMS, TimeUnit.MILLISECONDS));
        Assert.assertSame((Object)obj, (Object)q.poll(delayMS, TimeUnit.MILLISECONDS));
        Thread.currentThread().interrupt();
        try {
            q.poll(delayMS, TimeUnit.MILLISECONDS);
            throw new ISE("FAIL", new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            Assert.assertFalse((boolean)Thread.interrupted());
            return;
        }
    }

    @Test
    public void testTake() throws Exception {
        final BlockingQueue<TestObject> q = BytesBoundedLinkedQueueTest.getQueue(10);
        Thread.currentThread().interrupt();
        try {
            q.take();
            Assert.fail();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        final CountDownLatch latch = new CountDownLatch(1);
        TestObject object = new TestObject(4);
        Future<TestObject> future = this.exec.submit(new Callable<TestObject>(){

            @Override
            public TestObject call() throws Exception {
                latch.countDown();
                return (TestObject)q.take();
            }
        });
        latch.await();
        try {
            future.get(delayMS, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        q.offer(object);
        Assert.assertEquals((Object)object, (Object)future.get());
    }

    @Test
    public void testOfferAndPut() throws Exception {
        final BlockingQueue<TestObject> q = BytesBoundedLinkedQueueTest.getQueue(10);
        try {
            q.offer(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        final TestObject obj = new TestObject(2);
        while (q.remainingCapacity() > 0) {
            Assert.assertTrue((boolean)q.offer(obj, delayMS, TimeUnit.MILLISECONDS));
        }
        Assert.assertEquals((long)0L, (long)q.remainingCapacity());
        Assert.assertFalse((boolean)q.offer(obj, delayMS, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)q.offer(obj));
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Future<Boolean> future = this.exec.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                barrier.await();
                Assert.assertTrue((boolean)q.offer(obj, delayMS, TimeUnit.MILLISECONDS));
                Assert.assertEquals((long)q.remainingCapacity(), (long)0L);
                barrier.await();
                q.put(obj);
                return true;
            }
        });
        barrier.await();
        q.take();
        barrier.await();
        q.take();
        Assert.assertTrue((boolean)future.get());
    }

    @Test
    public void testAddBiggerElementThanCapacityFails() {
        BlockingQueue<TestObject> q = BytesBoundedLinkedQueueTest.getQueue(5);
        try {
            q.offer(new TestObject(10));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddedObjectExceedsCapacity() throws Exception {
        BlockingQueue<TestObject> q = BytesBoundedLinkedQueueTest.getQueue(4);
        Assert.assertTrue((boolean)q.offer(new TestObject(3)));
        Assert.assertFalse((boolean)q.offer(new TestObject(2)));
        Assert.assertFalse((boolean)q.offer(new TestObject(2), delayMS, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testConcurrentOperations() throws Exception {
        int i;
        final BlockingQueue<TestObject> q = BytesBoundedLinkedQueueTest.getQueue(Integer.MAX_VALUE);
        long duration = TimeUnit.SECONDS.toMillis(10L);
        ExecutorService executor = Executors.newCachedThreadPool();
        final AtomicBoolean stopTest = new AtomicBoolean(false);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (i = 0; i < 5; ++i) {
            futures.add(executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    while (!stopTest.get()) {
                        q.add(new TestObject(1));
                        q.add(new TestObject(2));
                    }
                    return true;
                }
            }));
        }
        for (i = 0; i < 10; ++i) {
            futures.add(executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws InterruptedException {
                    while (!stopTest.get()) {
                        q.poll(100L, TimeUnit.MILLISECONDS);
                        q.offer(new TestObject(2));
                    }
                    return true;
                }
            }));
        }
        for (i = 0; i < 5; ++i) {
            futures.add(executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    while (!stopTest.get()) {
                        q.drainTo(new ArrayList(), Integer.MAX_VALUE);
                    }
                    return true;
                }
            }));
        }
        Thread.sleep(duration);
        stopTest.set(true);
        for (Future future : futures) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
    }

    public static class TestObject {
        public final int size;

        TestObject(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

