/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.SimpleQueryRunner;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.Duration;

public class TestHttpClient
implements HttpClient {
    private static final HttpResponseHandler.TrafficCop NOOP_TRAFFIC_COP = checkNum -> 0L;
    private static final int RESPONSE_CTX_HEADER_LEN_LIMIT = 7168;
    private final Map<URL, SimpleServerManager> servers = new HashMap<URL, SimpleServerManager>();
    private final ObjectMapper objectMapper;

    public TestHttpClient(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void addServerAndRunner(DruidServer server, SimpleServerManager serverManager) {
        this.servers.put(TestHttpClient.computeUrl(server), serverManager);
    }

    @Nullable
    public SimpleServerManager getServerManager(DruidServer server) {
        return this.servers.get(TestHttpClient.computeUrl(server));
    }

    public Map<URL, SimpleServerManager> getServers() {
        return this.servers;
    }

    private static URL computeUrl(DruidServer server) {
        try {
            return new URL(StringUtils.format((String)"%s://%s/druid/v2/", (Object[])new Object[]{server.getScheme(), server.getHost()}));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler) {
        throw new UnsupportedOperationException();
    }

    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler, Duration readTimeout) {
        try {
            byte[] serializedContent;
            Query query = (Query)this.objectMapper.readValue(request.getContent().array(), Query.class);
            QueryRunner queryRunner = this.servers.get(request.getUrl()).getQueryRunner();
            if (queryRunner == null) {
                throw new ISE("Can't find queryRunner for url[%s]", new Object[]{request.getUrl()});
            }
            ResponseContext responseContext = ResponseContext.createEmpty();
            Sequence sequence = queryRunner.run(QueryPlus.wrap((Query)query), responseContext);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                this.objectMapper.writeValue((OutputStream)baos, (Object)sequence);
                serializedContent = baos.toByteArray();
            }
            ResponseContext.SerializationResult serializationResult = responseContext.serializeWith(this.objectMapper, 7168);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().add("X-Druid-Response-Context", (Object)serializationResult.getResult());
            response.setContent(HeapChannelBufferFactory.getInstance().getBuffer(serializedContent, 0, serializedContent.length));
            ClientResponse intermClientResponse = handler.handleResponse((HttpResponse)response, NOOP_TRAFFIC_COP);
            ClientResponse finalClientResponse = handler.done(intermClientResponse);
            return Futures.immediateFuture((Object)finalClientResponse.getObj());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SimpleServerManager {
        private final QueryRunnerFactoryConglomerate conglomerate;
        private final DataSegment segment;
        private final QueryableIndex queryableIndex;
        private final boolean throwQueryError;
        private boolean isSegmentDropped = false;

        public SimpleServerManager(QueryRunnerFactoryConglomerate conglomerate, DataSegment segment, QueryableIndex queryableIndex, boolean throwQueryError) {
            this.conglomerate = conglomerate;
            this.segment = segment;
            this.queryableIndex = queryableIndex;
            this.throwQueryError = throwQueryError;
        }

        private QueryRunner getQueryRunner() {
            if (this.throwQueryError) {
                return (queryPlus, responseContext) -> {
                    throw new RuntimeException("Exception for testing");
                };
            }
            if (this.isSegmentDropped) {
                return new ReportTimelineMissingSegmentQueryRunner(new SegmentDescriptor(this.segment.getInterval(), this.segment.getVersion(), this.segment.getId().getPartitionNum()));
            }
            return new SimpleQueryRunner(this.conglomerate, this.segment.getId(), this.queryableIndex);
        }

        public NonnullPair<DataSegment, QueryableIndex> dropSegment() {
            this.isSegmentDropped = true;
            return new NonnullPair((Object)this.segment, (Object)this.queryableIndex);
        }
    }
}

