/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.test.utils.ImmutableDruidDataSourceTestUtils;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ImmutableDruidDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        DataSegment segment = this.getTestSegment();
        ImmutableDruidDataSource dataSource = this.getImmutableDruidDataSource(segment);
        ObjectMapper objectMapper = new DefaultObjectMapper().setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));
        String json = objectMapper.writeValueAsString((Object)dataSource);
        ImmutableDruidDataSourceTestUtils.assertEquals(dataSource, (ImmutableDruidDataSource)objectMapper.readValue(json, ImmutableDruidDataSource.class));
    }

    @Test
    public void testEqualsMethodThrowsUnsupportedOperationException() {
        DataSegment segment1 = this.getTestSegment();
        ImmutableDruidDataSource dataSource1 = this.getImmutableDruidDataSource(segment1);
        DataSegment segment2 = this.getTestSegment();
        ImmutableDruidDataSource dataSource2 = this.getImmutableDruidDataSource(segment2);
        Assert.assertThrows((String)"ImmutableDruidDataSource shouldn't be used as the key in containers", UnsupportedOperationException.class, () -> dataSource1.equals((Object)dataSource2));
    }

    private ImmutableDruidDataSource getImmutableDruidDataSource(DataSegment segment1) {
        return new ImmutableDruidDataSource("test", (Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2"), (Map)ImmutableSortedMap.of((Comparable)segment1.getId(), (Object)segment1));
    }

    private DataSegment getTestSegment() {
        return new DataSegment("test", Intervals.of((String)"2017/2018"), "version", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, null, Integer.valueOf(1), 100L, DataSegment.PruneSpecsHolder.DEFAULT);
    }

    @Test
    public void testHashCodeMethodThrowsUnsupportedOperationException() {
        DataSegment segment = this.getTestSegment();
        ImmutableDruidDataSource dataSource = this.getImmutableDruidDataSource(segment);
        Assert.assertThrows((String)"ImmutableDruidDataSource shouldn't be used as the key in containers", UnsupportedOperationException.class, () -> ((ImmutableDruidDataSource)dataSource).hashCode());
    }
}

