/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.apache.druid.client.DruidServerConfig;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DruidServerConfigTest {
    private File testSegmentCacheDir1;
    private File testSegmentCacheDir2;
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();
    public ObjectMapper mapper = new DefaultObjectMapper();
    private static final Module SERVER_CONFIG_MODULE = binder -> {
        binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test");
        binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
        binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
    };

    @Before
    public void setUp() throws Exception {
        this.testSegmentCacheDir1 = this.tmpFolder.newFolder("segment_cache_folder1");
        this.testSegmentCacheDir2 = this.tmpFolder.newFolder("segment_cache_folder2");
    }

    @Test
    public void testBasicInjection() {
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)SERVER_CONFIG_MODULE));
        DruidServerConfig druidServerConfig = (DruidServerConfig)injector.getInstance(DruidServerConfig.class);
        Assert.assertNotNull((Object)druidServerConfig);
        Assert.assertEquals(DruidServerConfig.class, druidServerConfig.getClass());
    }

    @Test
    public void testCombinedSize() {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig1 = new StorageLocationConfig(this.testSegmentCacheDir1, 10000000000L, null);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(this.testSegmentCacheDir2, 20000000000L, null);
        locations.add(locationConfig1);
        locations.add(locationConfig2);
        DruidServerConfig druidServerConfig = new DruidServerConfig(new SegmentLoaderConfig().withLocations(locations));
        Assert.assertEquals((long)30000000000L, (long)druidServerConfig.getMaxSize());
    }

    @Test
    public void testServerMaxSizePrecedence() throws Exception {
        String serverConfigWithDefaultSizeStr = "{\"maxSize\":0,\"tier\":\"_default_tier\",\"priority\":0,\"hiddenProperties\":[\"druid.metadata.storage.connector.password\",\"druid.s3.accessKey\",\"druid.s3.secretKey\"]}\n";
        String serverConfigWithNonDefaultSizeStr = "{\"maxSize\":123456,\"tier\":\"_default_tier\",\"priority\":0,\"hiddenProperties\":[\"druid.metadata.storage.connector.password\",\"druid.s3.accessKey\",\"druid.s3.secretKey\"]}\n";
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig1 = new StorageLocationConfig(this.testSegmentCacheDir1, 10000000000L, null);
        locations.add(locationConfig1);
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)new DefaultObjectMapper()).addValue(SegmentLoaderConfig.class, (Object)new SegmentLoaderConfig().withLocations(locations)));
        DruidServerConfig serverConfigWithDefaultSize = (DruidServerConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(serverConfigWithDefaultSizeStr, DruidServerConfig.class)), DruidServerConfig.class);
        DruidServerConfig serverConfigWithNonDefaultSize = (DruidServerConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(serverConfigWithNonDefaultSizeStr, DruidServerConfig.class)), DruidServerConfig.class);
        Assert.assertEquals((long)serverConfigWithDefaultSize.getMaxSize(), (long)10000000000L);
        Assert.assertEquals((long)serverConfigWithNonDefaultSize.getMaxSize(), (long)123456L);
    }
}

