/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.MapQueryToolChestWarehouse;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.TestGroupByBuffers;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryConfig;
import org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;

public final class CachingClusteredClientTestUtils {
    public static Pair<QueryToolChestWarehouse, Closer> createWarehouse() {
        Closer resourceCloser = Closer.create();
        GroupByQueryRunnerFactory groupByQueryRunnerFactory = GroupByQueryRunnerTest.makeQueryRunnerFactory((GroupByQueryConfig)new GroupByQueryConfig(), (TestGroupByBuffers)((TestGroupByBuffers)resourceCloser.register((Closeable)TestGroupByBuffers.createDefault())));
        return Pair.of((Object)new MapQueryToolChestWarehouse((Map)ImmutableMap.builder().put(TimeseriesQuery.class, (Object)new TimeseriesQueryQueryToolChest()).put(TopNQuery.class, (Object)new TopNQueryQueryToolChest(new TopNQueryConfig())).put(SearchQuery.class, (Object)new SearchQueryQueryToolChest(new SearchQueryConfig())).put(GroupByQuery.class, (Object)groupByQueryRunnerFactory.getToolchest()).put(TimeBoundaryQuery.class, (Object)new TimeBoundaryQueryQueryToolChest()).build()), (Object)resourceCloser);
    }

    public static ObjectMapper createObjectMapper() {
        SmileFactory factory = new SmileFactory();
        DefaultObjectMapper objectMapper = new DefaultObjectMapper((JsonFactory)factory, "broker");
        factory.setCodec((ObjectCodec)objectMapper);
        return objectMapper;
    }

    private CachingClusteredClientTestUtils() {
    }
}

