/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.CachingClusteredClientTestUtils;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.RangeIterable;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.cache.BackgroundCachePopulator;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.MergeIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.nary.TrinaryFn;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BrokerParallelMergeConfig;
import org.apache.druid.query.BySegmentResultValueClass;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.FluentQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryConfig;
import org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.apache.druid.timeline.partition.SingleElementPartitionChunk;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CachingClusteredClientTest {
    private static final ImmutableMap<String, Object> CONTEXT = ImmutableMap.of((Object)"finalize", (Object)false);
    private static final MultipleIntervalSegmentSpec SEG_SPEC = new MultipleIntervalSegmentSpec((List)ImmutableList.of());
    private static final String DATA_SOURCE = "test";
    private static final ObjectMapper JSON_MAPPER = CachingClusteredClientTestUtils.createObjectMapper();
    private static final int RANDOMNESS = 10;
    private static final List<AggregatorFactory> AGGS = Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("imps", "imps"), new LongSumAggregatorFactory("impers", "imps"));
    private static final List<PostAggregator> POST_AGGS = Arrays.asList(new ArithmeticPostAggregator("avg_imps_per_row", "/", Arrays.asList(new FieldAccessPostAggregator("imps", "imps"), new FieldAccessPostAggregator("rows", "rows"))), new ArithmeticPostAggregator("avg_imps_per_row_double", "*", Arrays.asList(new FieldAccessPostAggregator("avg_imps_per_row", "avg_imps_per_row"), new ConstantPostAggregator("constant", (Number)2))), new ArithmeticPostAggregator("avg_imps_per_row_half", "/", Arrays.asList(new FieldAccessPostAggregator("avg_imps_per_row", "avg_imps_per_row"), new ConstantPostAggregator("constant", (Number)2))));
    private static final List<AggregatorFactory> RENAMED_AGGS = Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("imps", "imps"), new LongSumAggregatorFactory("impers2", "imps"));
    private static final List<PostAggregator> DIFF_ORDER_POST_AGGS = Arrays.asList(new ArithmeticPostAggregator("avg_imps_per_row", "/", Arrays.asList(new FieldAccessPostAggregator("imps", "imps"), new FieldAccessPostAggregator("rows", "rows"))), new ArithmeticPostAggregator("avg_imps_per_row_half", "/", Arrays.asList(new FieldAccessPostAggregator("avg_imps_per_row", "avg_imps_per_row"), new ConstantPostAggregator("constant", (Number)2))), new ArithmeticPostAggregator("avg_imps_per_row_double", "*", Arrays.asList(new FieldAccessPostAggregator("avg_imps_per_row", "avg_imps_per_row"), new ConstantPostAggregator("constant", (Number)2))));
    private static final DimFilter DIM_FILTER = null;
    private static final List<PostAggregator> RENAMED_POST_AGGS = ImmutableList.of();
    private static final Granularity GRANULARITY = Granularities.DAY;
    private static final DateTimeZone TIMEZONE = DateTimes.inferTzFromString((String)"America/Los_Angeles");
    private static final Granularity PT1H_TZ_GRANULARITY = new PeriodGranularity(new Period((Object)"PT1H"), null, TIMEZONE);
    private static final String TOP_DIM = "a_dim";
    private static final Pair<QueryToolChestWarehouse, Closer> WAREHOUSE_AND_CLOSER = CachingClusteredClientTestUtils.createWarehouse();
    private static final QueryToolChestWarehouse WAREHOUSE = (QueryToolChestWarehouse)CachingClusteredClientTest.WAREHOUSE_AND_CLOSER.lhs;
    private static final Closer RESOURCE_CLOSER = (Closer)CachingClusteredClientTest.WAREHOUSE_AND_CLOSER.rhs;
    private final Random random;
    private CachingClusteredClient client;
    private Runnable queryCompletedCallback;
    private TimelineServerView serverView;
    private VersionedIntervalTimeline<String, ServerSelector> timeline;
    private Cache cache;
    private DruidServer[] servers;

    public CachingClusteredClientTest(int randomSeed) {
        this.random = new Random(randomSeed);
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        return Lists.transform((List)Lists.newArrayList((Iterable)new RangeIterable(10)), (Function)new Function<Integer, Object[]>(){

            public Object[] apply(Integer input) {
                return new Object[]{input};
            }
        });
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        RESOURCE_CLOSER.close();
    }

    @Before
    public void setUp() {
        this.timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        this.serverView = (TimelineServerView)EasyMock.createNiceMock(TimelineServerView.class);
        this.cache = MapCache.create((long)100000L);
        this.client = this.makeClient((CachePopulator)new ForegroundCachePopulator(JSON_MAPPER, new CachePopulatorStats(), -1L));
        this.servers = new DruidServer[]{new DruidServer("test1", "test1", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test2", "test2", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test3", "test3", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test4", "test4", null, 10L, ServerType.HISTORICAL, "bye", 0), new DruidServer("test5", "test5", null, 10L, ServerType.HISTORICAL, "bye", 0)};
    }

    @Test
    public void testOutOfOrderBackgroundCachePopulation() {
        final ForwardingListeningExecutorService randomizingExecutorService = new ForwardingListeningExecutorService(){
            final ConcurrentLinkedDeque<Pair<SettableFuture, Object>> taskQueue = new ConcurrentLinkedDeque();
            final ListeningExecutorService delegate = MoreExecutors.listeningDecorator((ExecutorService)Execs.directExecutor());

            protected ListeningExecutorService delegate() {
                return this.delegate;
            }

            private <T> ListenableFuture<T> maybeSubmitTask(Object task, boolean wait) {
                if (wait) {
                    SettableFuture future = SettableFuture.create();
                    this.taskQueue.addFirst((Pair<SettableFuture, Object>)Pair.of((Object)future, (Object)task));
                    return future;
                }
                ArrayList tasks = Lists.newArrayList(this.taskQueue.iterator());
                Collections.shuffle(tasks, new Random(0L));
                for (final Pair pair : tasks) {
                    ListenableFuture future = pair.rhs instanceof Callable ? this.delegate.submit((Callable)pair.rhs) : this.delegate.submit((Runnable)pair.rhs);
                    Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback(){

                        public void onSuccess(@Nullable Object result) {
                            ((SettableFuture)pair.lhs).set(result);
                        }

                        public void onFailure(Throwable t) {
                            ((SettableFuture)pair.lhs).setException(t);
                        }
                    }, (Executor)MoreExecutors.directExecutor());
                }
                return task instanceof Callable ? this.delegate.submit((Callable)task) : this.delegate.submit((Runnable)task);
            }

            public <T> ListenableFuture<T> submit(Callable<T> task) {
                return this.maybeSubmitTask(task, true);
            }

            public ListenableFuture<?> submit(Runnable task) {
                abstract class DrainTask
                implements Runnable {
                    DrainTask() {
                    }
                }
                if (task instanceof DrainTask) {
                    return this.maybeSubmitTask(task, false);
                }
                return this.maybeSubmitTask(task, true);
            }
        };
        this.client = this.makeClient((CachePopulator)new BackgroundCachePopulator((ExecutorService)randomizingExecutorService, JSON_MAPPER, new CachePopulatorStats(), -1L));
        this.queryCompletedCallback = new Runnable(){

            @Override
            public void run() {
                try {
                    randomizingExecutorService.submit((Runnable)new DrainTask(){
                        {
                        }

                        @Override
                        public void run() {
                        }
                    }).get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT).randomQueryId();
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        this.testQueryCaching((QueryRunner)runner, (Query)builder.build(), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05"), 85, 102, DateTimes.of((String)"2011-01-06"), 412, 521, DateTimes.of((String)"2011-01-07"), 122, 21894, DateTimes.of((String)"2011-01-08"), 5, 20, DateTimes.of((String)"2011-01-09"), 18, 521), Intervals.of((String)"2011-01-10/2011-01-13"), this.makeTimeResults(DateTimes.of((String)"2011-01-10"), 85, 102, DateTimes.of((String)"2011-01-11"), 412, 521, DateTimes.of((String)"2011-01-12"), 122, 21894));
    }

    @Test
    public void testTimeseriesCaching() {
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        this.testQueryCaching((QueryRunner)runner, (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeTimeResults(DateTimes.of((String)"2011-01-02"), 30, 6000), Intervals.of((String)"2011-01-04/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-04"), 23, 85312), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05"), 85, 102, DateTimes.of((String)"2011-01-06"), 412, 521, DateTimes.of((String)"2011-01-07"), 122, 21894, DateTimes.of((String)"2011-01-08"), 5, 20, DateTimes.of((String)"2011-01-09"), 18, 521), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05T01"), 80, 100, DateTimes.of((String)"2011-01-06T01"), 420, 520, DateTimes.of((String)"2011-01-07T01"), 12, 2194, DateTimes.of((String)"2011-01-08T01"), 59, 201, DateTimes.of((String)"2011-01-09T01"), 181, 52));
        TimeseriesQuery query = builder.intervals("2011-01-01/2011-01-10").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS).randomQueryId().build();
        TestHelper.assertExpectedResults(this.makeRenamedTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000, DateTimes.of((String)"2011-01-02"), 30, 6000, DateTimes.of((String)"2011-01-04"), 23, 85312, DateTimes.of((String)"2011-01-05"), 85, 102, DateTimes.of((String)"2011-01-05T01"), 80, 100, DateTimes.of((String)"2011-01-06"), 412, 521, DateTimes.of((String)"2011-01-06T01"), 420, 520, DateTimes.of((String)"2011-01-07"), 122, 21894, DateTimes.of((String)"2011-01-07T01"), 12, 2194, DateTimes.of((String)"2011-01-08"), 5, 20, DateTimes.of((String)"2011-01-08T01"), 59, 201, DateTimes.of((String)"2011-01-09"), 18, 521, DateTimes.of((String)"2011-01-09T01"), 181, 52), (Sequence)runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testCachingOverBulkLimitEnforcesLimit() {
        int limit = 10;
        Interval interval = Intervals.of((String)"2011-01-01/2011-01-02");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)interval))).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT).randomQueryId().build();
        ResponseContext context = CachingClusteredClientTest.initializeResponseContext();
        Cache cache = (Cache)EasyMock.createStrictMock(Cache.class);
        Capture cacheKeyCapture = EasyMock.newCapture();
        EasyMock.expect((Object)cache.getBulk((Iterable)EasyMock.capture((Capture)cacheKeyCapture))).andReturn((Object)ImmutableMap.of()).once();
        EasyMock.replay((Object[])new Object[]{cache});
        this.client = this.makeClient((CachePopulator)new ForegroundCachePopulator(JSON_MAPPER, new CachePopulatorStats(), -1L), cache, 10);
        DruidServer lastServer = this.servers[this.random.nextInt(this.servers.length)];
        DataSegment dataSegment = (DataSegment)EasyMock.createNiceMock(DataSegment.class);
        EasyMock.expect((Object)dataSegment.getId()).andReturn((Object)SegmentId.dummy((String)DATA_SOURCE)).anyTimes();
        EasyMock.replay((Object[])new Object[]{dataSegment});
        ServerSelector selector = new ServerSelector(dataSegment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(lastServer, null), dataSegment);
        this.timeline.add(interval, (Object)"v", (PartitionChunk)new SingleElementPartitionChunk((Object)selector));
        this.getDefaultQueryRunner().run(QueryPlus.wrap((Query)query), context);
        Assert.assertTrue((String)"Capture cache keys", (boolean)cacheKeyCapture.hasCaptured());
        Assert.assertTrue((String)"Cache key below limit", (ImmutableList.copyOf((Iterable)((Iterable)cacheKeyCapture.getValue())).size() <= 10 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{cache});
        EasyMock.reset((Object[])new Object[]{cache});
        cacheKeyCapture.reset();
        EasyMock.expect((Object)cache.getBulk((Iterable)EasyMock.capture((Capture)cacheKeyCapture))).andReturn((Object)ImmutableMap.of()).once();
        EasyMock.replay((Object[])new Object[]{cache});
        this.client = this.makeClient((CachePopulator)new ForegroundCachePopulator(JSON_MAPPER, new CachePopulatorStats(), -1L), cache, 0);
        this.getDefaultQueryRunner().run(QueryPlus.wrap((Query)query), context);
        EasyMock.verify((Object[])new Object[]{cache});
        EasyMock.verify((Object[])new Object[]{dataSegment});
        Assert.assertTrue((String)"Capture cache keys", (boolean)cacheKeyCapture.hasCaptured());
        Assert.assertTrue((String)"Cache Keys empty", (boolean)ImmutableList.copyOf((Iterable)((Iterable)cacheKeyCapture.getValue())).isEmpty());
    }

    @Test
    public void testTimeseriesMergingOutOfOrderPartitions() {
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        this.testQueryCaching((QueryRunner)runner, (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05T02"), 80, 100, DateTimes.of((String)"2011-01-06T02"), 420, 520, DateTimes.of((String)"2011-01-07T02"), 12, 2194, DateTimes.of((String)"2011-01-08T02"), 59, 201, DateTimes.of((String)"2011-01-09T02"), 181, 52), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-05T00"), 85, 102, DateTimes.of((String)"2011-01-06T00"), 412, 521, DateTimes.of((String)"2011-01-07T00"), 122, 21894, DateTimes.of((String)"2011-01-08T00"), 5, 20, DateTimes.of((String)"2011-01-09T00"), 18, 521));
        TimeseriesQuery query = builder.intervals("2011-01-05/2011-01-10").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS).randomQueryId().build();
        TestHelper.assertExpectedResults(this.makeRenamedTimeResults(DateTimes.of((String)"2011-01-05T00"), 85, 102, DateTimes.of((String)"2011-01-05T02"), 80, 100, DateTimes.of((String)"2011-01-06T00"), 412, 521, DateTimes.of((String)"2011-01-06T02"), 420, 520, DateTimes.of((String)"2011-01-07T00"), 122, 21894, DateTimes.of((String)"2011-01-07T02"), 12, 2194, DateTimes.of((String)"2011-01-08T00"), 5, 20, DateTimes.of((String)"2011-01-08T02"), 59, 201, DateTimes.of((String)"2011-01-09T00"), 18, 521, DateTimes.of((String)"2011-01-09T02"), 181, 52), (Sequence)runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTimeseriesCachingTimeZone() {
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(PT1H_TZ_GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        this.testQueryCaching((QueryRunner)runner, (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-11-04/2011-11-08"), this.makeTimeResults(new DateTime((Object)"2011-11-04", TIMEZONE), 50, 5000, new DateTime((Object)"2011-11-05", TIMEZONE), 30, 6000, new DateTime((Object)"2011-11-06", TIMEZONE), 23, 85312, new DateTime((Object)"2011-11-07", TIMEZONE), 85, 102));
        TimeseriesQuery query = builder.intervals("2011-11-04/2011-11-08").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS).randomQueryId().build();
        TestHelper.assertExpectedResults(this.makeRenamedTimeResults(new DateTime((Object)"2011-11-04", TIMEZONE), 50, 5000, new DateTime((Object)"2011-11-05", TIMEZONE), 30, 6000, new DateTime((Object)"2011-11-06", TIMEZONE), 23, 85312, new DateTime((Object)"2011-11-07", TIMEZONE), 85, 102), (Sequence)runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testDisableUseCache() {
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        this.testQueryCaching((QueryRunner)runner, 1, true, (Query)builder.context((Map)ImmutableMap.of((Object)"useCache", (Object)"false", (Object)"populateCache", (Object)"true")).randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000));
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        this.cache.close(SegmentId.dummy((String)"0_0").toString());
        this.testQueryCaching((QueryRunner)runner, 1, false, (Query)builder.context((Map)ImmutableMap.of((Object)"useCache", (Object)"false", (Object)"populateCache", (Object)"false")).randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000));
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumMisses());
        this.testQueryCaching(this.getDefaultQueryRunner(), 1, false, (Query)builder.context((Map)ImmutableMap.of((Object)"useCache", (Object)"true", (Object)"populateCache", (Object)"false")).randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000));
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumEntries());
        Assert.assertEquals((long)0L, (long)this.cache.getStats().getNumHits());
        Assert.assertEquals((long)1L, (long)this.cache.getStats().getNumMisses());
    }

    @Test
    public void testTopNCaching() {
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource(DATA_SOURCE).dimension(TOP_DIM).metric("imps").threshold(3).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(Granularities.HOUR).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FluentQueryRunner runner = this.makeTopNQueryRunner();
        this.testQueryCaching((QueryRunner)runner, (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-01"), "a", 50, 5000, "b", 50, 4999, "c", 50, 4998), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-02"), "a", 50, 4997, "b", 50, 4996, "c", 50, 4995), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "c1", 50, 4985, "b", 50, 4984, "c", 50, 4983), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09T01"), "c2", 50, 4985, "b", 50, 4984, "c", 50, 4983));
        TopNQuery query = builder.intervals("2011-01-01/2011-01-10").metric("imps").aggregators(RENAMED_AGGS).postAggregators(DIFF_ORDER_POST_AGGS).randomQueryId().build();
        TestHelper.assertExpectedResults(this.makeRenamedTopNResults(DateTimes.of((String)"2011-01-01"), "a", 50, 5000, "b", 50, 4999, "c", 50, 4998, DateTimes.of((String)"2011-01-02"), "a", 50, 4997, "b", 50, 4996, "c", 50, 4995, DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "c1", 50, 4985, "b", 50, 4984, "c", 50, 4983, DateTimes.of((String)"2011-01-09T01"), "c2", 50, 4985, "b", 50, 4984, "c", 50, 4983), (Sequence)runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTopNCachingTimeZone() {
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource(DATA_SOURCE).dimension(TOP_DIM).metric("imps").threshold(3).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(PT1H_TZ_GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FluentQueryRunner runner = this.makeTopNQueryRunner();
        this.testQueryCaching((QueryRunner)runner, (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-11-04/2011-11-08"), this.makeTopNResultsWithoutRename(new DateTime((Object)"2011-11-04", TIMEZONE), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, new DateTime((Object)"2011-11-05", TIMEZONE), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, new DateTime((Object)"2011-11-06", TIMEZONE), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, new DateTime((Object)"2011-11-07", TIMEZONE), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986));
        TopNQuery query = builder.intervals("2011-11-04/2011-11-08").metric("imps").aggregators(RENAMED_AGGS).postAggregators(DIFF_ORDER_POST_AGGS).randomQueryId().build();
        TestHelper.assertExpectedResults(this.makeRenamedTopNResults(new DateTime((Object)"2011-11-04", TIMEZONE), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, new DateTime((Object)"2011-11-05", TIMEZONE), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, new DateTime((Object)"2011-11-06", TIMEZONE), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, new DateTime((Object)"2011-11-07", TIMEZONE), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986), (Sequence)runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testOutOfOrderSequenceMerging() {
        ImmutableList sequences = ImmutableList.of((Object)Sequences.simple(this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983)), (Object)Sequences.simple(this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09T01"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983)));
        TestHelper.assertExpectedResults(this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983, DateTimes.of((String)"2011-01-09T01"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983), CachingClusteredClientTest.mergeSequences(new TopNQueryBuilder().dataSource(DATA_SOURCE).intervals("2011-01-06/2011-01-10").dimension("a").metric("b").threshold(3).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("b")}).randomQueryId().build(), sequences));
    }

    private static <T> Sequence<T> mergeSequences(Query<T> query, List<Sequence<T>> sequences) {
        return Sequences.simple(sequences).flatMerge(seq -> seq, query.getResultOrdering());
    }

    @Test
    public void testTopNCachingEmptyResults() {
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource(DATA_SOURCE).dimension(TOP_DIM).metric("imps").threshold(3).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(Granularities.HOUR).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FluentQueryRunner runner = this.makeTopNQueryRunner();
        this.testQueryCaching((QueryRunner)runner, (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTopNResultsWithoutRename(new Object[0]), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeTopNResultsWithoutRename(new Object[0]), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09T01"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983));
        TopNQuery query = builder.intervals("2011-01-01/2011-01-10").metric("imps").aggregators(RENAMED_AGGS).postAggregators(DIFF_ORDER_POST_AGGS).randomQueryId().build();
        TestHelper.assertExpectedResults(this.makeRenamedTopNResults(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983, DateTimes.of((String)"2011-01-09T01"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983), (Sequence)runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTopNOnPostAggMetricCaching() {
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource(DATA_SOURCE).dimension(TOP_DIM).metric("avg_imps_per_row_double").threshold(3).intervals((QuerySegmentSpec)SEG_SPEC).filters(DIM_FILTER).granularity(Granularities.HOUR).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FluentQueryRunner runner = this.makeTopNQueryRunner();
        this.testQueryCaching((QueryRunner)runner, (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTopNResultsWithoutRename(new Object[0]), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeTopNResultsWithoutRename(new Object[0]), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "c1", 50, 4985, "b", 50, 4984, "c", 50, 4983), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09T01"), "c2", 50, 4985, "b", 50, 4984, "c", 50, 4983));
        TopNQuery query = builder.intervals("2011-01-01/2011-01-10").metric("avg_imps_per_row_double").aggregators(AGGS).postAggregators(DIFF_ORDER_POST_AGGS).randomQueryId().build();
        TestHelper.assertExpectedResults(this.makeTopNResultsWithoutRename(DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-05T01"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-06T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07T01"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-08T01"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "c1", 50, 4985, "b", 50, 4984, "c", 50, 4983, DateTimes.of((String)"2011-01-09T01"), "c2", 50, 4985, "b", 50, 4984, "c", 50, 4983), (Sequence)runner.run(QueryPlus.wrap((Query)query)));
    }

    private FluentQueryRunner makeTopNQueryRunner() {
        return FluentQueryRunner.create((QueryRunner)this.getDefaultQueryRunner(), (QueryToolChest)new TopNQueryQueryToolChest(new TopNQueryConfig())).applyPreMergeDecoration().mergeResults(true).applyPostMergeDecoration();
    }

    @Test
    public void testSearchCaching() {
        Druids.SearchQueryBuilder builder = Druids.newSearchQueryBuilder().dataSource(DATA_SOURCE).filters(DIM_FILTER).granularity(GRANULARITY).limit(1000).intervals((QuerySegmentSpec)SEG_SPEC).dimensions(Collections.singletonList(TOP_DIM)).query("how").context(CONTEXT);
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4));
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new SearchQueryQueryToolChest(new SearchQueryConfig()));
        TestHelper.assertExpectedResults(this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), (Sequence)runner.run(QueryPlus.wrap((Query)builder.randomQueryId().intervals("2011-01-01/2011-01-10").build())));
    }

    @Test
    public void testSearchCachingRenamedOutput() {
        Druids.SearchQueryBuilder builder = Druids.newSearchQueryBuilder().dataSource(DATA_SOURCE).filters(DIM_FILTER).granularity(GRANULARITY).limit(1000).intervals((QuerySegmentSpec)SEG_SPEC).dimensions(Collections.singletonList(TOP_DIM)).query("how").context(CONTEXT);
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)builder.randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4), Intervals.of((String)"2011-01-02/2011-01-03"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), Intervals.of((String)"2011-01-05/2011-01-10"), this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4));
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new SearchQueryQueryToolChest(new SearchQueryConfig()));
        ResponseContext context = CachingClusteredClientTest.initializeResponseContext();
        TestHelper.assertExpectedResults(this.makeSearchResults(TOP_DIM, DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), (Sequence)runner.run(QueryPlus.wrap((Query)builder.randomQueryId().intervals("2011-01-01/2011-01-10").build()), context));
        SearchQuery query = builder.intervals("2011-01-01/2011-01-10").dimensions((DimensionSpec)new DefaultDimensionSpec(TOP_DIM, "new_dim")).randomQueryId().build();
        TestHelper.assertExpectedResults(this.makeSearchResults("new_dim", DateTimes.of((String)"2011-01-01"), "how", 1, "howdy", 2, "howwwwww", 3, "howwy", 4, DateTimes.of((String)"2011-01-02"), "how1", 1, "howdy1", 2, "howwwwww1", 3, "howwy1", 4, DateTimes.of((String)"2011-01-05"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-05T01"), "how2", 1, "howdy2", 2, "howwwwww2", 3, "howww2", 4, DateTimes.of((String)"2011-01-06"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-06T01"), "how3", 1, "howdy3", 2, "howwwwww3", 3, "howww3", 4, DateTimes.of((String)"2011-01-07"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-07T01"), "how4", 1, "howdy4", 2, "howwwwww4", 3, "howww4", 4, DateTimes.of((String)"2011-01-08"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-08T01"), "how5", 1, "howdy5", 2, "howwwwww5", 3, "howww5", 4, DateTimes.of((String)"2011-01-09"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4, DateTimes.of((String)"2011-01-09T01"), "how6", 1, "howdy6", 2, "howwwwww6", 3, "howww6", 4), (Sequence)runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testTimeBoundaryCaching() {
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-01"), DateTimes.of((String)"2011-01-01"), DateTimes.of((String)"2011-01-02")), Intervals.of((String)"2011-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-02"), DateTimes.of((String)"2011-01-02"), DateTimes.of((String)"2011-01-03")), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05"), DateTimes.of((String)"2011-01-05"), DateTimes.of((String)"2011-01-10")), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05T01"), DateTimes.of((String)"2011-01-05T01"), DateTimes.of((String)"2011-01-10")));
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).bound("maxTime").randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-02"), null, DateTimes.of((String)"2011-01-02")), Intervals.of((String)"2011-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-03"), null, DateTimes.of((String)"2011-01-03")), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-10"), null, DateTimes.of((String)"2011-01-10")));
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).bound("minTime").randomQueryId().build(), Intervals.of((String)"2011-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-01"), DateTimes.of((String)"2011-01-01"), null), Intervals.of((String)"2011-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-02"), DateTimes.of((String)"2011-01-02"), null), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05"), DateTimes.of((String)"2011-01-05"), null), Intervals.of((String)"2011-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"2011-01-05T01"), DateTimes.of((String)"2011-01-05T01"), null));
    }

    @Test
    public void testTimeSeriesWithFilter() {
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new OrDimFilter(new DimFilter[]{new SelectorDimFilter("dim0", "1", null), new BoundDimFilter("dim0", "222", "333", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)}), new AndDimFilter(new DimFilter[]{new InDimFilter("dim1", Arrays.asList("0", "1", "2", "3", "4"), null), new BoundDimFilter("dim1", "0", "3", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("dim1", "1", "9999", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)})});
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).filters((DimFilter)filter).granularity(GRANULARITY).aggregators(AGGS).postAggregators(POST_AGGS).context(CONTEXT);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        List<Iterable<Result<TimeseriesResultValue>>> expectedResult = Arrays.asList(this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000, DateTimes.of((String)"2011-01-02"), 10, 1252, DateTimes.of((String)"2011-01-03"), 20, 6213, DateTimes.of((String)"2011-01-04"), 30, 743), this.makeTimeResults(DateTimes.of((String)"2011-01-07"), 60, 6020, DateTimes.of((String)"2011-01-08"), 70, 250));
        this.testQueryCachingWithFilter((QueryRunner)runner, 3, (Query)builder.randomQueryId().build(), expectedResult, Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-01"), 50, 5000), Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-02"), 10, 1252), Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-03"), 20, 6213), Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-04"), 30, 743), Intervals.of((String)"2011-01-01/2011-01-05"), this.makeTimeResults(DateTimes.of((String)"2011-01-05"), 40, 6000), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-06"), 50, 425), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-07"), 60, 6020), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-08"), 70, 250), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-09"), 23, 85312), Intervals.of((String)"2011-01-06/2011-01-10"), this.makeTimeResults(DateTimes.of((String)"2011-01-10"), 100, 512));
    }

    @Test
    public void testSingleDimensionPruning() {
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new OrDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "a", null), new BoundDimFilter("dim1", "from", "to", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)}), new AndDimFilter(new DimFilter[]{new InDimFilter("dim2", Arrays.asList("a", "c", "e", "g"), null), new BoundDimFilter("dim2", "aaa", "hi", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("dim2", "e", "zzz", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)})});
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).filters((DimFilter)filter).granularity(GRANULARITY).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).intervals("2011-01-05/2011-01-10").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS);
        TimeseriesQuery query = builder.randomQueryId().build();
        Interval interval1 = Intervals.of((String)"2011-01-06/2011-01-07");
        Interval interval2 = Intervals.of((String)"2011-01-07/2011-01-08");
        Interval interval3 = Intervals.of((String)"2011-01-08/2011-01-09");
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        DruidServer lastServer = this.servers[this.random.nextInt(this.servers.length)];
        ServerSelector selector1 = this.makeMockSingleDimensionSelector(lastServer, "dim1", null, "b", 0);
        ServerSelector selector2 = this.makeMockSingleDimensionSelector(lastServer, "dim1", "e", "f", 1);
        ServerSelector selector3 = this.makeMockSingleDimensionSelector(lastServer, "dim1", "hi", "zzz", 2);
        ServerSelector selector4 = this.makeMockSingleDimensionSelector(lastServer, "dim2", "a", "e", 0);
        ServerSelector selector5 = this.makeMockSingleDimensionSelector(lastServer, "dim2", null, null, 1);
        ServerSelector selector6 = this.makeMockSingleDimensionSelector(lastServer, "other", "b", null, 0);
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(0, 3, (Object)selector1));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(1, 3, (Object)selector2));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(2, 3, (Object)selector3));
        this.timeline.add(interval2, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(0, 2, (Object)selector4));
        this.timeline.add(interval2, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(1, 2, (Object)selector5));
        this.timeline.add(interval3, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(0, 1, (Object)selector6));
        Capture capture = Capture.newInstance();
        Capture contextCap = Capture.newInstance();
        QueryRunner mockRunner = (QueryRunner)EasyMock.createNiceMock(QueryRunner.class);
        EasyMock.expect((Object)mockRunner.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)contextCap))).andReturn((Object)Sequences.empty()).anyTimes();
        EasyMock.expect((Object)this.serverView.getQueryRunner(lastServer)).andReturn((Object)mockRunner).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverView});
        EasyMock.replay((Object[])new Object[]{mockRunner});
        ArrayList<SegmentDescriptor> descriptors = new ArrayList<SegmentDescriptor>();
        descriptors.add(new SegmentDescriptor(interval1, "v", 0));
        descriptors.add(new SegmentDescriptor(interval1, "v", 2));
        descriptors.add(new SegmentDescriptor(interval2, "v", 1));
        descriptors.add(new SegmentDescriptor(interval3, "v", 0));
        MultipleSpecificSegmentSpec expected = new MultipleSpecificSegmentSpec(descriptors);
        runner.run(QueryPlus.wrap((Query)query)).toList();
        Assert.assertEquals((Object)expected, (Object)((TimeseriesQuery)((QueryPlus)capture.getValue()).getQuery()).getQuerySegmentSpec());
    }

    @Test
    public void testHashBasedPruningQueryContextEnabledWithPartitionFunctionAndPartitionDimensionsDoSegmentPruning() {
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "a", null), new BoundDimFilter("dim2", "e", "zzz", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), new AndDimFilter(new DimFilter[]{new InDimFilter("dim3", Arrays.asList("a", "c", "e", "g"), null), new BoundDimFilter("dim3", "aaa", "ddd", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)})});
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).filters((DimFilter)filter).granularity(GRANULARITY).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).intervals("2011-01-05/2011-01-10").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS).randomQueryId();
        TimeseriesQuery query = builder.build();
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        Interval interval1 = Intervals.of((String)"2011-01-06/2011-01-07");
        Interval interval2 = Intervals.of((String)"2011-01-07/2011-01-08");
        Interval interval3 = Intervals.of((String)"2011-01-08/2011-01-09");
        DruidServer lastServer = this.servers[this.random.nextInt(this.servers.length)];
        ImmutableList partitionDimensions1 = ImmutableList.of((Object)"dim1");
        ServerSelector selector1 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions1, HashPartitionFunction.MURMUR3_32_ABS, 0, 6);
        ServerSelector selector2 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions1, HashPartitionFunction.MURMUR3_32_ABS, 1, 6);
        ServerSelector selector3 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions1, HashPartitionFunction.MURMUR3_32_ABS, 2, 6);
        ServerSelector selector4 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions1, HashPartitionFunction.MURMUR3_32_ABS, 3, 6);
        ServerSelector selector5 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions1, HashPartitionFunction.MURMUR3_32_ABS, 4, 6);
        ServerSelector selector6 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions1, HashPartitionFunction.MURMUR3_32_ABS, 5, 6);
        ImmutableList partitionDimensions2 = ImmutableList.of((Object)"dim2");
        ServerSelector selector7 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions2, HashPartitionFunction.MURMUR3_32_ABS, 0, 3);
        ServerSelector selector8 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions2, HashPartitionFunction.MURMUR3_32_ABS, 1, 3);
        ServerSelector selector9 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions2, HashPartitionFunction.MURMUR3_32_ABS, 2, 3);
        ImmutableList partitionDimensions3 = ImmutableList.of((Object)"dim1", (Object)"dim3");
        ServerSelector selector10 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions3, HashPartitionFunction.MURMUR3_32_ABS, 0, 4);
        ServerSelector selector11 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions3, HashPartitionFunction.MURMUR3_32_ABS, 1, 4);
        ServerSelector selector12 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions3, HashPartitionFunction.MURMUR3_32_ABS, 2, 4);
        ServerSelector selector13 = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions3, HashPartitionFunction.MURMUR3_32_ABS, 3, 4);
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(0, 6, (Object)selector1));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(1, 6, (Object)selector2));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(2, 6, (Object)selector3));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(3, 6, (Object)selector4));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(4, 6, (Object)selector5));
        this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(5, 6, (Object)selector6));
        this.timeline.add(interval2, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(0, 3, (Object)selector7));
        this.timeline.add(interval2, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(1, 3, (Object)selector8));
        this.timeline.add(interval2, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(2, 3, (Object)selector9));
        this.timeline.add(interval3, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(0, 3, (Object)selector10));
        this.timeline.add(interval3, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(1, 3, (Object)selector11));
        this.timeline.add(interval3, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(2, 3, (Object)selector12));
        this.timeline.add(interval3, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(2, 3, (Object)selector13));
        Capture capture = Capture.newInstance();
        Capture contextCap = Capture.newInstance();
        QueryRunner mockRunner = (QueryRunner)EasyMock.createNiceMock(QueryRunner.class);
        EasyMock.expect((Object)mockRunner.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)contextCap))).andReturn((Object)Sequences.empty()).anyTimes();
        EasyMock.expect((Object)this.serverView.getQueryRunner(lastServer)).andReturn((Object)mockRunner).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverView});
        EasyMock.replay((Object[])new Object[]{mockRunner});
        ArrayList<SegmentDescriptor> expcetedDescriptors = new ArrayList<SegmentDescriptor>();
        expcetedDescriptors.add(new SegmentDescriptor(interval1, "v", 3));
        expcetedDescriptors.add(new SegmentDescriptor(interval2, "v", 0));
        expcetedDescriptors.add(new SegmentDescriptor(interval2, "v", 1));
        expcetedDescriptors.add(new SegmentDescriptor(interval2, "v", 2));
        expcetedDescriptors.add(new SegmentDescriptor(interval3, "v", 2));
        MultipleSpecificSegmentSpec expected = new MultipleSpecificSegmentSpec(expcetedDescriptors);
        runner.run(QueryPlus.wrap((Query)query)).toList();
        Assert.assertEquals((Object)expected, (Object)((TimeseriesQuery)((QueryPlus)capture.getValue()).getQuery()).getQuerySegmentSpec());
    }

    @Test
    public void testHashBasedPruningQueryContextDisabledNoSegmentPruning() {
        this.testNoSegmentPruningForHashPartitionedSegments(false, HashPartitionFunction.MURMUR3_32_ABS, false);
    }

    @Test
    public void testHashBasedPruningWithoutPartitionFunctionNoSegmentPruning() {
        this.testNoSegmentPruningForHashPartitionedSegments(true, null, false);
    }

    @Test
    public void testHashBasedPruningWithEmptyPartitionDimensionsNoSegmentPruning() {
        this.testNoSegmentPruningForHashPartitionedSegments(true, HashPartitionFunction.MURMUR3_32_ABS, true);
    }

    private void testNoSegmentPruningForHashPartitionedSegments(boolean enableSegmentPruning, @Nullable HashPartitionFunction partitionFunction, boolean useEmptyPartitionDimensions) {
        AndDimFilter filter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "a", null), new BoundDimFilter("dim2", "e", "zzz", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), new AndDimFilter(new DimFilter[]{new InDimFilter("dim3", Arrays.asList("a", "c", "e", "g"), null), new BoundDimFilter("dim3", "aaa", "ddd", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)})});
        HashMap<String, Object> context = new HashMap<String, Object>((Map<String, Object>)CONTEXT);
        context.put("secondaryPartitionPruning", enableSegmentPruning);
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).filters((DimFilter)filter).granularity(GRANULARITY).intervals((QuerySegmentSpec)SEG_SPEC).intervals("2011-01-05/2011-01-10").aggregators(RENAMED_AGGS).postAggregators(RENAMED_POST_AGGS).context(context).randomQueryId();
        TimeseriesQuery query = builder.build();
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.getDefaultQueryRunner(), (QueryToolChest)new TimeseriesQueryQueryToolChest());
        Interval interval1 = Intervals.of((String)"2011-01-06/2011-01-07");
        Interval interval2 = Intervals.of((String)"2011-01-07/2011-01-08");
        Interval interval3 = Intervals.of((String)"2011-01-08/2011-01-09");
        DruidServer lastServer = this.servers[this.random.nextInt(this.servers.length)];
        ImmutableList partitionDimensions = useEmptyPartitionDimensions ? ImmutableList.of() : ImmutableList.of((Object)"dim1");
        int numPartitions1 = 6;
        for (int i2 = 0; i2 < 6; ++i2) {
            ServerSelector selector = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions, partitionFunction, i2, 6);
            this.timeline.add(interval1, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(i2, 6, (Object)selector));
        }
        partitionDimensions = useEmptyPartitionDimensions ? ImmutableList.of() : ImmutableList.of((Object)"dim2");
        int numPartitions2 = 3;
        for (int i3 = 0; i3 < 3; ++i3) {
            ServerSelector selector = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions, partitionFunction, i3, 3);
            this.timeline.add(interval2, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(i3, 3, (Object)selector));
        }
        partitionDimensions = useEmptyPartitionDimensions ? ImmutableList.of() : ImmutableList.of((Object)"dim1", (Object)"dim3");
        int numPartitions3 = 4;
        for (int i4 = 0; i4 < 4; ++i4) {
            ServerSelector selector = this.makeMockHashBasedSelector(lastServer, (List<String>)partitionDimensions, partitionFunction, i4, 4);
            this.timeline.add(interval3, (Object)"v", (PartitionChunk)new NumberedPartitionChunk(i4, 4, (Object)selector));
        }
        Capture capture = Capture.newInstance();
        Capture contextCap = Capture.newInstance();
        QueryRunner mockRunner = (QueryRunner)EasyMock.createNiceMock(QueryRunner.class);
        EasyMock.expect((Object)mockRunner.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)contextCap))).andReturn((Object)Sequences.empty()).anyTimes();
        EasyMock.expect((Object)this.serverView.getQueryRunner(lastServer)).andReturn((Object)mockRunner).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverView});
        EasyMock.replay((Object[])new Object[]{mockRunner});
        HashSet expcetedDescriptors = new HashSet();
        IntStream.range(0, 6).forEach(i -> expcetedDescriptors.add(new SegmentDescriptor(interval1, "v", i)));
        IntStream.range(0, 3).forEach(i -> expcetedDescriptors.add(new SegmentDescriptor(interval2, "v", i)));
        IntStream.range(0, 4).forEach(i -> expcetedDescriptors.add(new SegmentDescriptor(interval3, "v", i)));
        runner.run(QueryPlus.wrap((Query)query)).toList();
        QuerySegmentSpec querySegmentSpec = ((TimeseriesQuery)((QueryPlus)capture.getValue()).getQuery()).getQuerySegmentSpec();
        Assert.assertSame(MultipleSpecificSegmentSpec.class, (Object)querySegmentSpec.getClass());
        HashSet actualDescriptors = new HashSet(((MultipleSpecificSegmentSpec)querySegmentSpec).getDescriptors());
        Assert.assertEquals(expcetedDescriptors, actualDescriptors);
    }

    private ServerSelector makeMockHashBasedSelector(DruidServer server, List<String> partitionDimensions, @Nullable HashPartitionFunction partitionFunction, int partitionNum, int partitions) {
        DataSegment segment = new DataSegment(SegmentId.dummy((String)DATA_SOURCE), null, null, null, (ShardSpec)new HashBasedNumberedShardSpec(partitionNum, partitions, Integer.valueOf(partitionNum), Integer.valueOf(partitions), partitionDimensions, partitionFunction, TestHelper.makeJsonMapper()), null, Integer.valueOf(9), 0L);
        ServerSelector selector = new ServerSelector(segment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(server, null), segment);
        return selector;
    }

    private ServerSelector makeMockSingleDimensionSelector(DruidServer server, String dimension, String start, String end, int partitionNum) {
        DataSegment segment = new DataSegment(SegmentId.dummy((String)DATA_SOURCE), null, null, null, (ShardSpec)new SingleDimensionShardSpec(dimension, start, end, partitionNum, Integer.valueOf(-1)), null, Integer.valueOf(9), 0L);
        ServerSelector selector = new ServerSelector(segment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(server, null), segment);
        return selector;
    }

    private Iterable<Result<TimeBoundaryResultValue>> makeTimeBoundaryResult(DateTime timestamp, DateTime minTime, DateTime maxTime) {
        ImmutableMap value = minTime != null && maxTime != null ? ImmutableMap.of((Object)"minTime", (Object)minTime, (Object)"maxTime", (Object)maxTime) : (maxTime != null ? ImmutableMap.of((Object)"maxTime", (Object)maxTime) : ImmutableMap.of((Object)"minTime", (Object)minTime));
        return ImmutableList.of((Object)new Result(timestamp, (Object)new TimeBoundaryResultValue((Object)value)));
    }

    public void parseResults(List<Interval> queryIntervals, List<List<Iterable<Result<Object>>>> expectedResults, Object ... args) {
        if (args.length % 2 != 0) {
            throw new ISE("args.length must be divisible by two, was %d", new Object[]{args.length});
        }
        for (int i = 0; i < args.length; i += 2) {
            Interval interval = (Interval)args[i];
            Iterable results = (Iterable)args[i + 1];
            if (queryIntervals.size() > 0 && interval.equals((Object)queryIntervals.get(queryIntervals.size() - 1))) {
                expectedResults.get(expectedResults.size() - 1).add(results);
                continue;
            }
            queryIntervals.add(interval);
            expectedResults.add(Lists.newArrayList((Object[])new Iterable[]{results}));
        }
    }

    public void testQueryCachingWithFilter(final QueryRunner runner, final int numTimesToQuery, final Query query, List<Iterable<Result<TimeseriesResultValue>>> filteredExpected, Object ... args) {
        final ArrayList queryIntervals = Lists.newArrayListWithCapacity((int)(args.length / 2));
        ArrayList expectedResults = Lists.newArrayListWithCapacity((int)queryIntervals.size());
        this.parseResults(queryIntervals, expectedResults, args);
        for (int i = 0; i < queryIntervals.size(); ++i) {
            ArrayList<Object> mocks = new ArrayList<Object>();
            mocks.add(this.serverView);
            final Interval actualQueryInterval = new Interval((ReadableInstant)((Interval)queryIntervals.get(0)).getStart(), (ReadableInstant)((Interval)queryIntervals.get(i)).getEnd());
            List<Map<DruidServer, ServerExpectations>> serverExpectationList = this.populateTimeline(queryIntervals, expectedResults, i, mocks);
            Map<DruidServer, ServerExpectations> finalExpectation = serverExpectationList.get(serverExpectationList.size() - 1);
            for (Map.Entry<DruidServer, ServerExpectations> entry : finalExpectation.entrySet()) {
                DruidServer server = entry.getKey();
                ServerExpectations expectations = entry.getValue();
                EasyMock.expect((Object)this.serverView.getQueryRunner(server)).andReturn((Object)expectations.getQueryRunner()).times(0, 1);
                final Capture capture = Capture.newInstance();
                Capture context = Capture.newInstance();
                QueryRunner queryable = expectations.getQueryRunner();
                if (query instanceof TimeseriesQuery) {
                    final ArrayList<SegmentId> segmentIds = new ArrayList<SegmentId>();
                    final ArrayList results = new ArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)context))).andAnswer((IAnswer)new IAnswer<Sequence>(){

                        public Sequence answer() {
                            return CachingClusteredClientTest.this.toFilteredQueryableTimeseriesResults((TimeseriesQuery)((QueryPlus)capture.getValue()).getQuery(), segmentIds, queryIntervals, results);
                        }
                    }).times(0, 1);
                    continue;
                }
                throw new ISE("Unknown query type[%s]", new Object[]{query.getClass()});
            }
            final ArrayList expected = new ArrayList();
            for (int intervalNo = 0; intervalNo < i + 1; ++intervalNo) {
                Iterables.addAll((Collection)expected, filteredExpected.get(intervalNo));
            }
            this.runWithMocks(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < numTimesToQuery; ++i) {
                        TestHelper.assertExpectedResults((Iterable)expected, (Sequence)runner.run(QueryPlus.wrap((Query)query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)actualQueryInterval))))));
                        if (CachingClusteredClientTest.this.queryCompletedCallback == null) continue;
                        CachingClusteredClientTest.this.queryCompletedCallback.run();
                    }
                }
            }, mocks.toArray());
        }
    }

    private Sequence<Result<TimeseriesResultValue>> toFilteredQueryableTimeseriesResults(TimeseriesQuery query, List<SegmentId> segmentIds, List<Interval> queryIntervals, List<Iterable<Result<TimeseriesResultValue>>> results) {
        MultipleSpecificSegmentSpec spec = (MultipleSpecificSegmentSpec)query.getQuerySegmentSpec();
        ArrayList<Result> ret = new ArrayList<Result>();
        for (SegmentDescriptor descriptor : spec.getDescriptors()) {
            SegmentId id = SegmentId.dummy((String)StringUtils.format((String)"%s_%s", (Object[])new Object[]{queryIntervals.indexOf(descriptor.getInterval()), descriptor.getPartitionNumber()}));
            int index = segmentIds.indexOf(id);
            if (index != -1) {
                Result result = new Result(results.get(index).iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results.get(index)), id.toString(), descriptor.getInterval()));
                ret.add(result);
                continue;
            }
            throw new ISE("Descriptor %s not found in server", new Object[]{id});
        }
        return Sequences.simple(ret);
    }

    public void testQueryCaching(QueryRunner runner, Query query, Object ... args) {
        this.testQueryCaching(runner, 3, true, query, args);
    }

    public void testQueryCaching(final QueryRunner runner, final int numTimesToQuery, boolean expectBySegment, final Query query, Object ... args) {
        ArrayList queryIntervals = Lists.newArrayListWithCapacity((int)(args.length / 2));
        ArrayList expectedResults = Lists.newArrayListWithCapacity((int)queryIntervals.size());
        this.parseResults(queryIntervals, expectedResults, args);
        for (int i = 0; i < queryIntervals.size(); ++i) {
            int expectedResultsRangeEnd;
            int expectedResultsRangeStart;
            ArrayList<Object> mocks = new ArrayList<Object>();
            mocks.add(this.serverView);
            final Interval actualQueryInterval = new Interval((ReadableInstant)((Interval)queryIntervals.get(0)).getStart(), (ReadableInstant)((Interval)queryIntervals.get(i)).getEnd());
            final List<Map<DruidServer, ServerExpectations>> serverExpectationList = this.populateTimeline(queryIntervals, expectedResults, i, mocks);
            ArrayList<Capture> queryCaptures = new ArrayList<Capture>();
            Map<DruidServer, ServerExpectations> finalExpectation = serverExpectationList.get(serverExpectationList.size() - 1);
            for (Map.Entry<DruidServer, ServerExpectations> entry : finalExpectation.entrySet()) {
                ArrayList<Iterable<Result<TimeBoundaryResultValue>>> results;
                ArrayList<Interval> intervals;
                ArrayList<SegmentId> segmentIds;
                DruidServer server = entry.getKey();
                ServerExpectations expectations = entry.getValue();
                EasyMock.expect((Object)this.serverView.getQueryRunner(server)).andReturn((Object)expectations.getQueryRunner()).once();
                Capture capture = Capture.newInstance();
                Capture context = Capture.newInstance();
                queryCaptures.add(capture);
                QueryRunner queryable = expectations.getQueryRunner();
                if (query instanceof TimeseriesQuery) {
                    segmentIds = new ArrayList<SegmentId>();
                    intervals = new ArrayList<Interval>();
                    results = new ArrayList<Iterable<Result<TimeBoundaryResultValue>>>();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)context))).andReturn(this.toQueryableTimeseriesResults(expectBySegment, segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof TopNQuery) {
                    segmentIds = new ArrayList();
                    intervals = new ArrayList();
                    results = new ArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)context))).andReturn(this.toQueryableTopNResults(segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof SearchQuery) {
                    segmentIds = new ArrayList();
                    intervals = new ArrayList();
                    results = new ArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)context))).andReturn(this.toQueryableSearchResults(segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof GroupByQuery) {
                    segmentIds = new ArrayList();
                    intervals = new ArrayList();
                    results = new ArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)context))).andReturn(this.toQueryableGroupByResults((GroupByQuery)query, segmentIds, intervals, results)).once();
                    continue;
                }
                if (query instanceof TimeBoundaryQuery) {
                    segmentIds = new ArrayList();
                    intervals = new ArrayList();
                    results = new ArrayList();
                    for (ServerExpectation expectation : expectations) {
                        segmentIds.add(expectation.getSegmentId());
                        intervals.add(expectation.getInterval());
                        results.add(expectation.getResults());
                    }
                    EasyMock.expect((Object)queryable.run((QueryPlus)EasyMock.capture((Capture)capture), (ResponseContext)EasyMock.capture((Capture)context))).andReturn(this.toQueryableTimeBoundaryResults(segmentIds, intervals, results)).once();
                    continue;
                }
                throw new ISE("Unknown query type[%s]", new Object[]{query.getClass()});
            }
            if (query instanceof TimeBoundaryQuery) {
                expectedResultsRangeStart = i;
                expectedResultsRangeEnd = i + 1;
            } else {
                expectedResultsRangeStart = 0;
                expectedResultsRangeEnd = i + 1;
            }
            this.runWithMocks(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < numTimesToQuery; ++i) {
                        TestHelper.assertExpectedResults((Iterable)new MergeIterable((Iterable)FunctionalIterable.create((Iterable)new RangeIterable(expectedResultsRangeStart, expectedResultsRangeEnd)).transformCat((Function)new Function<Integer, Iterable<Iterable<Result<Object>>>>(){

                            public Iterable<Iterable<Result<Object>>> apply(@Nullable Integer input) {
                                ArrayList<Iterable<Result<Object>>> retVal = new ArrayList<Iterable<Result<Object>>>();
                                Map exps = (Map)serverExpectationList.get(input);
                                for (ServerExpectations expectations : exps.values()) {
                                    for (ServerExpectation expectation : expectations) {
                                        retVal.add(expectation.getResults());
                                    }
                                }
                                return retVal;
                            }
                        }), (Comparator)(query instanceof GroupByQuery ? ((GroupByQuery)query).getResultOrdering() : Comparators.naturalNullsFirst())), (Iterable)runner.run(QueryPlus.wrap((Query)query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)actualQueryInterval)))), CachingClusteredClientTest.initializeResponseContext()).toList(), (String)StringUtils.format((String)"Run number [%d]", (Object[])new Object[]{i}));
                        if (CachingClusteredClientTest.this.queryCompletedCallback == null) continue;
                        CachingClusteredClientTest.this.queryCompletedCallback.run();
                    }
                }
            }, mocks.toArray());
            for (Capture queryCapture : queryCaptures) {
                QueryPlus capturedQueryPlus = (QueryPlus)queryCapture.getValue();
                Query capturedQuery = capturedQueryPlus.getQuery();
                QueryContext queryContext = capturedQuery.context();
                if (expectBySegment) {
                    Assert.assertEquals((Object)true, (Object)queryContext.getBoolean("bySegment"));
                    continue;
                }
                Assert.assertTrue((queryContext.get("bySegment") == null || queryContext.getBoolean("bySegment") == false ? 1 : 0) != 0);
            }
        }
    }

    private List<Map<DruidServer, ServerExpectations>> populateTimeline(List<Interval> queryIntervals, List<List<Iterable<Result<Object>>>> expectedResults, int numQueryIntervals, List<Object> mocks) {
        this.timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        ArrayList<Map<DruidServer, ServerExpectations>> serverExpectationList = new ArrayList<Map<DruidServer, ServerExpectations>>();
        for (int k = 0; k < numQueryIntervals + 1; ++k) {
            int numChunks = expectedResults.get(k).size();
            TreeMap<DruidServer, ServerExpectations> serverExpectations = new TreeMap<DruidServer, ServerExpectations>();
            serverExpectationList.add(serverExpectations);
            for (int j = 0; j < numChunks; ++j) {
                SingleDimensionShardSpec shardSpec;
                DruidServer lastServer = this.servers[this.random.nextInt(this.servers.length)];
                serverExpectations.computeIfAbsent(lastServer, server -> new ServerExpectations((DruidServer)server, this.makeMock(mocks, QueryRunner.class)));
                if (numChunks == 1) {
                    shardSpec = new SingleDimensionShardSpec("dimAll", null, null, 0, Integer.valueOf(1));
                } else {
                    String start = null;
                    String end = null;
                    if (j > 0) {
                        start = String.valueOf(j);
                    }
                    if (j + 1 < numChunks) {
                        end = String.valueOf(j + 1);
                    }
                    shardSpec = new SingleDimensionShardSpec("dim" + k, start, end, j, Integer.valueOf(numChunks));
                }
                DataSegment mockSegment = this.makeMock(mocks, DataSegment.class);
                ServerExpectation expectation = new ServerExpectation(SegmentId.dummy((String)StringUtils.format((String)"%s_%s", (Object[])new Object[]{k, j})), queryIntervals.get(k), mockSegment, (ShardSpec)shardSpec, expectedResults.get(k).get(j));
                ((ServerExpectations)serverExpectations.get(lastServer)).addExpectation(expectation);
                EasyMock.expect((Object)mockSegment.getSize()).andReturn((Object)0L).anyTimes();
                EasyMock.replay((Object[])new Object[]{mockSegment});
                ServerSelector selector = new ServerSelector(expectation.getSegment(), (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
                selector.addServerAndUpdateSegment(new QueryableDruidServer(lastServer, null), selector.getSegment());
                EasyMock.reset((Object[])new Object[]{mockSegment});
                EasyMock.expect((Object)mockSegment.getShardSpec()).andReturn((Object)shardSpec).anyTimes();
                this.timeline.add(queryIntervals.get(k), (Object)String.valueOf(k), shardSpec.createChunk((Object)selector));
            }
        }
        return serverExpectationList;
    }

    private Sequence<Result<TimeseriesResultValue>> toQueryableTimeseriesResults(boolean bySegment, Iterable<SegmentId> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<TimeseriesResultValue>>> results) {
        if (bySegment) {
            return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<SegmentId, Interval, Iterable<Result<TimeseriesResultValue>>, Result<TimeseriesResultValue>>(){

                public Result<TimeseriesResultValue> apply(SegmentId segmentId, Interval interval, Iterable<Result<TimeseriesResultValue>> results) {
                    return new Result(results.iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId.toString(), interval));
                }
            }));
        }
        return Sequences.simple((Iterable)Iterables.concat(results));
    }

    private Sequence<Result<TopNResultValue>> toQueryableTopNResults(Iterable<SegmentId> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<TopNResultValue>>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<SegmentId, Interval, Iterable<Result<TopNResultValue>>, Result<TopNResultValue>>(){

            public Result<TopNResultValue> apply(SegmentId segmentId, Interval interval, Iterable<Result<TopNResultValue>> results) {
                return new Result(interval.getStart(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId.toString(), interval));
            }
        }));
    }

    private Sequence<Result<SearchResultValue>> toQueryableSearchResults(Iterable<SegmentId> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<SearchResultValue>>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<SegmentId, Interval, Iterable<Result<SearchResultValue>>, Result<SearchResultValue>>(){

            public Result<SearchResultValue> apply(SegmentId segmentId, Interval interval, Iterable<Result<SearchResultValue>> results) {
                return new Result(results.iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId.toString(), interval));
            }
        }));
    }

    private Sequence<Result> toQueryableGroupByResults(final GroupByQuery query, Iterable<SegmentId> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<ResultRow>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<SegmentId, Interval, Iterable<ResultRow>, Result>(){

            public Result apply(SegmentId segmentId, Interval interval, Iterable<ResultRow> results) {
                DateTime timestamp = query.getUniversalTimestamp() != null ? query.getUniversalTimestamp() : query.getGranularity().toDateTime(results.iterator().next().getLong(0));
                return new Result(timestamp, (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId.toString(), interval));
            }
        }));
    }

    private Sequence<Result<TimeBoundaryResultValue>> toQueryableTimeBoundaryResults(Iterable<SegmentId> segmentIds, Iterable<Interval> intervals, Iterable<Iterable<Result<TimeBoundaryResultValue>>> results) {
        return Sequences.simple((Iterable)FunctionalIterable.create(segmentIds).trinaryTransform(intervals, results, (TrinaryFn)new TrinaryFn<SegmentId, Interval, Iterable<Result<TimeBoundaryResultValue>>, Result<TimeBoundaryResultValue>>(){

            public Result<TimeBoundaryResultValue> apply(SegmentId segmentId, Interval interval, Iterable<Result<TimeBoundaryResultValue>> results) {
                return new Result(results.iterator().next().getTimestamp(), (Object)new BySegmentResultValueClass((List)Lists.newArrayList(results), segmentId.toString(), interval));
            }
        }));
    }

    private Iterable<Result<TimeseriesResultValue>> makeTimeResults(Object ... objects) {
        if (objects.length % 3 != 0) {
            throw new ISE("makeTimeResults must be passed arguments in groups of 3, got[%d]", new Object[]{objects.length});
        }
        ArrayList retVal = Lists.newArrayListWithCapacity((int)(objects.length / 3));
        for (int i = 0; i < objects.length; i += 3) {
            double avg_impr = ((Number)objects[i + 2]).doubleValue() / ((Number)objects[i + 1]).doubleValue();
            retVal.add(new Result((DateTime)objects[i], (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", objects[i + 1]).put((Object)"imps", objects[i + 2]).put((Object)"impers", objects[i + 2]).put((Object)"avg_imps_per_row", (Object)avg_impr).put((Object)"avg_imps_per_row_half", (Object)(avg_impr / 2.0)).put((Object)"avg_imps_per_row_double", (Object)(avg_impr * 2.0)).build())));
        }
        return retVal;
    }

    private Iterable<Result<TimeseriesResultValue>> makeRenamedTimeResults(Object ... objects) {
        if (objects.length % 3 != 0) {
            throw new ISE("makeTimeResults must be passed arguments in groups of 3, got[%d]", new Object[]{objects.length});
        }
        ArrayList retVal = Lists.newArrayListWithCapacity((int)(objects.length / 3));
        for (int i = 0; i < objects.length; i += 3) {
            retVal.add(new Result((DateTime)objects[i], (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)objects[i + 1], (Object)"imps", (Object)objects[i + 2], (Object)"impers2", (Object)objects[i + 2]))));
        }
        return retVal;
    }

    private Iterable<Result<TopNResultValue>> makeTopNResultsWithoutRename(Object ... objects) {
        return this.makeTopNResults(Lists.newArrayList((Object[])new String[]{TOP_DIM, "rows", "imps", "impers", "avg_imps_per_row", "avg_imps_per_row_double", "avg_imps_per_row_half"}), objects);
    }

    private Iterable<Result<TopNResultValue>> makeTopNResults(List<String> names, Object ... objects) {
        Preconditions.checkArgument((names.size() == 7 ? 1 : 0) != 0);
        ArrayList<Result<TopNResultValue>> retVal = new ArrayList<Result<TopNResultValue>>();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            ArrayList<ImmutableMap> values = new ArrayList<ImmutableMap>();
            while (index < objects.length && !(objects[index] instanceof DateTime)) {
                if (objects.length - index < 3) {
                    throw new ISE("expect 3 values for each entry in the top list, had %d values left.", new Object[]{objects.length - index});
                }
                double imps = ((Number)objects[index + 2]).doubleValue();
                double rows = ((Number)objects[index + 1]).doubleValue();
                values.add(ImmutableMap.builder().put((Object)names.get(0), objects[index]).put((Object)names.get(1), (Object)rows).put((Object)names.get(2), (Object)imps).put((Object)names.get(3), (Object)imps).put((Object)names.get(4), (Object)(imps / rows)).put((Object)names.get(5), (Object)(imps * 2.0 / rows)).put((Object)names.get(6), (Object)(imps / (rows * 2.0))).build());
                index += 3;
            }
            retVal.add((Result<TopNResultValue>)new Result(timestamp, (Object)TopNResultValue.create(values)));
        }
        return retVal;
    }

    private Iterable<Result<TopNResultValue>> makeRenamedTopNResults(Object ... objects) {
        return this.makeTopNResults(Lists.newArrayList((Object[])new String[]{TOP_DIM, "rows", "imps", "impers2", "avg_imps_per_row", "avg_imps_per_row_double", "avg_imps_per_row_half"}), objects);
    }

    private Iterable<Result<SearchResultValue>> makeSearchResults(String dim, Object ... objects) {
        ArrayList<Result<SearchResultValue>> retVal = new ArrayList<Result<SearchResultValue>>();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            ArrayList<SearchHit> values = new ArrayList<SearchHit>();
            while (index < objects.length && !(objects[index] instanceof DateTime)) {
                values.add(new SearchHit(dim, objects[index++].toString(), (Integer)objects[index++]));
            }
            retVal.add((Result<SearchResultValue>)new Result(timestamp, (Object)new SearchResultValue(values)));
        }
        return retVal;
    }

    private Iterable<ResultRow> makeGroupByResults(GroupByQuery query, Object ... objects) {
        ArrayList<ResultRow> retVal = new ArrayList<ResultRow>();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            Map rowMap = (Map)objects[index++];
            ResultRow row = ResultRow.create((int)query.getResultRowSizeWithoutPostAggregators());
            if (query.getResultRowHasTimestamp()) {
                row.set(0, (Object)timestamp.getMillis());
            }
            for (Map.Entry entry : rowMap.entrySet()) {
                int position = query.getResultRowSignature().indexOf((String)entry.getKey());
                row.set(position, entry.getValue());
            }
            retVal.add(row);
        }
        return retVal;
    }

    private <T> T makeMock(List<Object> mocks, Class<T> clazz) {
        Object obj = EasyMock.createMock(clazz);
        mocks.add(obj);
        return (T)obj;
    }

    private void runWithMocks(Runnable toRun, Object ... mocks) {
        EasyMock.replay((Object[])mocks);
        toRun.run();
        EasyMock.verify((Object[])mocks);
        EasyMock.reset((Object[])mocks);
    }

    protected CachingClusteredClient makeClient(CachePopulator cachePopulator) {
        return this.makeClient(cachePopulator, this.cache, 10);
    }

    protected CachingClusteredClient makeClient(CachePopulator cachePopulator, Cache cache, final int mergeLimit) {
        return new CachingClusteredClient(WAREHOUSE, new TimelineServerView(){

            public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
            }

            public Optional<VersionedIntervalTimeline<String, ServerSelector>> getTimeline(DataSourceAnalysis analysis) {
                return Optional.of(CachingClusteredClientTest.this.timeline);
            }

            public List<ImmutableDruidServer> getDruidServers() {
                throw new UnsupportedOperationException();
            }

            public <T> QueryRunner<T> getQueryRunner(DruidServer server) {
                return CachingClusteredClientTest.this.serverView.getQueryRunner(server);
            }

            public void registerTimelineCallback(Executor exec, TimelineServerView.TimelineCallback callback) {
                throw new UnsupportedOperationException();
            }

            public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
            }
        }, cache, JSON_MAPPER, cachePopulator, new CacheConfig(){

            public boolean isPopulateCache() {
                return true;
            }

            public boolean isUseCache() {
                return true;
            }

            public boolean isQueryCacheable(Query query) {
                return true;
            }

            public int getCacheBulkMergeLimit() {
                return mergeLimit;
            }
        }, new DruidHttpClientConfig(){

            public long getMaxQueuedBytes() {
                return 0L;
            }
        }, new BrokerParallelMergeConfig(){

            public boolean useParallelMergePool() {
                return true;
            }

            public int getParallelism() {
                return 1;
            }

            public int getDefaultMaxQueryParallelism() {
                return 1;
            }
        }, ForkJoinPool.commonPool(), new QueryScheduler(0, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)NoQueryLaningStrategy.INSTANCE, new ServerConfig()), (ServiceEmitter)new NoopServiceEmitter());
    }

    @Test
    public void testTimeBoundaryCachingWhenTimeIsInteger() {
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).randomQueryId().build(), Intervals.of((String)"1970-01-01/1970-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-01"), DateTimes.of((String)"1970-01-01"), DateTimes.of((String)"1970-01-02")), Intervals.of((String)"1970-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-02"), DateTimes.of((String)"1970-01-02"), DateTimes.of((String)"1970-01-03")), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05"), DateTimes.of((String)"1970-01-05"), DateTimes.of((String)"1970-01-10")), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05T01"), DateTimes.of((String)"1970-01-05T01"), DateTimes.of((String)"1970-01-10")));
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).bound("maxTime").randomQueryId().build(), Intervals.of((String)"1970-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-02"), null, DateTimes.of((String)"1970-01-02")), Intervals.of((String)"1970-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-03"), null, DateTimes.of((String)"1970-01-03")), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-10"), null, DateTimes.of((String)"1970-01-10")));
        this.testQueryCaching(this.getDefaultQueryRunner(), (Query)Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)SEG_SPEC).context(CONTEXT).bound("minTime").randomQueryId().build(), Intervals.of((String)"1970-01-01/2011-01-02"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-01"), DateTimes.of((String)"1970-01-01"), null), Intervals.of((String)"1970-01-01/2011-01-03"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-02"), DateTimes.of((String)"1970-01-02"), null), Intervals.of((String)"1970-01-01/1970-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05"), DateTimes.of((String)"1970-01-05"), null), Intervals.of((String)"1970-01-01/2011-01-10"), this.makeTimeBoundaryResult(DateTimes.of((String)"1970-01-05T01"), DateTimes.of((String)"1970-01-05T01"), null));
    }

    @Test
    public void testIfNoneMatch() {
        Interval interval = Intervals.of((String)"2016/2017");
        DataSegment dataSegment = new DataSegment("dataSource", interval, "ver", (Map)ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)"/tmp"), (List)ImmutableList.of((Object)"product"), (List)ImmutableList.of((Object)"visited_sum"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 12334L);
        ServerSelector selector = new ServerSelector(dataSegment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(this.servers[0], null), dataSegment);
        this.timeline.add(interval, (Object)"ver", (PartitionChunk)new SingleElementPartitionChunk((Object)selector));
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)interval))).context((Map)ImmutableMap.of((Object)"If-None-Match", (Object)"aVJV29CJY93rszVW/QBy0arWZo0=")).randomQueryId().build();
        ResponseContext responseContext = CachingClusteredClientTest.initializeResponseContext();
        this.getDefaultQueryRunner().run(QueryPlus.wrap((Query)query), responseContext);
        Assert.assertEquals((Object)"MDs2yIUvYLVzaG6zmwTH1plqaYE=", (Object)responseContext.getEntityTag());
    }

    @Test
    public void testEtagforDifferentQueryInterval() {
        Interval interval = Intervals.of((String)"2016-01-01/2016-01-02");
        Interval queryInterval = Intervals.of((String)"2016-01-01T14:00:00/2016-01-02T14:00:00");
        Interval queryInterval2 = Intervals.of((String)"2016-01-01T18:00:00/2016-01-02T18:00:00");
        DataSegment dataSegment = new DataSegment("dataSource", interval, "ver", (Map)ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)"/tmp"), (List)ImmutableList.of((Object)"product"), (List)ImmutableList.of((Object)"visited_sum"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 12334L);
        ServerSelector selector = new ServerSelector(dataSegment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy()));
        selector.addServerAndUpdateSegment(new QueryableDruidServer(this.servers[0], null), dataSegment);
        this.timeline.add(interval, (Object)"ver", (PartitionChunk)new SingleElementPartitionChunk((Object)selector));
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)queryInterval))).context((Map)ImmutableMap.of((Object)"If-None-Match", (Object)"aVJV29CJY93rszVW/QBy0arWZo0=")).randomQueryId().build();
        TimeBoundaryQuery query2 = Druids.newTimeBoundaryQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)queryInterval2))).context((Map)ImmutableMap.of((Object)"If-None-Match", (Object)"aVJV29CJY93rszVW/QBy0arWZo0=")).randomQueryId().build();
        ResponseContext responseContext = CachingClusteredClientTest.initializeResponseContext();
        this.getDefaultQueryRunner().run(QueryPlus.wrap((Query)query), responseContext);
        String etag1 = responseContext.getEntityTag();
        this.getDefaultQueryRunner().run(QueryPlus.wrap((Query)query2), responseContext);
        String etag2 = responseContext.getEntityTag();
        Assert.assertNotEquals((Object)etag1, (Object)etag2);
    }

    private QueryRunner getDefaultQueryRunner() {
        return new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                return CachingClusteredClientTest.this.client.getQueryRunnerForIntervals(queryPlus.getQuery(), (Iterable)queryPlus.getQuery().getIntervals()).run(queryPlus, responseContext);
            }
        };
    }

    private static ResponseContext initializeResponseContext() {
        ResponseContext context = ResponseContext.createEmpty();
        context.initializeRemainingResponses();
        return context;
    }

    public static class ServerExpectations
    implements Iterable<ServerExpectation> {
        private final DruidServer server;
        private final QueryRunner queryRunner;
        private final List<ServerExpectation> expectations = new ArrayList<ServerExpectation>();

        public ServerExpectations(DruidServer server, QueryRunner queryRunner) {
            this.server = server;
            this.queryRunner = queryRunner;
        }

        public QueryRunner getQueryRunner() {
            return this.queryRunner;
        }

        public void addExpectation(ServerExpectation expectation) {
            this.expectations.add(expectation);
        }

        @Override
        public Iterator<ServerExpectation> iterator() {
            return this.expectations.iterator();
        }
    }

    public static class ServerExpectation<T> {
        private final SegmentId segmentId;
        private final Interval interval;
        private final DataSegment segment;
        private final ShardSpec shardSpec;
        private final Iterable<Result<T>> results;

        public ServerExpectation(SegmentId segmentId, Interval interval, DataSegment segment, ShardSpec shardSpec, Iterable<Result<T>> results) {
            this.segmentId = segmentId;
            this.interval = interval;
            this.segment = segment;
            this.shardSpec = shardSpec;
            this.results = results;
        }

        public SegmentId getSegmentId() {
            return this.segmentId;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public DataSegment getSegment() {
            return new MyDataSegment();
        }

        public Iterable<Result<T>> getResults() {
            return this.results;
        }

        private class MyDataSegment
        extends DataSegment {
            private final DataSegment baseSegment;

            private MyDataSegment() {
                super("", Intervals.utc((long)0L, (long)1L), "", null, null, null, (ShardSpec)NoneShardSpec.instance(), null, 0L);
                this.baseSegment = ServerExpectation.this.segment;
            }

            @JsonProperty
            public String getDataSource() {
                return this.baseSegment.getDataSource();
            }

            @JsonProperty
            public Interval getInterval() {
                return this.baseSegment.getInterval();
            }

            @JsonProperty
            public Map<String, Object> getLoadSpec() {
                return this.baseSegment.getLoadSpec();
            }

            @JsonProperty
            public String getVersion() {
                return "version";
            }

            @JsonSerialize
            @JsonProperty
            public List<String> getDimensions() {
                return this.baseSegment.getDimensions();
            }

            @JsonSerialize
            @JsonProperty
            public List<String> getMetrics() {
                return this.baseSegment.getMetrics();
            }

            @JsonProperty
            public ShardSpec getShardSpec() {
                try {
                    return this.baseSegment.getShardSpec();
                }
                catch (IllegalStateException e) {
                    return NoneShardSpec.instance();
                }
            }

            @JsonProperty
            public long getSize() {
                return this.baseSegment.getSize();
            }

            public SegmentId getId() {
                return ServerExpectation.this.segmentId;
            }

            public SegmentDescriptor toDescriptor() {
                return this.baseSegment.toDescriptor();
            }

            public int compareTo(DataSegment dataSegment) {
                return this.baseSegment.compareTo(dataSegment);
            }

            public boolean equals(Object o) {
                if (!(o instanceof DataSegment)) {
                    return false;
                }
                return this.baseSegment.equals(o);
            }

            public int hashCode() {
                return this.baseSegment.hashCode();
            }

            public String toString() {
                return this.baseSegment.toString();
            }

            public int getStartRootPartitionId() {
                return ServerExpectation.this.shardSpec.getStartRootPartitionId();
            }

            public int getEndRootPartitionId() {
                return ServerExpectation.this.shardSpec.getEndRootPartitionId();
            }

            public short getMinorVersion() {
                return ServerExpectation.this.shardSpec.getMinorVersion();
            }

            public short getAtomicUpdateGroupSize() {
                return ServerExpectation.this.shardSpec.getAtomicUpdateGroupSize();
            }

            public boolean overshadows(DataSegment other) {
                if (this.getDataSource().equals(other.getDataSource()) && this.getInterval().overlaps((ReadableInterval)other.getInterval()) && this.getVersion().equals(other.getVersion())) {
                    return this.getStartRootPartitionId() <= other.getStartRootPartitionId() && this.getEndRootPartitionId() >= other.getEndRootPartitionId() && this.getMinorVersion() > other.getMinorVersion();
                }
                return false;
            }
        }
    }
}

