/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.client.CacheUtil;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class CacheUtilTest {
    private final TimeseriesQuery timeseriesQuery = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals("2000/3000").granularity(Granularities.ALL).build();

    @Test
    public void test_isQueryCacheable_cacheableOnBroker() {
        Assert.assertTrue((boolean)CacheUtil.isQueryCacheable((Query)this.timeseriesQuery, new DummyCacheStrategy(true, true), (CacheConfig)CacheUtilTest.makeCacheConfig((Map<String, Object>)ImmutableMap.of()), (CacheUtil.ServerType)CacheUtil.ServerType.BROKER, (boolean)false));
    }

    @Test
    public void test_isQueryCacheable_cacheableOnDataServer() {
        Assert.assertTrue((boolean)CacheUtil.isQueryCacheable((Query)this.timeseriesQuery, new DummyCacheStrategy(true, true), (CacheConfig)CacheUtilTest.makeCacheConfig((Map<String, Object>)ImmutableMap.of()), (CacheUtil.ServerType)CacheUtil.ServerType.DATA, (boolean)true));
    }

    @Test
    public void test_isQueryCacheable_unCacheableOnBroker() {
        Assert.assertFalse((boolean)CacheUtil.isQueryCacheable((Query)this.timeseriesQuery, new DummyCacheStrategy(false, true), (CacheConfig)CacheUtilTest.makeCacheConfig((Map<String, Object>)ImmutableMap.of()), (CacheUtil.ServerType)CacheUtil.ServerType.BROKER, (boolean)false));
    }

    @Test
    public void test_isQueryCacheable_unCacheableOnDataServer() {
        Assert.assertFalse((boolean)CacheUtil.isQueryCacheable((Query)this.timeseriesQuery, new DummyCacheStrategy(true, false), (CacheConfig)CacheUtilTest.makeCacheConfig((Map<String, Object>)ImmutableMap.of()), (CacheUtil.ServerType)CacheUtil.ServerType.DATA, (boolean)true));
    }

    @Test
    public void test_isQueryCacheable_unCacheableType() {
        Assert.assertFalse((boolean)CacheUtil.isQueryCacheable((Query)this.timeseriesQuery, new DummyCacheStrategy(true, false), (CacheConfig)CacheUtilTest.makeCacheConfig((Map<String, Object>)ImmutableMap.of((Object)"unCacheable", (Object)ImmutableList.of((Object)"timeseries"))), (CacheUtil.ServerType)CacheUtil.ServerType.BROKER, (boolean)false));
    }

    @Test
    public void test_isQueryCacheable_unCacheableDataSourceOnBroker() {
        Assert.assertFalse((boolean)CacheUtil.isQueryCacheable((Query)this.timeseriesQuery.withDataSource((DataSource)new GlobalTableDataSource("global")), new DummyCacheStrategy(true, true), (CacheConfig)CacheUtilTest.makeCacheConfig((Map<String, Object>)ImmutableMap.of()), (CacheUtil.ServerType)CacheUtil.ServerType.BROKER, (boolean)false));
    }

    @Test
    public void test_isQueryCacheable_unCacheableDataSourceOnDataServer() {
        Assert.assertFalse((boolean)CacheUtil.isQueryCacheable((Query)this.timeseriesQuery.withDataSource((DataSource)new LookupDataSource("lookyloo")), new DummyCacheStrategy(true, true), (CacheConfig)CacheUtilTest.makeCacheConfig((Map<String, Object>)ImmutableMap.of()), (CacheUtil.ServerType)CacheUtil.ServerType.DATA, (boolean)true));
    }

    @Test
    public void test_isQueryCacheable_nullCacheStrategy() {
        Assert.assertFalse((boolean)CacheUtil.isQueryCacheable((Query)this.timeseriesQuery, null, (CacheConfig)CacheUtilTest.makeCacheConfig((Map<String, Object>)ImmutableMap.of()), (CacheUtil.ServerType)CacheUtil.ServerType.BROKER, (boolean)false));
    }

    private static CacheConfig makeCacheConfig(Map<String, Object> properties) {
        return (CacheConfig)TestHelper.makeJsonMapper().convertValue(properties, CacheConfig.class);
    }

    private static class DummyCacheStrategy<T, CacheType, QueryType extends Query<T>>
    implements CacheStrategy<T, CacheType, QueryType> {
        private final boolean cacheableOnBrokers;
        private final boolean cacheableOnDataServers;

        public DummyCacheStrategy(boolean cacheableOnBrokers, boolean cacheableOnDataServers) {
            this.cacheableOnBrokers = cacheableOnBrokers;
            this.cacheableOnDataServers = cacheableOnDataServers;
        }

        public boolean isCacheable(QueryType query, boolean willMergeRunners, boolean bySegment) {
            return willMergeRunners ? this.cacheableOnDataServers : this.cacheableOnBrokers;
        }

        public byte[] computeCacheKey(QueryType query) {
            throw new UnsupportedOperationException();
        }

        public byte[] computeResultLevelCacheKey(QueryType query) {
            throw new UnsupportedOperationException();
        }

        public TypeReference<CacheType> getCacheObjectClazz() {
            throw new UnsupportedOperationException();
        }

        public Function<T, CacheType> prepareForCache(boolean isResultLevelCache) {
            throw new UnsupportedOperationException();
        }

        public Function<CacheType, T> pullFromCache(boolean isResultLevelCache) {
            throw new UnsupportedOperationException();
        }
    }
}

