/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.catalog.CatalogTest;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.java.util.common.IAE;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CatalogTest.class})
public class TableMetadataTest {
    @Test
    public void testId() {
        TableId id1 = new TableId("schema", "table");
        Assert.assertEquals((Object)id1, (Object)id1);
        Assert.assertEquals((Object)"schema", (Object)id1.schema());
        Assert.assertEquals((Object)"table", (Object)id1.name());
        Assert.assertEquals((Object)"\"schema\".\"table\"", (Object)id1.sqlName());
        Assert.assertEquals((Object)id1.sqlName(), (Object)id1.toString());
        TableId id2 = TableId.datasource((String)"ds");
        Assert.assertEquals((Object)"druid", (Object)id2.schema());
        Assert.assertEquals((Object)"ds", (Object)id2.name());
    }

    @Test
    public void testIdEquals() {
        EqualsVerifier.forClass(TableId.class).usingGetClass().verify();
    }

    @Test
    public void testTableMetadata() {
        ImmutableMap props = ImmutableMap.of((Object)"segmentGranularity", (Object)"P1D");
        TableSpec spec = new TableSpec("datasource", (Map)props, null);
        TableMetadata table = new TableMetadata(TableId.datasource((String)"foo"), 10L, 20L, TableMetadata.TableState.ACTIVE, spec);
        table.validate();
        Assert.assertEquals((Object)"druid", (Object)table.id().schema());
        Assert.assertEquals((Object)"foo", (Object)table.id().name());
        Assert.assertEquals((long)10L, (long)table.creationTime());
        Assert.assertEquals((long)20L, (long)table.updateTime());
        Assert.assertEquals((Object)TableMetadata.TableState.ACTIVE, (Object)table.state());
        Assert.assertNotNull((Object)table.spec());
        table = TableMetadata.newTable((TableId)TableId.of(null, (String)"foo"), (TableSpec)spec);
        Assert.assertThrows(IAE.class, () -> table.validate());
        table = TableMetadata.newTable((TableId)TableId.of((String)"druid", null), (TableSpec)spec);
        Assert.assertThrows(IAE.class, () -> table.validate());
    }

    @Test
    public void testConversions() {
        ImmutableMap props = ImmutableMap.of((Object)"segmentGranularity", (Object)"P1D");
        TableSpec spec = new TableSpec("datasource", (Map)props, null);
        TableMetadata table = TableMetadata.newTable((TableId)TableId.datasource((String)"ds"), (TableSpec)spec);
        Assert.assertEquals((Object)TableId.datasource((String)"ds"), (Object)table.id());
        Assert.assertEquals((Object)TableMetadata.TableState.ACTIVE, (Object)table.state());
        Assert.assertEquals((long)0L, (long)table.updateTime());
        Assert.assertSame((Object)spec, (Object)table.spec());
        TableMetadata table2 = TableMetadata.newTable((TableId)TableId.datasource((String)"ds"), (TableSpec)spec);
        Assert.assertEquals((Object)table, (Object)table2);
        TableMetadata table3 = table2.fromInsert(10L);
        Assert.assertEquals((long)10L, (long)table3.creationTime());
        Assert.assertEquals((long)10L, (long)table3.updateTime());
        table3 = table3.asUpdate(20L);
        Assert.assertEquals((long)10L, (long)table3.creationTime());
        Assert.assertEquals((long)20L, (long)table3.updateTime());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(TableMetadata.class).usingGetClass().verify();
    }
}

