/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.guava.Comparators;

public class LookupExtractorFactoryMapContainer {
    private final String version;
    private final Map<String, Object> lookupExtractorFactory;

    @JsonCreator
    public LookupExtractorFactoryMapContainer(@JsonProperty(value="version") String version, @JsonProperty(value="lookupExtractorFactory") Map<String, Object> lookupExtractorFactory) {
        this.version = version;
        this.lookupExtractorFactory = (Map)Preconditions.checkNotNull(lookupExtractorFactory, (Object)"null factory");
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public Map<String, Object> getLookupExtractorFactory() {
        return this.lookupExtractorFactory;
    }

    public boolean replaces(LookupExtractorFactoryMapContainer other) {
        if (this.version == null && other.getVersion() == null) {
            return false;
        }
        return Comparators.naturalNullsFirst().compare((Object)this.version, (Object)other.getVersion()) > 0;
    }

    public String toString() {
        return "LookupExtractorFactoryContainer{version='" + this.version + '\'' + ", lookupExtractorFactory=" + this.lookupExtractorFactory + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupExtractorFactoryMapContainer that = (LookupExtractorFactoryMapContainer)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.lookupExtractorFactory, that.lookupExtractorFactory);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.lookupExtractorFactory);
    }
}

