/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.rules.BroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;

public class UnloadUnusedSegments
implements CoordinatorDuty {
    private static final Logger log = new Logger(UnloadUnusedSegments.class);

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        TreeSet<DataSegment> usedSegments = params.getUsedSegments();
        DruidCluster cluster = params.getDruidCluster();
        HashMap<String, Boolean> broadcastStatusByDatasource = new HashMap<String, Boolean>();
        for (String string : params.getBroadcastDatasources()) {
            broadcastStatusByDatasource.put(string, true);
        }
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                this.handleUnusedSegmentsForServer(serverHolder, usedSegments, params, stats, false, broadcastStatusByDatasource);
            }
        }
        for (ServerHolder serverHolder : cluster.getBrokers()) {
            this.handleUnusedSegmentsForServer(serverHolder, usedSegments, params, stats, false, broadcastStatusByDatasource);
        }
        for (ServerHolder serverHolder : cluster.getRealtimes()) {
            this.handleUnusedSegmentsForServer(serverHolder, usedSegments, params, stats, true, broadcastStatusByDatasource);
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }

    private void handleUnusedSegmentsForServer(ServerHolder serverHolder, Set<DataSegment> usedSegments, DruidCoordinatorRuntimeParams params, CoordinatorStats stats, boolean dropBroadcastOnly, Map<String, Boolean> broadcastStatusByDatasource) {
        ImmutableDruidServer server = serverHolder.getServer();
        for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
            boolean isBroadcastDatasource = broadcastStatusByDatasource.computeIfAbsent(dataSource.getName(), dataSourceName -> {
                List<Rule> rules = params.getDatabaseRuleManager().getRulesWithDefault(dataSource.getName());
                for (Rule rule : rules) {
                    if (!(rule instanceof BroadcastDistributionRule)) continue;
                    return true;
                }
                return false;
            });
            if (dropBroadcastOnly && !isBroadcastDatasource) continue;
            for (DataSegment segment : dataSource.getSegments()) {
                LoadQueuePeon queuePeon;
                if (usedSegments.contains(segment) || (queuePeon = params.getLoadManagementPeons().get(server.getName())).getSegmentsToDrop().contains(segment)) continue;
                queuePeon.dropSegment(segment, success -> {});
                stats.addToTieredStat("unneededCount", server.getTier(), 1L);
                log.info("Dropping uneeded segment [%s] from server [%s] in tier [%s]", new Object[]{segment.getId(), server.getName(), server.getTier()});
            }
        }
    }
}

