/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ReplicationThrottler;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.rules.BroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;

public class RunRules
implements CoordinatorDuty {
    private static final EmittingLogger log = new EmittingLogger(RunRules.class);
    private static final int MAX_MISSING_RULES = 10;
    private final ReplicationThrottler replicatorThrottler;
    private final DruidCoordinator coordinator;

    public RunRules(DruidCoordinator coordinator) {
        this(new ReplicationThrottler(coordinator.getDynamicConfigs().getReplicationThrottleLimit(), coordinator.getDynamicConfigs().getReplicantLifetime(), false), coordinator);
    }

    public RunRules(ReplicationThrottler replicatorThrottler, DruidCoordinator coordinator) {
        this.replicatorThrottler = replicatorThrottler;
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        List<Rule> rules;
        this.replicatorThrottler.updateParams(this.coordinator.getDynamicConfigs().getReplicationThrottleLimit(), this.coordinator.getDynamicConfigs().getReplicantLifetime(), false);
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        if (cluster.isEmpty()) {
            log.warn("Uh... I have no servers. Not assigning anything...", new Object[0]);
            return params;
        }
        ImmutableSet<DataSegment> overshadowed = params.getDataSourcesSnapshot().getOvershadowedSegments();
        for (String tier : cluster.getTierNames()) {
            this.replicatorThrottler.updateReplicationState(tier);
        }
        DruidCoordinatorRuntimeParams paramsWithReplicationManager = params.buildFromExistingWithoutSegmentsMetadata().withReplicationManager(this.replicatorThrottler).build();
        DateTime now = DateTimes.nowUtc();
        MetadataRuleManager databaseRuleManager = paramsWithReplicationManager.getDatabaseRuleManager();
        ArrayList segmentsWithMissingRules = Lists.newArrayListWithCapacity((int)10);
        int missingRules = 0;
        HashSet<String> broadcastDatasources = new HashSet<String>();
        block1: for (ImmutableDruidDataSource dataSource : params.getDataSourcesSnapshot().getDataSourcesMap().values()) {
            rules = databaseRuleManager.getRulesWithDefault(dataSource.getName());
            for (Rule rule : rules) {
                if (!(rule instanceof BroadcastDistributionRule)) continue;
                broadcastDatasources.add(dataSource.getName());
                continue block1;
            }
        }
        for (DataSegment segment : params.getUsedSegments()) {
            if (overshadowed.contains(segment)) continue;
            rules = databaseRuleManager.getRulesWithDefault(segment.getDataSource());
            boolean foundMatchingRule = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                if (stats.getGlobalStat("totalNonPrimaryReplicantsLoaded") >= (long)paramsWithReplicationManager.getCoordinatorDynamicConfig().getMaxNonPrimaryReplicantsToLoad() && !paramsWithReplicationManager.getReplicationManager().isLoadPrimaryReplicantsOnly()) {
                    log.info("Maximum number of non-primary replicants [%d] have been loaded for the current RunRules execution. Only loading primary replicants from here on for this coordinator run cycle.", new Object[]{paramsWithReplicationManager.getCoordinatorDynamicConfig().getMaxNonPrimaryReplicantsToLoad()});
                    paramsWithReplicationManager.getReplicationManager().setLoadPrimaryReplicantsOnly(true);
                }
                stats.accumulate(rule.run(this.coordinator, paramsWithReplicationManager, segment));
                foundMatchingRule = true;
                break;
            }
            if (foundMatchingRule) continue;
            if (segmentsWithMissingRules.size() < 10) {
                segmentsWithMissingRules.add(segment.getId());
            }
            ++missingRules;
        }
        if (!segmentsWithMissingRules.isEmpty()) {
            log.makeAlert("Unable to find matching rules!", new Object[0]).addData("segmentsWithMissingRulesCount", (Object)missingRules).addData("segmentsWithMissingRules", (Object)segmentsWithMissingRules).emit();
        }
        return params.buildFromExisting().withCoordinatorStats(stats).withBroadcastDatasources(broadcastDatasources).build();
    }
}

