/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.timeline.DataSegment;

public class LogUsedSegments
implements CoordinatorDuty {
    private static final EmittingLogger log = new EmittingLogger(LogUsedSegments.class);

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        log.debug("Starting coordination. Getting used segments.", new Object[0]);
        if (log.isDebugEnabled()) {
            DataSourcesSnapshot dataSourcesSnapshot = params.getDataSourcesSnapshot();
            log.debug("Used Segments", new Object[0]);
            for (DataSegment dataSegment : dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()) {
                log.debug("  %s", new Object[]{dataSegment});
            }
        }
        log.info("Found [%,d] used segments.", new Object[]{params.getUsedSegments().size()});
        return params;
    }
}

