/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;

public class KillRules
implements CoordinatorDuty {
    private static final Logger log = new Logger(KillRules.class);
    private final long period;
    private final long retainDuration;
    private long lastKillTime = 0L;

    @Inject
    public KillRules(DruidCoordinatorConfig config) {
        this.period = config.getCoordinatorRuleKillPeriod().getMillis();
        Preconditions.checkArgument((this.period >= config.getCoordinatorMetadataStoreManagementPeriod().getMillis() ? 1 : 0) != 0, (Object)"coordinator rule kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.retainDuration = config.getCoordinatorRuleKillDurationToRetain().getMillis();
        Preconditions.checkArgument((this.retainDuration >= 0L ? 1 : 0) != 0, (Object)"coordinator rule kill retainDuration must be >= 0");
        Preconditions.checkArgument((this.retainDuration < System.currentTimeMillis() ? 1 : 0) != 0, (Object)"Coordinator rule kill retainDuration cannot be greater than current time in ms");
        log.debug("Rule Kill Task scheduling enabled with period [%s], retainDuration [%s]", new Object[]{this.period, this.retainDuration});
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastKillTime + this.period < currentTimeMillis) {
            this.lastKillTime = currentTimeMillis;
            long timestamp = currentTimeMillis - this.retainDuration;
            try {
                int ruleRemoved = params.getDatabaseRuleManager().removeRulesForEmptyDatasourcesOlderThan(timestamp);
                ServiceEmitter emitter = params.getEmitter();
                emitter.emit(new ServiceMetricEvent.Builder().build("metadata/kill/rule/count", (Number)ruleRemoved));
                log.info("Finished running KillRules duty. Removed %,d rule", new Object[]{ruleRemoved});
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to kill rules metadata", new Object[0]);
            }
        }
        return params;
    }
}

