/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskTransformConfig;
import org.joda.time.Period;

public class DataSourceCompactionConfig {
    public static final int DEFAULT_COMPACTION_TASK_PRIORITY = 25;
    private static final long DEFAULT_INPUT_SEGMENT_SIZE_BYTES = 100000000000000L;
    private static final Period DEFAULT_SKIP_OFFSET_FROM_LATEST = new Period((Object)"P1D");
    private final String dataSource;
    private final int taskPriority;
    private final long inputSegmentSizeBytes;
    @Nullable
    private final Integer maxRowsPerSegment;
    private final Period skipOffsetFromLatest;
    private final UserCompactionTaskQueryTuningConfig tuningConfig;
    private final UserCompactionTaskGranularityConfig granularitySpec;
    private final UserCompactionTaskDimensionsConfig dimensionsSpec;
    private final AggregatorFactory[] metricsSpec;
    private final UserCompactionTaskTransformConfig transformSpec;
    private final UserCompactionTaskIOConfig ioConfig;
    private final Map<String, Object> taskContext;

    @JsonCreator
    public DataSourceCompactionConfig(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="taskPriority") @Nullable Integer taskPriority, @JsonProperty(value="inputSegmentSizeBytes") @Nullable Long inputSegmentSizeBytes, @JsonProperty(value="maxRowsPerSegment") @Deprecated @Nullable Integer maxRowsPerSegment, @JsonProperty(value="skipOffsetFromLatest") @Nullable Period skipOffsetFromLatest, @JsonProperty(value="tuningConfig") @Nullable UserCompactionTaskQueryTuningConfig tuningConfig, @JsonProperty(value="granularitySpec") @Nullable UserCompactionTaskGranularityConfig granularitySpec, @JsonProperty(value="dimensionsSpec") @Nullable UserCompactionTaskDimensionsConfig dimensionsSpec, @JsonProperty(value="metricsSpec") @Nullable AggregatorFactory[] metricsSpec, @JsonProperty(value="transformSpec") @Nullable UserCompactionTaskTransformConfig transformSpec, @JsonProperty(value="ioConfig") @Nullable UserCompactionTaskIOConfig ioConfig, @JsonProperty(value="taskContext") @Nullable Map<String, Object> taskContext) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.taskPriority = taskPriority == null ? 25 : taskPriority;
        this.inputSegmentSizeBytes = inputSegmentSizeBytes == null ? 100000000000000L : inputSegmentSizeBytes;
        this.maxRowsPerSegment = maxRowsPerSegment;
        this.skipOffsetFromLatest = skipOffsetFromLatest == null ? DEFAULT_SKIP_OFFSET_FROM_LATEST : skipOffsetFromLatest;
        this.tuningConfig = tuningConfig;
        this.ioConfig = ioConfig;
        this.granularitySpec = granularitySpec;
        this.metricsSpec = metricsSpec;
        this.dimensionsSpec = dimensionsSpec;
        this.transformSpec = transformSpec;
        this.taskContext = taskContext;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public int getTaskPriority() {
        return this.taskPriority;
    }

    @JsonProperty
    public long getInputSegmentSizeBytes() {
        return this.inputSegmentSizeBytes;
    }

    @Deprecated
    @JsonProperty
    @Nullable
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    public Period getSkipOffsetFromLatest() {
        return this.skipOffsetFromLatest;
    }

    @JsonProperty
    @Nullable
    public UserCompactionTaskQueryTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    @Nullable
    public UserCompactionTaskIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @JsonProperty
    @Nullable
    public UserCompactionTaskGranularityConfig getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    @Nullable
    public UserCompactionTaskDimensionsConfig getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty
    @Nullable
    public UserCompactionTaskTransformConfig getTransformSpec() {
        return this.transformSpec;
    }

    @JsonProperty
    @Nullable
    public AggregatorFactory[] getMetricsSpec() {
        return this.metricsSpec;
    }

    @JsonProperty
    @Nullable
    public Map<String, Object> getTaskContext() {
        return this.taskContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceCompactionConfig that = (DataSourceCompactionConfig)o;
        return this.taskPriority == that.taskPriority && this.inputSegmentSizeBytes == that.inputSegmentSizeBytes && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.skipOffsetFromLatest, that.skipOffsetFromLatest) && Objects.equals(this.tuningConfig, that.tuningConfig) && Objects.equals(this.granularitySpec, that.granularitySpec) && Objects.equals(this.dimensionsSpec, that.dimensionsSpec) && Arrays.equals(this.metricsSpec, that.metricsSpec) && Objects.equals(this.transformSpec, that.transformSpec) && Objects.equals(this.ioConfig, that.ioConfig) && Objects.equals(this.taskContext, that.taskContext);
    }

    public int hashCode() {
        int result = Objects.hash(this.dataSource, this.taskPriority, this.inputSegmentSizeBytes, this.maxRowsPerSegment, this.skipOffsetFromLatest, this.tuningConfig, this.granularitySpec, this.dimensionsSpec, this.transformSpec, this.ioConfig, this.taskContext);
        result = 31 * result + Arrays.hashCode(this.metricsSpec);
        return result;
    }
}

