/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FluentQueryRunnerBuilder;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.PostProcessingOperator;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.ResultLevelCachingQueryRunner;
import org.apache.druid.query.RetryQueryRunner;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.server.LocalQuerySegmentWalker;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.initialization.ServerConfig;
import org.joda.time.Interval;

public class ClientQuerySegmentWalker
implements QuerySegmentWalker {
    private final ServiceEmitter emitter;
    private final QuerySegmentWalker clusterClient;
    private final QuerySegmentWalker localClient;
    private final QueryToolChestWarehouse warehouse;
    private final JoinableFactory joinableFactory;
    private final RetryQueryRunnerConfig retryConfig;
    private final ObjectMapper objectMapper;
    private final ServerConfig serverConfig;
    private final Cache cache;
    private final CacheConfig cacheConfig;

    public ClientQuerySegmentWalker(ServiceEmitter emitter, QuerySegmentWalker clusterClient, QuerySegmentWalker localClient, QueryToolChestWarehouse warehouse, JoinableFactory joinableFactory, RetryQueryRunnerConfig retryConfig, ObjectMapper objectMapper, ServerConfig serverConfig, Cache cache, CacheConfig cacheConfig) {
        this.emitter = emitter;
        this.clusterClient = clusterClient;
        this.localClient = localClient;
        this.warehouse = warehouse;
        this.joinableFactory = joinableFactory;
        this.retryConfig = retryConfig;
        this.objectMapper = objectMapper;
        this.serverConfig = serverConfig;
        this.cache = cache;
        this.cacheConfig = cacheConfig;
    }

    @Inject
    ClientQuerySegmentWalker(ServiceEmitter emitter, CachingClusteredClient clusterClient, LocalQuerySegmentWalker localClient, QueryToolChestWarehouse warehouse, JoinableFactory joinableFactory, RetryQueryRunnerConfig retryConfig, ObjectMapper objectMapper, ServerConfig serverConfig, Cache cache, CacheConfig cacheConfig) {
        this(emitter, (QuerySegmentWalker)clusterClient, (QuerySegmentWalker)localClient, warehouse, joinableFactory, retryConfig, objectMapper, serverConfig, cache, cacheConfig);
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        int maxSubqueryRows;
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        Query newQuery = query.withDataSource(this.generateSubqueryIds(query.getDataSource(), query.getId(), query.getSqlQueryId()));
        DataSource freeTradeDataSource = this.globalizeIfPossible(newQuery.getDataSource());
        DataSource inlineDryRun = this.inlineIfNecessary(freeTradeDataSource, toolChest, new AtomicInteger(), maxSubqueryRows = query.context().getMaxSubqueryRows(this.serverConfig.getMaxSubqueryRows()), true);
        if (!this.canRunQueryUsingClusterWalker(query.withDataSource(inlineDryRun)) && !this.canRunQueryUsingLocalWalker(query.withDataSource(inlineDryRun))) {
            throw new ISE("Cannot handle subquery structure for dataSource: %s", new Object[]{query.getDataSource()});
        }
        if (this.canRunQueryUsingLocalWalker(newQuery = newQuery.withDataSource(this.inlineIfNecessary(freeTradeDataSource, toolChest, new AtomicInteger(), maxSubqueryRows, false)))) {
            return new QuerySwappingQueryRunner<T>(this.localClient.getQueryRunnerForIntervals(newQuery, intervals), query, newQuery);
        }
        if (this.canRunQueryUsingClusterWalker(newQuery)) {
            return new QuerySwappingQueryRunner<T>(this.decorateClusterRunner(newQuery, this.clusterClient.getQueryRunnerForIntervals(newQuery, intervals)), query, newQuery);
        }
        throw new ISE("Inlined query could not be run", new Object[0]);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        Query freeTradeQuery = query.withDataSource(this.globalizeIfPossible(query.getDataSource()));
        if (this.canRunQueryUsingClusterWalker(query)) {
            return new QuerySwappingQueryRunner<T>(this.decorateClusterRunner(freeTradeQuery, this.clusterClient.getQueryRunnerForSegments(freeTradeQuery, specs)), query, freeTradeQuery);
        }
        throw new ISE("Cannot run query on specific segments (must be table-based; outer query, if present, must be handleable by the query toolchest natively)", new Object[0]);
    }

    private <T> boolean canRunQueryUsingLocalWalker(Query<T> query) {
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)query.getDataSource());
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        return analysis.isConcreteBased() && !analysis.isConcreteTableBased() && analysis.isGlobal() && (!analysis.isQuery() || toolChest.canPerformSubquery(((QueryDataSource)analysis.getDataSource()).getQuery()));
    }

    private <T> boolean canRunQueryUsingClusterWalker(Query<T> query) {
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)query.getDataSource());
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        return analysis.isConcreteTableBased() && (!analysis.isQuery() || toolChest.canPerformSubquery(((QueryDataSource)analysis.getDataSource()).getQuery()));
    }

    private DataSource globalizeIfPossible(DataSource dataSource) {
        if (dataSource instanceof TableDataSource) {
            GlobalTableDataSource maybeGlobal = new GlobalTableDataSource(((TableDataSource)dataSource).getName());
            if (this.joinableFactory.isDirectlyJoinable((DataSource)maybeGlobal)) {
                return maybeGlobal;
            }
            return dataSource;
        }
        List currentChildren = dataSource.getChildren();
        ArrayList<DataSource> newChildren = new ArrayList<DataSource>(currentChildren.size());
        for (DataSource child : currentChildren) {
            newChildren.add(this.globalizeIfPossible(child));
        }
        return dataSource.withChildren(newChildren);
    }

    private DataSource inlineIfNecessary(DataSource dataSource, @Nullable QueryToolChest toolChestIfOutermost, AtomicInteger subqueryRowLimitAccumulator, int maxSubqueryRows, boolean dryRun) {
        if (dataSource instanceof QueryDataSource) {
            Query subQuery = ((QueryDataSource)dataSource).getQuery();
            QueryToolChest toolChest = this.warehouse.getToolChest(subQuery);
            if (toolChestIfOutermost != null && toolChestIfOutermost.canPerformSubquery(subQuery)) {
                Stack<DataSource> stack = new Stack<DataSource>();
                DataSource current = dataSource;
                while (current instanceof QueryDataSource) {
                    stack.push(current);
                    current = (DataSource)Iterables.getOnlyElement((Iterable)current.getChildren());
                }
                assert (!(current instanceof QueryDataSource));
                current = this.inlineIfNecessary(current, null, subqueryRowLimitAccumulator, maxSubqueryRows, dryRun);
                while (!stack.isEmpty()) {
                    current = ((DataSource)stack.pop()).withChildren(Collections.singletonList(current));
                }
                assert (current instanceof QueryDataSource);
                if (toolChest.canPerformSubquery(((QueryDataSource)current).getQuery())) {
                    return current;
                }
                return this.inlineIfNecessary(current, toolChestIfOutermost, subqueryRowLimitAccumulator, maxSubqueryRows, dryRun);
            }
            if (this.canRunQueryUsingLocalWalker(subQuery) || this.canRunQueryUsingClusterWalker(subQuery)) {
                Sequence queryResults;
                if (dryRun) {
                    queryResults = Sequences.empty();
                } else {
                    QueryRunner subqueryRunner = subQuery.getRunner((QuerySegmentWalker)this);
                    queryResults = subqueryRunner.run(QueryPlus.wrap((Query)subQuery), (ResponseContext)DirectDruidClient.makeResponseContextForQuery());
                }
                return ClientQuerySegmentWalker.toInlineDataSource(subQuery, queryResults, this.warehouse.getToolChest(subQuery), subqueryRowLimitAccumulator, maxSubqueryRows);
            }
            return this.inlineIfNecessary(dataSource.withChildren(Collections.singletonList(this.inlineIfNecessary((DataSource)Iterables.getOnlyElement((Iterable)dataSource.getChildren()), null, subqueryRowLimitAccumulator, maxSubqueryRows, dryRun))), toolChestIfOutermost, subqueryRowLimitAccumulator, maxSubqueryRows, dryRun);
        }
        return dataSource.withChildren(dataSource.getChildren().stream().map(child -> this.inlineIfNecessary((DataSource)child, null, subqueryRowLimitAccumulator, maxSubqueryRows, dryRun)).collect(Collectors.toList()));
    }

    private <T> QueryRunner<T> decorateClusterRunner(Query<T> query, QueryRunner<T> baseClusterRunner) {
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        return new FluentQueryRunnerBuilder(toolChest).create(new SetAndVerifyContextQueryRunner<T>(this.serverConfig, new RetryQueryRunner<T>(baseClusterRunner, (arg_0, arg_1) -> ((QuerySegmentWalker)this.clusterClient).getQueryRunnerForSegments(arg_0, arg_1), this.retryConfig, this.objectMapper))).applyPreMergeDecoration().mergeResults().applyPostMergeDecoration().emitCPUTimeMetric(this.emitter).postProcess((PostProcessingOperator)this.objectMapper.convertValue((Object)query.context().getString("postProcessing"), new TypeReference<PostProcessingOperator<T>>(){})).map(runner -> new ResultLevelCachingQueryRunner((QueryRunner)runner, toolChest, query, this.objectMapper, this.cache, this.cacheConfig));
    }

    private DataSource generateSubqueryIds(DataSource rootDataSource, @Nullable String parentQueryId, @Nullable String parentSqlQueryId) {
        ArrayDeque<DataSource> queue = new ArrayDeque<DataSource>();
        queue.add(rootDataSource);
        HashMap<QueryDataSource, Pair<Integer, Integer>> queryDataSourceToSubqueryIds = new HashMap<QueryDataSource, Pair<Integer, Integer>>();
        int level = 1;
        while (!queue.isEmpty()) {
            int size = queue.size();
            int siblingOrder = 1;
            for (int i = 0; i < size; ++i) {
                DataSource currentDataSource = (DataSource)queue.poll();
                if (currentDataSource == null) continue;
                if (currentDataSource instanceof QueryDataSource) {
                    queryDataSourceToSubqueryIds.put((QueryDataSource)currentDataSource, (Pair<Integer, Integer>)new Pair((Object)level, (Object)siblingOrder));
                    ++siblingOrder;
                }
                queue.addAll(currentDataSource.getChildren());
            }
            ++level;
        }
        return this.insertSubqueryIds(rootDataSource, queryDataSourceToSubqueryIds, parentQueryId, parentSqlQueryId);
    }

    private DataSource insertSubqueryIds(DataSource currentDataSource, Map<QueryDataSource, Pair<Integer, Integer>> queryDataSourceToSubqueryIds, @Nullable String parentQueryId, @Nullable String parentSqlQueryId) {
        if (currentDataSource instanceof QueryDataSource && queryDataSourceToSubqueryIds.containsKey((QueryDataSource)currentDataSource)) {
            QueryDataSource queryDataSource = (QueryDataSource)currentDataSource;
            Pair<Integer, Integer> nestingInfo = queryDataSourceToSubqueryIds.get(queryDataSource);
            String subQueryId = nestingInfo.lhs + "." + nestingInfo.rhs;
            Query query = queryDataSource.getQuery();
            if (StringUtils.isEmpty((String)query.getSubQueryId())) {
                query = query.withSubQueryId(subQueryId);
            }
            if (StringUtils.isEmpty((String)query.getId()) && StringUtils.isNotEmpty((String)parentQueryId)) {
                query = query.withId(parentQueryId);
            }
            if (StringUtils.isEmpty((String)query.getSqlQueryId()) && StringUtils.isNotEmpty((String)parentSqlQueryId)) {
                query = query.withSqlQueryId(parentSqlQueryId);
            }
            currentDataSource = new QueryDataSource(query);
        }
        return currentDataSource.withChildren(currentDataSource.getChildren().stream().map(childDataSource -> this.insertSubqueryIds((DataSource)childDataSource, queryDataSourceToSubqueryIds, parentQueryId, parentSqlQueryId)).collect(Collectors.toList()));
    }

    private static <T, QueryType extends Query<T>> InlineDataSource toInlineDataSource(QueryType query, Sequence<T> results, QueryToolChest<T, QueryType> toolChest, AtomicInteger limitAccumulator, int limit) {
        int limitToUse;
        int n = limitToUse = limit < 0 ? Integer.MAX_VALUE : limit;
        if (limitAccumulator.get() >= limitToUse) {
            throw ResourceLimitExceededException.withMessage((String)"Cannot issue subquery, maximum[%d] reached", (Object[])new Object[]{limitToUse});
        }
        RowSignature signature = toolChest.resultArraySignature(query);
        ArrayList resultList = new ArrayList();
        toolChest.resultsAsArrays(query, results).accumulate(resultList, (acc, in) -> {
            if (limitAccumulator.getAndIncrement() >= limitToUse) {
                throw ResourceLimitExceededException.withMessage((String)"Subquery generated results beyond maximum[%d]", (Object[])new Object[]{limitToUse});
            }
            acc.add(in);
            return acc;
        });
        return InlineDataSource.fromIterable(resultList, (RowSignature)signature);
    }

    private static class QuerySwappingQueryRunner<T>
    implements QueryRunner<T> {
        private final QueryRunner<T> baseRunner;
        private final Query<T> query;
        private final Query<T> newQuery;

        public QuerySwappingQueryRunner(QueryRunner<T> baseRunner, Query<T> query, Query<T> newQuery) {
            this.baseRunner = baseRunner;
            this.query = query;
            this.newQuery = newQuery;
        }

        public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            if (queryPlus.getQuery() != this.query) {
                throw new ISE("Unexpected query received", new Object[0]);
            }
            return this.baseRunner.run(queryPlus.withQuery(this.newQuery), responseContext);
        }
    }
}

