/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.indexing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class OverlordClientImpl
implements OverlordClient {
    private final ServiceClient client;
    private final ObjectMapper jsonMapper;

    public OverlordClientImpl(ServiceClient client, ObjectMapper jsonMapper) {
        this.client = (ServiceClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
    }

    @Override
    public ListenableFuture<Void> runTask(String taskId, Object taskObject) {
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/task").jsonContent(this.jsonMapper, taskObject), new BytesFullResponseHandler()), holder -> {
            Map map = (Map)this.deserialize((BytesFullResponseHolder)holder, (TypeReference)JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String returnedTaskId = (String)map.get("task");
            Preconditions.checkState((boolean)taskId.equals(returnedTaskId), (String)"Got a different taskId[%s]. Expected taskId[%s]", (Object[])new Object[]{returnedTaskId, taskId});
            return null;
        });
    }

    @Override
    public ListenableFuture<Void> cancelTask(String taskId) {
        String path = StringUtils.format((String)"/druid/indexer/v1/task/%s/shutdown", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)});
        return this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, path), IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/taskStatus").jsonContent(this.jsonMapper, taskIds), new BytesFullResponseHandler()), holder -> this.deserialize((BytesFullResponseHolder)holder, (TypeReference)new TypeReference<Map<String, TaskStatus>>(){}));
    }

    @Override
    public ListenableFuture<TaskStatusResponse> taskStatus(String taskId) {
        String path = StringUtils.format((String)"/druid/indexer/v1/task/%s/status", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler()), holder -> this.deserialize((BytesFullResponseHolder)holder, (Class)TaskStatusResponse.class));
    }

    @Override
    public ListenableFuture<Map<String, Object>> taskReportAsMap(String taskId) {
        String path = StringUtils.format((String)"/druid/indexer/v1/task/%s/reports", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler()), holder -> (Map)this.deserialize((BytesFullResponseHolder)holder, (TypeReference)JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
    }

    @Override
    public OverlordClientImpl withRetryPolicy(ServiceRetryPolicy retryPolicy) {
        return new OverlordClientImpl(this.client.withRetryPolicy(retryPolicy), this.jsonMapper);
    }

    private <T> T deserialize(BytesFullResponseHolder bytesHolder, Class<T> clazz) {
        try {
            return (T)this.jsonMapper.readValue(bytesHolder.getContent(), clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T deserialize(BytesFullResponseHolder bytesHolder, TypeReference<T> typeReference) {
        try {
            return (T)this.jsonMapper.readValue(bytesHolder.getContent(), typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

