/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.server.DruidNode;

public class ServiceLocation {
    private final String host;
    private final int plaintextPort;
    private final int tlsPort;
    private final String basePath;

    public ServiceLocation(String host, int plaintextPort, int tlsPort, String basePath) {
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
        this.plaintextPort = plaintextPort;
        this.tlsPort = tlsPort;
        this.basePath = (String)Preconditions.checkNotNull((Object)basePath, (Object)"basePath");
    }

    public static ServiceLocation fromDruidNode(DruidNode druidNode) {
        return new ServiceLocation(druidNode.getHost(), druidNode.getPlaintextPort(), druidNode.getTlsPort(), "");
    }

    public String getHost() {
        return this.host;
    }

    public int getPlaintextPort() {
        return this.plaintextPort;
    }

    public int getTlsPort() {
        return this.tlsPort;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLocation that = (ServiceLocation)o;
        return this.plaintextPort == that.plaintextPort && this.tlsPort == that.tlsPort && Objects.equals(this.host, that.host) && Objects.equals(this.basePath, that.basePath);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.plaintextPort, this.tlsPort, this.basePath);
    }

    public String toString() {
        return "ServiceLocation{host='" + this.host + '\'' + ", plaintextPort=" + this.plaintextPort + ", tlsPort=" + this.tlsPort + ", basePath='" + this.basePath + '\'' + '}';
    }
}

