/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheStats;
import org.apache.druid.client.cache.CaffeineCacheConfig;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.utils.JvmUtils;

public class CaffeineCache
implements Cache {
    private static final Logger log = new Logger(CaffeineCache.class);
    private static final int FIXED_COST = 8;
    private static final int MAX_DEFAULT_BYTES = 0x40000000;
    private static final LZ4Factory LZ4_FACTORY = LZ4Factory.fastestInstance();
    private static final LZ4FastDecompressor LZ4_DECOMPRESSOR = LZ4_FACTORY.fastDecompressor();
    private static final LZ4Compressor LZ4_COMPRESSOR = LZ4_FACTORY.fastCompressor();
    private final com.github.benmanes.caffeine.cache.Cache<Cache.NamedKey, byte[]> cache;
    private final AtomicReference<com.github.benmanes.caffeine.cache.stats.CacheStats> priorStats = new AtomicReference<com.github.benmanes.caffeine.cache.stats.CacheStats>(com.github.benmanes.caffeine.cache.stats.CacheStats.empty());
    private final CaffeineCacheConfig config;

    public static CaffeineCache create(CaffeineCacheConfig config) {
        return CaffeineCache.create(config, config.createExecutor());
    }

    public static CaffeineCache create(CaffeineCacheConfig config, Executor executor) {
        Caffeine builder = Caffeine.newBuilder().recordStats();
        if (config.getExpireAfter() >= 0L) {
            builder.expireAfterAccess(config.getExpireAfter(), TimeUnit.MILLISECONDS);
        }
        if (config.getSizeInBytes() >= 0L) {
            builder.maximumWeight(config.getSizeInBytes());
        } else {
            builder.maximumWeight(Math.min(0x40000000L, JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes() / 20L));
        }
        builder.weigher((key, value) -> ((byte[])value).length + key.key.length + key.namespace.length() * 2 + 8).executor(executor);
        return new CaffeineCache((com.github.benmanes.caffeine.cache.Cache<Cache.NamedKey, byte[]>)builder.build(), config);
    }

    private CaffeineCache(com.github.benmanes.caffeine.cache.Cache<Cache.NamedKey, byte[]> cache, CaffeineCacheConfig config) {
        this.cache = cache;
        this.config = config;
    }

    @Override
    public byte[] get(Cache.NamedKey key) {
        return this.deserialize((byte[])this.cache.getIfPresent((Object)key));
    }

    @Override
    public void put(Cache.NamedKey key, byte[] value) {
        this.cache.put((Object)key, (Object)this.serialize(value));
    }

    @Override
    public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)this.cache.getAllPresent(keys), this::deserialize));
    }

    @Override
    public void close(String namespace) {
        if (this.config.isEvictOnClose()) {
            this.cache.asMap().keySet().removeIf(key -> key.namespace.equals(namespace));
        }
    }

    @Override
    @LifecycleStop
    public void close() {
        this.cache.cleanUp();
    }

    @Override
    public CacheStats getStats() {
        com.github.benmanes.caffeine.cache.stats.CacheStats stats = this.cache.stats();
        long size = this.cache.policy().eviction().map(eviction -> eviction.isWeighted() ? eviction.weightedSize() : OptionalLong.empty()).orElse(OptionalLong.empty()).orElse(-1L);
        return new CacheStats(stats.hitCount(), stats.missCount(), this.cache.estimatedSize(), size, stats.evictionCount(), 0L, stats.loadFailureCount());
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void doMonitor(ServiceEmitter emitter) {
        com.github.benmanes.caffeine.cache.stats.CacheStats oldStats = this.priorStats.get();
        com.github.benmanes.caffeine.cache.stats.CacheStats newStats = this.cache.stats();
        com.github.benmanes.caffeine.cache.stats.CacheStats deltaStats = newStats.minus(oldStats);
        ServiceMetricEvent.Builder builder = ServiceMetricEvent.builder();
        emitter.emit(builder.build("query/cache/caffeine/delta/requests", (Number)deltaStats.requestCount()));
        emitter.emit(builder.build("query/cache/caffeine/total/requests", (Number)newStats.requestCount()));
        emitter.emit(builder.build("query/cache/caffeine/delta/loadTime", (Number)deltaStats.totalLoadTime()));
        emitter.emit(builder.build("query/cache/caffeine/total/loadTime", (Number)newStats.totalLoadTime()));
        emitter.emit(builder.build("query/cache/caffeine/delta/evictionBytes", (Number)deltaStats.evictionWeight()));
        emitter.emit(builder.build("query/cache/caffeine/total/evictionBytes", (Number)newStats.evictionWeight()));
        if (!this.priorStats.compareAndSet(oldStats, newStats)) {
            log.warn((Throwable)new IllegalStateException("Multiple monitors"), "Multiple monitors on the same cache causing race conditions and unreliable stats reporting", new Object[0]);
        }
    }

    @VisibleForTesting
    com.github.benmanes.caffeine.cache.Cache<Cache.NamedKey, byte[]> getCache() {
        return this.cache;
    }

    private byte[] deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int decompressedLen = ByteBuffer.wrap(bytes).getInt();
        byte[] out = new byte[decompressedLen];
        LZ4_DECOMPRESSOR.decompress(bytes, 4, out, 0, out.length);
        return out;
    }

    private byte[] serialize(byte[] value) {
        int len = LZ4_COMPRESSOR.maxCompressedLength(value.length);
        byte[] out = new byte[len];
        int compressedSize = LZ4_COMPRESSOR.compress(value, 0, value.length, out, 0);
        return ByteBuffer.allocate(compressedSize + 4).putInt(value.length).put(out, 0, compressedSize).array();
    }
}

