/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.SegmentDescriptor;
import org.joda.time.Interval;

public class CacheUtil {
    public static Cache.NamedKey computeResultLevelCacheKey(String resultLevelCacheIdentifier) {
        return new Cache.NamedKey(resultLevelCacheIdentifier, StringUtils.toUtf8((String)resultLevelCacheIdentifier));
    }

    public static void populateResultCache(Cache cache, Cache.NamedKey key, byte[] resultBytes) {
        cache.put(key, resultBytes);
    }

    public static Cache.NamedKey computeSegmentCacheKey(String segmentId, SegmentDescriptor descriptor, byte[] queryCacheKey) {
        Interval segmentQueryInterval = descriptor.getInterval();
        byte[] versionBytes = StringUtils.toUtf8((String)descriptor.getVersion());
        return new Cache.NamedKey(segmentId, ByteBuffer.allocate(16 + versionBytes.length + 4 + queryCacheKey.length).putLong(segmentQueryInterval.getStartMillis()).putLong(segmentQueryInterval.getEndMillis()).put(versionBytes).putInt(descriptor.getPartitionNumber()).put(queryCacheKey).array());
    }

    public static <T> boolean isUseSegmentCache(Query<T> query, @Nullable CacheStrategy<T, Object, Query<T>> cacheStrategy, CacheConfig cacheConfig, ServerType serverType) {
        return cacheConfig.isUseCache() && query.context().isUseCache() && CacheUtil.isQueryCacheable(query, cacheStrategy, cacheConfig, serverType);
    }

    public static <T> boolean isPopulateSegmentCache(Query<T> query, @Nullable CacheStrategy<T, Object, Query<T>> cacheStrategy, CacheConfig cacheConfig, ServerType serverType) {
        return CacheUtil.isQueryCacheable(query, cacheStrategy, cacheConfig, serverType) && query.context().isPopulateCache() && cacheConfig.isPopulateCache();
    }

    public static <T> boolean isUseResultCache(Query<T> query, @Nullable CacheStrategy<T, Object, Query<T>> cacheStrategy, CacheConfig cacheConfig, ServerType serverType) {
        return CacheUtil.isQueryCacheable(query, cacheStrategy, cacheConfig, serverType) && query.context().isUseResultLevelCache() && cacheConfig.isUseResultLevelCache();
    }

    public static <T> boolean isPopulateResultCache(Query<T> query, @Nullable CacheStrategy<T, Object, Query<T>> cacheStrategy, CacheConfig cacheConfig, ServerType serverType) {
        return CacheUtil.isQueryCacheable(query, cacheStrategy, cacheConfig, serverType) && query.context().isPopulateResultLevelCache() && cacheConfig.isPopulateResultLevelCache();
    }

    static <T> boolean isQueryCacheable(Query<T> query, @Nullable CacheStrategy<T, Object, Query<T>> cacheStrategy, CacheConfig cacheConfig, ServerType serverType) {
        return cacheStrategy != null && cacheStrategy.isCacheable(query, serverType.willMergeRunners()) && cacheConfig.isQueryCacheable(query) && query.getDataSource().isCacheable(serverType == ServerType.BROKER);
    }

    public static enum ServerType {
        BROKER{

            @Override
            boolean willMergeRunners() {
                return false;
            }
        }
        ,
        DATA{

            @Override
            boolean willMergeRunners() {
                return true;
            }
        };


        abstract boolean willMergeRunners();
    }
}

